/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.Module;
import org.pdfsam.ui.RecentWorkspacesService;
import org.pdfsam.ui.WorkspaceService;
import org.pdfsam.ui.workspace.LoadWorkspaceEvent;
import org.pdfsam.ui.workspace.SaveWorkspaceEvent;
import org.pdfsam.ui.workspace.WorkspaceLoadedEvent;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.injector.Auto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class WorkspaceController {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspaceController.class);
    private List<Module> modules;
    private WorkspaceService service;
    private RecentWorkspacesService recentWorkspace;

    @Inject
    WorkspaceController(List<Module> modules, WorkspaceService service, RecentWorkspacesService recentWorkspace) {
        this.modules = modules;
        this.service = service;
        this.recentWorkspace = recentWorkspace;
        StaticStudio.eventStudio().addAnnotatedListeners(this);
    }

    @EventListener
    public void saveWorkspace(SaveWorkspaceEvent event) {
        LOG.debug(DefaultI18nContext.getInstance().i18n("Requesting modules state"));
        CompletionStage future = ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])this.modules.stream().map(m -> CompletableFuture.runAsync(() -> StaticStudio.eventStudio().broadcast(event, m.id()))).toArray(CompletableFuture[]::new)).thenRun(() -> this.service.saveWorkspace(event.getData(), event.workspace()))).whenComplete((r, e) -> {
            if (Objects.nonNull(e)) {
                LOG.error(DefaultI18nContext.getInstance().i18n("Unable to save modules workspace"), (Throwable)e);
            }
        });
        if (event.awaitCompletion) {
            try {
                ((CompletableFuture)future).get();
            }
            catch (InterruptedException | ExecutionException e2) {
                LOG.error(DefaultI18nContext.getInstance().i18n("Unable to save workspace to {0}", event.workspace().getName()), e2);
            }
        }
    }

    @EventListener
    public CompletableFuture<Void> loadWorspace(LoadWorkspaceEvent event) {
        LOG.debug(DefaultI18nContext.getInstance().i18n("Loading workspace from {0}", event.workspace().getName()));
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.service.loadWorkspace(event.workspace())).thenCompose(data -> {
            if (!data.isEmpty()) {
                event.setData((Map<String, Map<String, String>>)data);
                return CompletableFuture.allOf((CompletableFuture[])this.modules.stream().map(m -> CompletableFuture.runAsync(() -> StaticStudio.eventStudio().broadcast(event, m.id()))).toArray(CompletableFuture[]::new)).thenRun(() -> {
                    this.recentWorkspace.addWorkspaceLastUsed(event.workspace());
                    StaticStudio.eventStudio().broadcast(new WorkspaceLoadedEvent(event.workspace()));
                    LOG.info(DefaultI18nContext.getInstance().i18n("Workspace loaded"));
                });
            }
            return CompletableFuture.completedFuture(null);
        })).whenComplete((r, e) -> {
            if (Objects.nonNull(e)) {
                LOG.error(DefaultI18nContext.getInstance().i18n("Unable to load workspace from {0}", event.workspace().getName()), (Throwable)e);
            }
        });
    }
}

