/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.task;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.ShutdownEvent;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.module.UsageService;
import org.sejda.core.notification.context.GlobalNotificationContext;
import org.sejda.core.service.TaskExecutionService;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.injector.Auto;
import org.sejda.model.notification.EventListener;
import org.sejda.model.notification.event.AbstractNotificationEvent;
import org.sejda.model.notification.event.PercentageOfWorkDoneChangedEvent;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;
import org.sejda.model.notification.event.TaskExecutionStartedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class TaskExecutionController {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutionController.class);
    private TaskExecutionService executionService;
    private UsageService usageService;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private String currentModule = "";

    @Inject
    public TaskExecutionController(TaskExecutionService executionService, UsageService usageService) {
        this.executionService = executionService;
        this.usageService = usageService;
        StaticStudio.eventStudio().addAnnotatedListeners(this);
        GlobalNotificationContext.getContext().addListener(TaskExecutionFailedEvent.class, new TaskEventBroadcaster());
        GlobalNotificationContext.getContext().addListener(TaskExecutionStartedEvent.class, new TaskEventBroadcaster());
        GlobalNotificationContext.getContext().addListener(TaskExecutionCompletedEvent.class, new TaskEventBroadcaster());
        GlobalNotificationContext.getContext().addListener(PercentageOfWorkDoneChangedEvent.class, new TaskEventBroadcaster());
    }

    @org.sejda.eventstudio.annotation.EventListener(priority=0x7FFFFFFF)
    public void request(TaskExecutionRequestEvent event) {
        LOG.trace("Task execution request received");
        this.usageService.incrementUsageFor(event.getModuleId());
        this.currentModule = event.getModuleId();
        this.executor.execute(() -> this.executionService.execute(event.getParameters()));
        LOG.trace("Task execution submitted");
    }

    @org.sejda.eventstudio.annotation.EventListener
    public void onShutdown(ShutdownEvent event) {
        this.executor.shutdownNow();
    }

    class TaskEventBroadcaster<T extends AbstractNotificationEvent>
    implements EventListener<T> {
        TaskEventBroadcaster() {
        }

        @Override
        public void onEvent(T event) {
            Platform.runLater(() -> StaticStudio.eventStudio().broadcast(event));
            if (StringUtils.isNoneBlank(TaskExecutionController.this.currentModule)) {
                Platform.runLater(() -> StaticStudio.eventStudio().broadcast(event, TaskExecutionController.this.currentModule));
            }
        }
    }
}

