/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.support.params;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.conversion.AdapterUtils;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.pdf.page.PageRange;

public final class ConversionUtils {
    private ConversionUtils() {
    }

    public static Set<PageRange> toPageRangeSet(String selection) throws ConversionException {
        if (StringUtils.isNotBlank(selection)) {
            String[] tokens;
            NullSafeSet<PageRange> pageRangeSet = new NullSafeSet<PageRange>();
            for (String current : tokens = AdapterUtils.splitAndTrim(selection, ",")) {
                PageRange range = ConversionUtils.toPageRange(current);
                if (range.getEnd() < range.getStart()) {
                    throw new ConversionException(DefaultI18nContext.getInstance().i18n("Invalid range: {0}.", range.toString()));
                }
                pageRangeSet.add(range);
            }
            return pageRangeSet;
        }
        return Collections.emptySet();
    }

    private static PageRange toPageRange(String value) throws ConversionException {
        String[] limits = AdapterUtils.splitAndTrim(value, "-");
        if (limits.length > 2) {
            throw new ConversionException(DefaultI18nContext.getInstance().i18n("Ambiguous page range definition: {0}. Use following formats: [n] or [n1-n2] or [-n] or [n-]", value));
        }
        if (limits.length == 1) {
            int limitNumber = ConversionUtils.parsePageNumber(limits[0]);
            if (value.endsWith("-")) {
                return new PageRange(limitNumber);
            }
            if (value.startsWith("-")) {
                return new PageRange(1, limitNumber);
            }
            return new PageRange(limitNumber, limitNumber);
        }
        return new PageRange(ConversionUtils.parsePageNumber(limits[0]), ConversionUtils.parsePageNumber(limits[1]));
    }

    private static int parsePageNumber(String value) throws ConversionException {
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ConversionException(DefaultI18nContext.getInstance().i18n("Invalid number: {0}.", value));
        }
    }
}

