/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.splitbybookmarks;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.control.ComboBox;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.splitbybookmarks.SplitByOutlineLevelParametersBuilder;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.support.validation.Validators;
import org.pdfsam.ui.support.FXValidationSupport;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.RestorableView;

class BookmarksLevelComboBox
extends ComboBox<String>
implements TaskParametersBuildStep<SplitByOutlineLevelParametersBuilder>,
RestorableView {
    private final FXValidationSupport<String> validationSupport = new FXValidationSupport();

    BookmarksLevelComboBox() {
        this.validationSupport.setValidator(Validators.alwaysFalse());
        this.setEditable(true);
        this.getSelectionModel().selectFirst();
        this.valueProperty().addListener((o, oldVal, newVal) -> this.validate());
        this.validationSupport.validationStateProperty().addListener(o -> {
            if (this.validationSupport.validationStateProperty().get() == FXValidationSupport.ValidationState.INVALID) {
                this.getEditor().getStyleClass().addAll((Object[])Style.INVALID.css());
            } else {
                this.getEditor().getStyleClass().removeAll((Object[])Style.INVALID.css());
            }
        });
        this.getEditor().focusedProperty().addListener((obs, old, isFocused) -> {
            String newVal;
            if (!isFocused.booleanValue() && Objects.nonNull(newVal = this.getEditor().getText()) && !newVal.equals(this.getValue())) {
                this.setValue(newVal);
            }
        });
    }

    public void setValidBookmarkLevels(SortedSet<Integer> levels) {
        this.getItems().clear();
        if (Objects.nonNull(levels)) {
            this.validationSupport.setValidator(Validators.containedInteger(levels));
            levels.stream().map(i -> i.toString()).forEach(arg_0 -> this.getItems().add(arg_0));
        } else {
            this.validationSupport.setValidator(Validators.alwaysFalse());
        }
    }

    public final FXValidationSupport.ValidationState getValidationState() {
        return (FXValidationSupport.ValidationState)((Object)this.validationSupport.validationStateProperty().get());
    }

    public final ReadOnlyObjectProperty<FXValidationSupport.ValidationState> validProperty() {
        return this.validationSupport.validationStateProperty();
    }

    public void validate() {
        this.validationSupport.validate((String)this.getValue());
    }

    @Override
    public void apply(SplitByOutlineLevelParametersBuilder builder, Consumer<String> onError) {
        this.validate();
        if (this.validationSupport.validationStateProperty().get() == FXValidationSupport.ValidationState.VALID) {
            builder.level(Integer.parseInt((String)this.getValue()));
        } else {
            onError.accept(DefaultI18nContext.getInstance().i18n("Invalid bookmarks level"));
        }
    }

    @Override
    public void saveStateTo(Map<String, String> data) {
        data.put("levelCombo.levels", this.getItems().stream().collect(Collectors.joining(",")));
        data.put("levelCombo.selected", (String)Optional.ofNullable(this.getValue()).orElse(""));
    }

    @Override
    public void restoreStateFrom(Map<String, String> data) {
        this.getSelectionModel().selectFirst();
        Optional.ofNullable(data.get("levelCombo.max")).map(Integer::valueOf).ifPresent(max -> IntStream.rangeClosed(1, max).mapToObj(Integer::toString).forEach(arg_0 -> this.getItems().add(arg_0)));
        Arrays.stream((Object[])Optional.ofNullable(data.get("levelCombo.levels")).map(l -> l.split(",")).orElse(new String[0])).forEach(arg_0 -> this.getItems().add(arg_0));
        this.setValue(Optional.ofNullable(data.get("levelCombo.selected")).orElse(""));
    }
}

