/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.split;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.control.RadioButton;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.split.SplitParametersBuilderCreator;
import org.pdfsam.support.params.SplitParametersBuilder;
import org.pdfsam.support.validation.Validators;
import org.pdfsam.ui.commons.ValidableTextField;
import org.pdfsam.ui.support.FXValidationSupport;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.conversion.PageNumbersListAdapter;
import org.sejda.model.parameter.SplitByPagesParameters;

class SplitAfterRadioButton
extends RadioButton
implements SplitParametersBuilderCreator,
RestorableView {
    private final ValidableTextField field;

    public SplitAfterRadioButton(ValidableTextField field) {
        super(DefaultI18nContext.getInstance().i18n("Split after the following page numbers"));
        this.field = field;
        this.field.setOnEnterValidation(true);
        this.field.setEnableInvalidStyle(true);
        this.field.setPromptText(DefaultI18nContext.getInstance().i18n("Page numbers to split at (n1,n2,n3..)"));
        this.field.setValidator(Validators.regexMatching("^([1-9]\\d*(\\s*,\\s*)?)+$"));
        this.field.setErrorMessage(DefaultI18nContext.getInstance().i18n("Invalid page numbers"));
    }

    public SplitByPageParametersBuilder getBuilder(Consumer<String> onError) {
        this.field.validate();
        if (this.field.getValidationState() == FXValidationSupport.ValidationState.VALID) {
            return new SplitByPageParametersBuilder(new PageNumbersListAdapter(this.field.getText()).getPageNumbers());
        }
        onError.accept(DefaultI18nContext.getInstance().i18n("Only valid positive page numbers are allowed"));
        return null;
    }

    @Override
    public void saveStateTo(Map<String, String> data) {
        if (this.isSelected()) {
            data.put("splitAfter", Boolean.TRUE.toString());
        }
        data.put("splitAfter.field", StringUtils.defaultString(this.field.getText()));
    }

    @Override
    public void restoreStateFrom(Map<String, String> data) {
        Optional.ofNullable(data.get("splitAfter")).map(Boolean::valueOf).ifPresent(arg_0 -> ((SplitAfterRadioButton)this).setSelected(arg_0));
        this.field.setText(Optional.ofNullable(data.get("splitAfter.field")).orElse(""));
    }

    static class SplitByPageParametersBuilder
    extends SplitParametersBuilder<SplitByPagesParameters> {
        private List<Integer> pages;

        SplitByPageParametersBuilder(List<Integer> pages) {
            this.pages = pages;
        }

        @Override
        public SplitByPagesParameters build() {
            SplitByPagesParameters params = new SplitByPagesParameters();
            params.addPages(this.pages);
            params.setCompress(this.isCompress());
            params.setExistingOutputPolicy(this.existingOutput());
            params.setVersion(this.getVersion());
            params.setOutput(this.getOutput());
            params.setOutputPrefix(this.getPrefix());
            params.addSource(this.getSource());
            params.setOptimizationPolicy(this.getOptimizationPolicy());
            params.discardOutline(this.isDiscardBookmarks());
            return params;
        }
    }
}

