/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.split;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SingleSelectionModel;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.split.SplitParametersBuilderCreator;
import org.pdfsam.support.KeyStringValueItem;
import org.pdfsam.support.params.SplitParametersBuilder;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.model.parameter.SimpleSplitParameters;
import org.sejda.model.pdf.page.PredefinedSetOfPages;

class SplitAfterPredefinedSetOfPagesRadioButton
extends RadioButton
implements SplitParametersBuilderCreator,
RestorableView {
    private ComboBox<KeyStringValueItem<PredefinedSetOfPages>> combo;

    public SplitAfterPredefinedSetOfPagesRadioButton(ComboBox<KeyStringValueItem<PredefinedSetOfPages>> combo) {
        super(DefaultI18nContext.getInstance().i18n("Split after"));
        this.combo = combo;
        combo.getSelectionModel().selectFirst();
    }

    public SimpleSplitParametersBuilder getBuilder(Consumer<String> onError) {
        KeyStringValueItem selected = (KeyStringValueItem)this.combo.getSelectionModel().getSelectedItem();
        if (selected != null) {
            return new SimpleSplitParametersBuilder((PredefinedSetOfPages)selected.getKey());
        }
        onError.accept(DefaultI18nContext.getInstance().i18n("No page selected"));
        return null;
    }

    @Override
    public void saveStateTo(Map<String, String> data) {
        KeyStringValueItem selected;
        if (this.isSelected()) {
            data.put("splitAfterPredefined", Boolean.TRUE.toString());
        }
        if ((selected = (KeyStringValueItem)this.combo.getSelectionModel().getSelectedItem()) != null) {
            data.put("splitAfterPredefined.combo", StringUtils.defaultString(((PredefinedSetOfPages)selected.getKey()).toString()));
        }
    }

    @Override
    public void restoreStateFrom(Map<String, String> data) {
        Optional.ofNullable(data.get("splitAfterPredefined")).map(Boolean::valueOf).ifPresent(arg_0 -> ((SplitAfterPredefinedSetOfPagesRadioButton)this).setSelected(arg_0));
        Optional.ofNullable(data.get("splitAfterPredefined.combo")).map(PredefinedSetOfPages::valueOf).map(KeyStringValueItem::keyEmptyValue).ifPresent(arg_0 -> ((SingleSelectionModel)this.combo.getSelectionModel()).select(arg_0));
    }

    static class SimpleSplitParametersBuilder
    extends SplitParametersBuilder<SimpleSplitParameters> {
        private PredefinedSetOfPages pages;

        SimpleSplitParametersBuilder(PredefinedSetOfPages pages) {
            this.pages = pages;
        }

        @Override
        public SimpleSplitParameters build() {
            SimpleSplitParameters params = new SimpleSplitParameters(this.pages);
            params.setCompress(this.isCompress());
            params.setExistingOutputPolicy(this.existingOutput());
            params.setVersion(this.getVersion());
            params.setOutput(this.getOutput());
            params.setOutputPrefix(this.getPrefix());
            params.addSource(this.getSource());
            params.setOptimizationPolicy(this.getOptimizationPolicy());
            params.discardOutline(this.isDiscardBookmarks());
            return params;
        }
    }
}

