/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.premium;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.pdfsam.ConfigurableProperty;
import org.pdfsam.Pdfsam;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.premium.PremiumModule;
import org.pdfsam.premium.PremiumModulesService;
import org.pdfsam.support.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPremiumModulesService
implements PremiumModulesService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPremiumModulesService.class);
    private Pdfsam pdfsam;

    @Inject
    DefaultPremiumModulesService(Pdfsam pdfsam) {
        RequireUtils.requireNotNull(pdfsam, "Application info cannot be null");
        this.pdfsam = pdfsam;
    }

    @Override
    public List<PremiumModule> getPremiumModules() {
        try {
            return JSON.std.with(JSON.Feature.READ_ONLY, true).listOfFrom(PremiumModule.class, new URL(this.pdfsam.property(ConfigurableProperty.PREMIUM_MODULES_URL)));
        }
        catch (IOException e) {
            LOG.warn(DefaultI18nContext.getInstance().i18n("Unable to retrieve premium features description"), e);
            return Collections.emptyList();
        }
    }
}

