/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.pdf;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javafx.application.Platform;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.RequiredPdfData;
import org.pdfsam.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.pdf.PdfDocumentDescriptor;
import org.pdfsam.pdf.PdfLoadService;
import org.pdfsam.pdf.PdfLoader;
import org.sejda.io.BufferedSeekableSource;
import org.sejda.io.FileChannelSeekableSource;
import org.sejda.io.SeekableSource;
import org.sejda.sambox.input.PDFParser;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.encryption.InvalidPasswordException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SAMBoxPdfLoadService
implements PdfLoadService {
    private static final Logger LOG = LoggerFactory.getLogger(SAMBoxPdfLoadService.class);
    private final Map<RequiredPdfData, BiConsumer<PDDocument, PdfDocumentDescriptor>> consumers = new HashMap<RequiredPdfData, BiConsumer<PDDocument, PdfDocumentDescriptor>>();
    private static final BiConsumer<PDDocument, PdfDocumentDescriptor> STARTER = (r, descriptor) -> {};
    private static final BiConsumer<PDDocument, PdfDocumentDescriptor> FINISHER = (r, descriptor) -> {
        if (descriptor.hasPassword()) {
            SAMBoxPdfLoadService.fxMoveStatusTo(descriptor, PdfDescriptorLoadingStatus.LOADED_WITH_USER_PWD_DECRYPTION);
        } else {
            SAMBoxPdfLoadService.fxMoveStatusTo(descriptor, PdfDescriptorLoadingStatus.LOADED);
        }
    };

    public SAMBoxPdfLoadService(List<PdfLoader<PDDocument>> loaders) {
        loaders.forEach(l -> this.consumers.put(l.key(), (BiConsumer<PDDocument, PdfDocumentDescriptor>)l));
    }

    @Override
    public void load(Collection<? extends PdfDocumentDescriptor> toLoad, RequiredPdfData ... requires) {
        LOG.debug(DefaultI18nContext.getInstance().i18n("Loading pdf documents"));
        BiConsumer<PDDocument, PdfDocumentDescriptor> consumer = Arrays.stream(requires).map(this.consumers::get).reduce(STARTER, (r, d) -> r.andThen(d)).andThen(FINISHER);
        for (PdfDocumentDescriptor pdfDocumentDescriptor : toLoad) {
            if (pdfDocumentDescriptor.hasReferences()) {
                LOG.trace("Loading {}", (Object)pdfDocumentDescriptor.getFileName());
                SAMBoxPdfLoadService.fxMoveStatusTo(pdfDocumentDescriptor, PdfDescriptorLoadingStatus.LOADING);
                try (PDDocument document = PDFParser.parse((SeekableSource)new BufferedSeekableSource(new FileChannelSeekableSource(pdfDocumentDescriptor.getFile())), pdfDocumentDescriptor.getPassword());){
                    consumer.accept(document, pdfDocumentDescriptor);
                }
                catch (InvalidPasswordException twpe) {
                    SAMBoxPdfLoadService.fxMoveStatusTo(pdfDocumentDescriptor, PdfDescriptorLoadingStatus.ENCRYPTED);
                    LOG.warn("User password required for '{}'", (Object)pdfDocumentDescriptor.getFileName(), (Object)twpe);
                }
                catch (Exception e) {
                    LOG.error("An error occured loading the document '{}'", (Object)pdfDocumentDescriptor.getFileName(), (Object)e);
                    SAMBoxPdfLoadService.fxMoveStatusTo(pdfDocumentDescriptor, PdfDescriptorLoadingStatus.WITH_ERRORS);
                }
                LOG.info("{} loaded", (Object)pdfDocumentDescriptor.getFileName());
                continue;
            }
            LOG.trace("Skipping invalidated document {}", (Object)pdfDocumentDescriptor.getFileName());
        }
        LOG.debug(DefaultI18nContext.getInstance().i18n("Documents loaded"));
    }

    private static void fxMoveStatusTo(PdfDocumentDescriptor descriptor, PdfDescriptorLoadingStatus status) {
        Platform.runLater(() -> descriptor.moveStatusTo(status));
    }
}

