/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.pdf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.pdfsam.ShutdownEvent;
import org.pdfsam.module.Module;
import org.pdfsam.module.RequiredPdfData;
import org.pdfsam.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.pdf.PdfLoadRequestEvent;
import org.pdfsam.pdf.PdfLoadService;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.injector.Auto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class PdfLoadController {
    private static final Logger LOG = LoggerFactory.getLogger(PdfLoadController.class);
    private PdfLoadService loadService;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Map<String, RequiredPdfData[]> requiredLoadData = new HashMap<String, RequiredPdfData[]>();

    @Inject
    public PdfLoadController(List<Module> modules, PdfLoadService loadService) {
        this.loadService = loadService;
        modules.forEach(m -> this.requiredLoadData.put(m.id(), m.requires()));
        StaticStudio.eventStudio().addAnnotatedListeners(this);
    }

    @EventListener
    public void request(PdfLoadRequestEvent event) {
        LOG.trace("Pdf load request received");
        event.getDocuments().forEach(i -> i.moveStatusTo(PdfDescriptorLoadingStatus.REQUESTED));
        this.executor.execute(() -> this.loadService.load(event.getDocuments(), this.requiredLoadData.get(event.getOwnerModule())));
    }

    @EventListener
    public void onShutdown(ShutdownEvent event) {
        this.executor.shutdownNow();
    }
}

