/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.module;

import org.apache.commons.lang3.StringUtils;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModuleDescriptor;
import org.pdfsam.module.ModuleInputOutputType;
import org.pdfsam.module.ModulePriority;
import org.pdfsam.support.RequireUtils;

public final class ModuleDescriptorBuilder {
    private ModuleCategory category;
    private ModuleInputOutputType[] inputTypes;
    private String name;
    private String description;
    private int priority = ModulePriority.DEFAULT.getPriority();
    private String supportURL;

    private ModuleDescriptorBuilder() {
    }

    public ModuleDescriptorBuilder category(ModuleCategory category) {
        this.category = category;
        return this;
    }

    public ModuleDescriptorBuilder inputTypes(ModuleInputOutputType ... inputTypes) {
        this.inputTypes = inputTypes;
        return this;
    }

    public ModuleDescriptorBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ModuleDescriptorBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ModuleDescriptorBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ModuleDescriptorBuilder priority(ModulePriority priority) {
        this.priority = priority.getPriority();
        return this;
    }

    public ModuleDescriptorBuilder supportURL(String supportURL) {
        this.supportURL = supportURL;
        return this;
    }

    public static ModuleDescriptorBuilder builder() {
        return new ModuleDescriptorBuilder();
    }

    public ModuleDescriptor build() {
        RequireUtils.requireNotNull((Object)this.category, "Module category cannot be null");
        RequireUtils.require(StringUtils.isNotBlank(this.name), "Module name cannot be blank");
        RequireUtils.require(StringUtils.isNotBlank(this.description), "Module description cannot be blank");
        return new ModuleDescriptor(this.category, this.name, this.description, this.priority, this.supportURL, this.inputTypes);
    }
}

