/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.merge;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.merge.MergeParametersBuilder;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.selection.multiple.FileColumn;
import org.pdfsam.ui.selection.multiple.IntColumn;
import org.pdfsam.ui.selection.multiple.LoadingColumn;
import org.pdfsam.ui.selection.multiple.LongColumn;
import org.pdfsam.ui.selection.multiple.MultipleSelectionPane;
import org.pdfsam.ui.selection.multiple.PageRangesColumn;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.input.PdfMergeInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeSelectionPane
extends MultipleSelectionPane
implements TaskParametersBuildStep<MergeParametersBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(MergeSelectionPane.class);

    public MergeSelectionPane(String ownerModule) {
        super(ownerModule, true, true, new LoadingColumn(ownerModule), FileColumn.NAME, LongColumn.SIZE, IntColumn.PAGES, LongColumn.LAST_MODIFIED, new PageRangesColumn(DefaultI18nContext.getInstance().i18n("Double click to set pages you want to merge (ex: 2 or 5-23 or 2,5-7,12-)")));
    }

    @Override
    public void apply(MergeParametersBuilder builder, Consumer<String> onError) {
        try {
            this.table().getItems().stream().filter(s -> !Objects.equals("0", StringUtils.trim(s.pageSelection.get()))).map(i -> new PdfMergeInput(i.descriptor().toPdfFileSource(), i.toPageRangeSet())).forEach(builder::addInput);
            if (!builder.hasInput()) {
                onError.accept(DefaultI18nContext.getInstance().i18n("No PDF document has been selected"));
            }
        }
        catch (ConversionException e) {
            LOG.error(e.getMessage());
            onError.accept(e.getMessage());
        }
    }
}

