/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.extract;

import java.util.function.Consumer;
import org.pdfsam.extract.ExtractParametersBuilder;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.selection.multiple.FileColumn;
import org.pdfsam.ui.selection.multiple.IntColumn;
import org.pdfsam.ui.selection.multiple.LoadingColumn;
import org.pdfsam.ui.selection.multiple.LongColumn;
import org.pdfsam.ui.selection.multiple.MultipleSelectionPane;
import org.sejda.conversion.exception.ConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractSelectionPane
extends MultipleSelectionPane
implements TaskParametersBuildStep<ExtractParametersBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractSelectionPane.class);

    public ExtractSelectionPane(String ownerModule) {
        super(ownerModule, false, false, new LoadingColumn(ownerModule), FileColumn.NAME, LongColumn.SIZE, IntColumn.PAGES, LongColumn.LAST_MODIFIED);
    }

    @Override
    public void apply(ExtractParametersBuilder builder, Consumer<String> onError) {
        try {
            this.table().getItems().stream().forEach(i -> builder.addSource(i.descriptor().toPdfFileSource()));
            if (!builder.hasInput()) {
                onError.accept(DefaultI18nContext.getInstance().i18n("No PDF document has been selected"));
            }
        }
        catch (ConversionException e) {
            LOG.error(e.getMessage());
            onError.accept(e.getMessage());
        }
    }
}

