/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.extract;

import java.util.Set;
import org.pdfsam.support.params.MultiplePdfSourceMultipleOutputParametersBuilder;
import org.sejda.model.optimization.OptimizationPolicy;
import org.sejda.model.parameter.ExtractPagesParameters;
import org.sejda.model.pdf.page.PageRange;

class ExtractParametersBuilder
extends MultiplePdfSourceMultipleOutputParametersBuilder<ExtractPagesParameters> {
    private OptimizationPolicy optimizationPolicy = OptimizationPolicy.AUTO;
    private Set<PageRange> ranges;
    private boolean invertSelection = false;

    ExtractParametersBuilder() {
    }

    public void optimizationPolicy(OptimizationPolicy optimizationPolicy) {
        this.optimizationPolicy = optimizationPolicy;
    }

    public OptimizationPolicy getOptimizationPolicy() {
        if (!Boolean.getBoolean("org.pdfsam.disable.split.optimization")) {
            return this.optimizationPolicy;
        }
        return OptimizationPolicy.NO;
    }

    public void ranges(Set<PageRange> ranges) {
        this.ranges = ranges;
    }

    public void invertSelection(boolean invertSelection) {
        this.invertSelection = invertSelection;
    }

    @Override
    public ExtractPagesParameters build() {
        ExtractPagesParameters params = new ExtractPagesParameters();
        params.setCompress(this.isCompress());
        params.setExistingOutputPolicy(this.existingOutput());
        params.setVersion(this.getVersion());
        params.setOutput(this.getOutput());
        params.setOptimizationPolicy(this.getOptimizationPolicy());
        params.discardOutline(this.isDiscardBookmarks());
        params.addAllPageRanges(this.ranges);
        params.setOutputPrefix(this.getPrefix());
        params.setInvertSelection(this.invertSelection);
        this.getInputs().forEach(params::addSource);
        return params;
    }
}

