/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.community;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.pdfsam.ConfigurableProperty;
import org.pdfsam.Pdfsam;
import org.pdfsam.support.RequireUtils;

public class PdfsamCommunity
implements Pdfsam {
    private Properties properties = new Properties();
    private String name;
    private String shortName;

    public PdfsamCommunity(String name, String shortName) throws IOException {
        RequireUtils.requireNotBlank(name, "Application name cannot be blank");
        RequireUtils.requireNotBlank(shortName, "Application short name cannot be blank");
        this.name = name;
        this.shortName = shortName;
        try (InputStream stream = this.getClass().getResourceAsStream("/pdfsam.properties");){
            this.properties.load(stream);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String property(ConfigurableProperty prop, String defaultValue) {
        return this.properties.getProperty(prop.prop, defaultValue);
    }

    @Override
    public String property(ConfigurableProperty prop) {
        return this.properties.getProperty(prop.prop, "");
    }
}

