/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.alternatemix;

import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.alternatemix.AlternateMixParametersBuilder;
import org.pdfsam.alternatemix.AlternateMixSelectionPane;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModuleDescriptor;
import org.pdfsam.module.ModuleDescriptorBuilder;
import org.pdfsam.module.ModuleInputOutputType;
import org.pdfsam.module.ModulePriority;
import org.pdfsam.ui.commons.ClearModuleEvent;
import org.pdfsam.ui.io.BrowsableField;
import org.pdfsam.ui.io.BrowsablePdfOutputField;
import org.pdfsam.ui.io.PdfDestinationPane;
import org.pdfsam.ui.module.BaseTaskExecutionModule;
import org.pdfsam.ui.module.Footer;
import org.pdfsam.ui.module.OpenButton;
import org.pdfsam.ui.module.RunButton;
import org.pdfsam.ui.support.Views;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.injector.Auto;
import org.sejda.injector.Components;
import org.sejda.injector.Provides;

@Auto
public class AlternateMixModule
extends BaseTaskExecutionModule {
    private static final String MODULE_ID = "alternatemix";
    private AlternateMixSelectionPane selectionPane = new AlternateMixSelectionPane("alternatemix");
    private BrowsablePdfOutputField destinationFileField;
    private PdfDestinationPane destinationPane;
    private ModuleDescriptor descriptor = ModuleDescriptorBuilder.builder().category(ModuleCategory.MERGE).inputTypes(ModuleInputOutputType.MULTIPLE_PDF).name(DefaultI18nContext.getInstance().i18n("Alternate Mix")).description(DefaultI18nContext.getInstance().i18n("Merge two or more PDF documents taking pages alternately in natural or reverse order.")).priority(ModulePriority.DEFAULT.getPriority()).supportURL("http://www.pdfsam.org/mix-pdf/").build();

    @Inject
    public AlternateMixModule(@Named(value="alternatemixfield") BrowsablePdfOutputField destinationFileField, @Named(value="alternatemixpane") PdfDestinationPane destinationPane, @Named(value="alternatemixfooter") Footer footer) {
        super(footer);
        this.destinationFileField = destinationFileField;
        this.destinationPane = destinationPane;
        this.initModuleSettingsPanel(this.settingPanel());
    }

    @Override
    public ModuleDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.destinationFileField.saveStateTo((Map)data);
        this.destinationPane.saveStateTo(data);
    }

    @Override
    public void onLoadWorkspace(Map<String, String> data) {
        if (data.containsKey("firstDocumentMixinput")) {
            data.put("input.0", data.get("firstDocumentMixinput"));
            data.put("input.password.0", data.get("firstDocumentMixinputinput.password"));
            data.put("input.step.0", data.get("firstStep"));
            data.put("input.reverse.0", data.get("reverseFirst"));
            data.put("input.size", "1");
            if (data.containsKey("secondDocumentMixinput")) {
                data.put("input.1", data.get("secondDocumentMixinput"));
                data.put("input.password.1", data.get("secondDocumentMixinput.password"));
                data.put("input.step.1", data.get("secondStep"));
                data.put("input.reverse.1", data.get("reverseSecond"));
                data.put("input.size", "2");
            }
        }
        this.selectionPane.restoreStateFrom(data);
        this.destinationFileField.restoreStateFrom((Map)data);
        this.destinationPane.restoreStateFrom(data);
    }

    private VBox settingPanel() {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)this.selectionPane, (Priority)Priority.ALWAYS);
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane(DefaultI18nContext.getInstance().i18n("Destination file"), (Node)this.destinationPane)});
        return pane;
    }

    @Override
    @EventStation
    public String id() {
        return MODULE_ID;
    }

    @EventListener
    public void onClearModule(ClearModuleEvent e) {
        if (e.clearEverything) {
            this.destinationPane.resetView();
        }
    }

    @Override
    public Node graphic() {
        return new ImageView("alternate_mix.png");
    }

    protected AlternateMixParametersBuilder getBuilder(Consumer<String> onError) {
        AlternateMixParametersBuilder builder = new AlternateMixParametersBuilder();
        this.selectionPane.apply(builder, onError);
        this.destinationFileField.apply(builder, onError);
        this.destinationPane.apply(builder, onError);
        return builder;
    }

    @Components(value={AlternateMixModule.class})
    public static class ModuleConfig {
        @Provides
        @Named(value="alternatemixfield")
        public BrowsablePdfOutputField destinationFileField() {
            return new BrowsablePdfOutputField();
        }

        @Provides
        @Named(value="alternatemixpane")
        public PdfDestinationPane destinationPane(@Named(value="alternatemixfield") BrowsablePdfOutputField outputField, UserContext userContext) {
            return new PdfDestinationPane((BrowsableField)outputField, AlternateMixModule.MODULE_ID, userContext, new PdfDestinationPane.DestinationPanelFields[0]);
        }

        @Provides
        @Named(value="alternatemixfooter")
        public Footer footer(RunButton runButton, @Named(value="alternatemixopenButton") OpenButton openButton) {
            return new Footer(runButton, openButton, AlternateMixModule.MODULE_ID);
        }

        @Provides
        @Named(value="alternatemixopenButton")
        public OpenButton openButton() {
            return new OpenButton(AlternateMixModule.MODULE_ID, ModuleInputOutputType.SINGLE_PDF);
        }
    }
}

