/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.manager.preferences;

import java.util.Collection;
import org.eclipse.jface.preference.IPreferenceStore;
import org.soyatec.connector.api.ui.config.i2c.I2cSetting;
import org.soyatec.connector.api.ui.config.serial.SerialSettings;
import org.soyatec.connector.api.ui.config.telnet.TelnetSetting;
import org.soyatec.connector.manager.Activator;
import org.soyatec.connector.manager.ConnectionManager;
import org.soyatec.connector.manager.IConnectorSetting;
import org.soyatec.connector.manager.i2c.I2cConnectorSetting;
import org.soyatec.connector.manager.serial.SerialConnectorSetting;
import org.soyatec.connector.manager.telnet.TelnetConnectorSetting;

public class Preferences {
    static String CONNECTOR_SETTINGS = "Connector Settings";
    static String CONNECTOR_SEPARATOR = "@#;#@";
    static String ATTRIBUTE_SEPARATOR = "@#@#@";
    static String ID_SERIAL = "SerialConnectorSetting";
    static String ID_TELNET = "TelnetConnectorSetting";
    static String ID_I2C = "I2cConnectorSetting";
    static IPreferenceStore store = Activator.getDefault().getPreferenceStore();

    public static IPreferenceStore getPreferenceStore() {
        return store;
    }

    public static void saveConnectorSettings() {
        StringBuilder sb = new StringBuilder();
        ConnectionManager m = ConnectionManager.INSTANCE;
        Collection<IConnectorSetting> allConnectionSettings = m.getAllConnectionSettings();
        for (IConnectorSetting connectorSetting : allConnectionSettings) {
            if (connectorSetting == null) continue;
            String createString = Preferences.createString(connectorSetting.getID(), connectorSetting);
            if (sb.length() > 0) {
                sb.append(CONNECTOR_SEPARATOR);
            }
            sb.append(createString);
        }
        store.putValue(CONNECTOR_SETTINGS, sb.toString());
    }

    public static void loadConnectorSettings() {
        String[] split;
        String string = store.getString(CONNECTOR_SETTINGS);
        if (string == null) {
            return;
        }
        String[] stringArray = split = string.split(CONNECTOR_SEPARATOR);
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String setStr = stringArray[n2];
            String[] ps = setStr.split(ATTRIBUTE_SEPARATOR);
            Preferences.createAndAddConnectorSetting(ps);
            ++n2;
        }
    }

    private static void createAndAddConnectorSetting(String[] ps) {
        if (ps.length != 4) {
            return;
        }
        String key = ps[0];
        String type = ps[1];
        String name = ps[2];
        String[] split = ps[3].split(",");
        if (ID_SERIAL.equals(type) && split.length == 7) {
            SerialConnectorSetting setting = new SerialConnectorSetting();
            setting.setID(key);
            setting.setName(name);
            SerialSettings serialSettings = setting.getSerialSettings();
            serialSettings.setSerialPort(split[0]);
            serialSettings.setBaudRate(split[1]);
            serialSettings.setDataBits(split[2]);
            serialSettings.setFlowControl(split[3]);
            serialSettings.setParity(split[4]);
            serialSettings.setStopBits(split[5]);
            serialSettings.setTimeout(split[6]);
            ConnectionManager.INSTANCE.addConnectionSettings(setting);
        } else if (ID_TELNET.equals(type) && split.length == 8) {
            TelnetConnectorSetting setting = new TelnetConnectorSetting();
            setting.setID(key);
            setting.setName(name);
            TelnetSetting telnetSetting = setting.getTelnetSetting();
            telnetSetting.setHost(split[0]);
            telnetSetting.setNetworkPort(split[1]);
            telnetSetting.setTimeout(split[2]);
            telnetSetting.setCommandPrompt(split[3]);
            telnetSetting.setLoginPrompt(split[4]);
            telnetSetting.setPasswordPrompt(split[5]);
            telnetSetting.setPassword(split[6]);
            telnetSetting.setLoginName(split[7]);
            ConnectionManager.INSTANCE.addConnectionSettings(setting);
        } else if (ID_I2C.equals(type) && split.length == 2) {
            I2cConnectorSetting setting = new I2cConnectorSetting();
            setting.setID(key);
            setting.setName(name);
            I2cSetting i2cSettings = setting.getI2cSettings();
            i2cSettings.setfBaudRate(split[0]);
            i2cSettings.setfDeviceAddress(split[1]);
        }
    }

    private static String createString(String key, IConnectorSetting setting) {
        StringBuilder sb = new StringBuilder();
        if (setting instanceof SerialConnectorSetting) {
            SerialConnectorSetting serialsetting = (SerialConnectorSetting)setting;
            sb.append(key).append(ATTRIBUTE_SEPARATOR).append(ID_SERIAL).append(ATTRIBUTE_SEPARATOR).append(setting.getName()).append(ATTRIBUTE_SEPARATOR);
            SerialSettings serialSettings = serialsetting.getSerialSettings();
            sb.append(serialSettings.getSerialPort()).append(",");
            sb.append(serialSettings.getBaudRateString()).append(",");
            sb.append(serialSettings.getDataBitsString()).append(",");
            sb.append(serialSettings.getFlowControlString()).append(",");
            sb.append(serialSettings.getParityString()).append(",");
            sb.append(serialSettings.getStopBitsString()).append(",");
            sb.append(serialSettings.getTimeoutString());
        } else if (setting instanceof TelnetConnectorSetting) {
            TelnetConnectorSetting telnetConnectorSetting = (TelnetConnectorSetting)setting;
            sb.append(key).append(ATTRIBUTE_SEPARATOR).append(ID_TELNET).append(ATTRIBUTE_SEPARATOR).append(setting.getName()).append(ATTRIBUTE_SEPARATOR);
            TelnetSetting telnetSetting = telnetConnectorSetting.getTelnetSetting();
            sb.append(telnetSetting.getHost()).append(",");
            sb.append(telnetSetting.getNetworkPortString()).append(",");
            sb.append(telnetSetting.getTimeoutString()).append(",");
            sb.append(telnetSetting.getCommandPrompt()).append(",");
            sb.append(telnetSetting.getLoginPrompt()).append(",");
            sb.append(telnetSetting.getPasswordPrompt()).append(",");
            sb.append(telnetSetting.getPassword()).append(",");
            sb.append(telnetSetting.getLoginName());
        } else if (setting instanceof I2cConnectorSetting) {
            I2cConnectorSetting i2cConnectorSetting = (I2cConnectorSetting)setting;
            sb.append(key).append(ATTRIBUTE_SEPARATOR).append(ID_I2C).append(ATTRIBUTE_SEPARATOR).append(setting.getName()).append(ATTRIBUTE_SEPARATOR);
            I2cSetting i2cSettings = i2cConnectorSetting.getI2cSettings();
            sb.append(i2cSettings.getfBaudRate()).append(",");
            sb.append(i2cSettings.getfDeviceAddress());
        }
        return sb.toString();
    }
}

