/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.manager.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.soyatec.connector.api.IConnection;
import org.soyatec.connector.manager.ConnectionManager;
import org.soyatec.connector.manager.IConnectorSetting;
import org.soyatec.connector.manager.IManagerChangedListener;

public class DisconnectingAction
extends Action
implements IManagerChangedListener {
    private String ID = "disconnectionAction";

    public DisconnectingAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(this.ID);
        ConnectionManager.INSTANCE.addManagerChangedListener(this);
        this.setEnabled(false);
    }

    public DisconnectingAction(String text) {
        this(text, null);
    }

    public void run() {
        final IConnection<?> connection = this.getConnection();
        if (connection != null) {
            Job job = new Job(""){

                protected IStatus run(IProgressMonitor monitor) {
                    ConnectionManager.INSTANCE.close(connection);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    boolean getNewEnabled() {
        IConnection<?> connection = this.getConnection();
        return connection != null && connection.isConnected();
    }

    public IConnection<?> getConnection() {
        ConnectionManager m = ConnectionManager.INSTANCE;
        String currentSettings = m.getCurrentSettingKey();
        IConnectorSetting connectionSettings = m.getConnectionSettingsByKey(currentSettings);
        return m.getConnection(connectionSettings);
    }

    @Override
    public void connectionSettingRemoved(IConnectorSetting connectionSettings) {
    }

    @Override
    public void connectionSettingAdded(IConnectorSetting connectionSettings) {
    }

    public void connected(IConnection connection) {
        this.activeConnectionChanged();
    }

    public void unconnectioned(IConnection connection) {
        this.activeConnectionChanged();
    }

    @Override
    public void activeConnectionChanged() {
        boolean enabled2 = this.isEnabled();
        boolean newEnabled = this.getNewEnabled();
        this.firePropertyChange("enabled", enabled2, newEnabled);
        this.setEnabled(newEnabled);
    }
}

