/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.manager.actions;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.soyatec.connector.api.IConnection;
import org.soyatec.connector.manager.ConnectionManager;
import org.soyatec.connector.manager.IConnectorSetting;
import org.soyatec.connector.manager.IManagerChangedListener;
import org.soyatec.connector.manager.NullConnectionSetting;
import org.soyatec.connector.manager.ui.IConnectionSettingNameUpdatedListener;

public class ComboContributionItem
extends ContributionItem
implements IManagerChangedListener,
IConnectionSettingNameUpdatedListener {
    private boolean forceSetText;
    private Combo combo;
    private ToolItem toolitem;
    ConnectionManager cm;
    StackLayout stackLayout = new StackLayout();
    Label messageLabel;

    public ComboContributionItem() {
        super("8888%");
        this.cm = ConnectionManager.INSTANCE;
        this.cm.addManagerChangedListener(this);
        this.cm.setNameListener(this);
        this.cm.setComboContributionItem(this);
    }

    private void refresh(boolean repopulateCombo) {
        block9: {
            if (this.combo == null || this.combo.isDisposed()) {
                return;
            }
            try {
                if (repopulateCombo && this.cm != null) {
                    ArrayList<String> names = new ArrayList<String>();
                    for (IConnectorSetting setting : this.cm.getAllConnectionSettings()) {
                        names.add(setting.getName());
                    }
                    int size = names.size();
                    this.combo.setItems(names.toArray(new String[size]));
                    String activeName = this.cm.getCurrentSettingName();
                    if (activeName == null) {
                        this.updateState();
                        activeName = "";
                    } else {
                        this.cm.setCurrentSettings(activeName);
                    }
                    int index = this.combo.indexOf(activeName);
                    if (index == -1 || this.forceSetText) {
                        this.combo.setText(activeName);
                    } else {
                        this.combo.select(index);
                    }
                    this.combo.setEnabled(true);
                }
            }
            catch (SWTException exception) {
                if (SWT.getPlatform().equals("gtk")) break block9;
                throw exception;
            }
        }
    }

    protected int computeWidth(Control control) {
        return control.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    void setWarning(String warning) {
        this.stackLayout.topControl = warning == null ? this.combo : this.messageLabel;
        this.messageLabel.getParent().layout();
    }

    protected Control createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)this.stackLayout);
        this.messageLabel = new Label(control, 0);
        this.messageLabel.setForeground(Display.getDefault().getSystemColor(3));
        Font font = this.messageLabel.getFont();
        FontData[] fontData = font.getFontData();
        fontData[0].setStyle(3);
        font = new Font(null, fontData);
        this.messageLabel.setFont(font);
        this.messageLabel.setText(NullConnectionSetting.INSTANCE.getName());
        this.combo = new Combo(control, 12);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComboContributionItem.this.handleWidgetSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ComboContributionItem.this.handleWidgetDefaultSelected(e);
            }
        });
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ComboContributionItem.this.refresh(false);
            }
        });
        this.stackLayout.topControl = this.combo;
        this.toolitem.setWidth(130);
        return control;
    }

    public void dispose() {
        if (this.cm != null) {
            this.cm.removeManagerChangedListener(this);
            this.cm = null;
        }
        this.combo.dispose();
        this.combo = null;
        this.messageLabel.dispose();
        this.messageLabel = null;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public final void fill(Menu parent, int index) {
        Assert.isTrue((boolean)false, (String)"Can't add a control to a menu");
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setControl(control);
        this.refresh(true);
    }

    private void handleWidgetDefaultSelected(SelectionEvent event) {
        if (this.cm != null) {
            if (this.combo.getSelectionIndex() >= 0) {
                this.cm.setCurrentSettings(this.combo.getItem(this.combo.getSelectionIndex()));
            } else {
                this.cm.setCurrentSettings(this.combo.getText());
            }
        }
        this.refresh(false);
    }

    private void handleWidgetSelected(SelectionEvent event) {
        this.forceSetText = true;
        this.handleWidgetDefaultSelected(event);
        this.forceSetText = false;
    }

    @Override
    public void connectionSettingRemoved(IConnectorSetting connectionSettings) {
        this.updateState();
    }

    void updateState() {
        if (this.cm != null) {
            ArrayList<String> name = new ArrayList<String>();
            for (IConnectorSetting setting : this.cm.getAllConnectionSettings()) {
                name.add(setting.getName());
            }
            int size = name.size();
            String[] keySet = name.toArray(new String[size]);
            this.combo.setItems(keySet);
            if (keySet.length == 0) {
                this.setWarning("");
            } else {
                String currentSettings = this.cm.getCurrentSettingName();
                if (currentSettings != null) {
                    int indexOf = Arrays.asList(keySet).indexOf(currentSettings);
                    if (indexOf == -1) {
                        indexOf = 0;
                    }
                    if (keySet.length > 0) {
                        this.combo.select(indexOf);
                    }
                }
                this.setWarning(null);
            }
        }
    }

    @Override
    public void connectionSettingAdded(IConnectorSetting connectionSettings) {
        if (this.cm != null) {
            ArrayList<String> name = new ArrayList<String>();
            for (IConnectorSetting setting : this.cm.getAllConnectionSettings()) {
                name.add(setting.getName());
            }
            int size = name.size();
            String[] keySet = name.toArray(new String[size]);
            this.combo.setItems(keySet);
            String currentSettings = this.cm.getCurrentSettingName();
            if (currentSettings != null) {
                int indexOf = Arrays.asList(keySet).indexOf(currentSettings);
                if (indexOf == -1) {
                    indexOf = 0;
                }
                if (keySet.length > 0) {
                    this.combo.select(indexOf);
                }
            }
        }
        this.setWarning(null);
    }

    @Override
    public void activeConnectionChanged() {
    }

    @Override
    public void connected(IConnection<?> connection) {
    }

    @Override
    public void unconnectioned(IConnection<?> connection) {
    }

    @Override
    public void nameUpdated(IConnectorSetting settings) {
        if (this.cm != null) {
            ArrayList<String> name = new ArrayList<String>();
            for (IConnectorSetting setting : this.cm.getAllConnectionSettings()) {
                name.add(setting.getName());
            }
            int size = name.size();
            String[] keySet = name.toArray(new String[size]);
            this.combo.setItems(keySet);
            String currentName = this.cm.getCurrentSettingName();
            if (currentName != null) {
                int indexOf = Arrays.asList(keySet).indexOf(currentName);
                if (indexOf == -1) {
                    indexOf = 0;
                }
                if (keySet.length > 0) {
                    this.combo.select(indexOf);
                }
            }
        }
        this.setWarning(null);
    }
}

