/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.api.ui.config.i2c;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.soyatec.connector.api.IModifiedListener;
import org.soyatec.connector.api.ISettings;
import org.soyatec.connector.api.i2c.Messages;
import org.soyatec.connector.api.ui.config.i2c.I2cMessages;
import org.soyatec.connector.api.ui.config.i2c.I2cProperties;
import org.soyatec.connector.api.ui.config.i2c.I2cSetting;

public class I2cSettingsPage {
    protected static final Pattern hexDataPatternWithPerfix = Pattern.compile("0x[0-9a-fA-F]{1,8}");
    protected static final Pattern hexDataPattern = Pattern.compile("[0-9a-fA-F]{1,8}");
    private Combo fBaudRateCombo;
    private Text fDeviceAddress;
    private final I2cSetting fTerminalSettings;
    private IModifiedListener modifiedListener;

    public I2cSettingsPage(I2cSetting settings) {
        this.fTerminalSettings = settings;
    }

    public void saveSettings() {
        this.fTerminalSettings.setfBaudRate(this.getComboValue(this.fBaudRateCombo));
        this.fTerminalSettings.setfDeviceAddress(this.fDeviceAddress.getText());
    }

    public void loadSettings() {
        I2cProperties properties = this.fTerminalSettings.getProperties();
        List<String> list = properties.getBaudRateTable();
        this.loadCombo(this.fBaudRateCombo, list);
        this.setCombo(this.fBaudRateCombo, this.fTerminalSettings.getfBaudRate());
        this.fDeviceAddress.setText(this.fTerminalSettings.getfDeviceAddress());
    }

    private void setCombo(Combo combo, String value) {
        if (value == null) {
            return;
        }
        int nIndex = combo.indexOf(value);
        if (nIndex == -1) {
            if ((combo.getStyle() & 8) == 0) {
                combo.add(value);
                nIndex = combo.indexOf(value);
            } else {
                return;
            }
        }
        combo.select(nIndex);
    }

    private String getComboValue(Combo combo) {
        int nIndex = combo.getSelectionIndex();
        if (nIndex == -1) {
            if ((combo.getStyle() & 8) != 0) {
                return "";
            }
            return combo.getText();
        }
        return combo.getItem(nIndex);
    }

    public boolean validateSettings() {
        try {
            int p = Integer.parseInt(this.fDeviceAddress.getText().trim());
            return p >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        this.fBaudRateCombo = this.addLabeledCombo(composite, String.valueOf(I2cMessages.BaudRate) + ":");
        this.fBaudRateCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                I2cSettingsPage.this.dispatchModifiedEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                I2cSettingsPage.this.dispatchModifiedEvent();
            }
        });
        new Label(composite, 131072).setText(String.valueOf(I2cMessages.DeviceAddress) + ":");
        this.fDeviceAddress = new Text(composite, 2048);
        this.fDeviceAddress.setText(this.fTerminalSettings.getfDeviceAddress());
        this.fDeviceAddress.setLayoutData((Object)new GridData(768));
        this.fDeviceAddress.setTextLimit(6);
        this.fDeviceAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                I2cSettingsPage.this.dispatchModifiedEvent();
            }
        });
        this.fDeviceAddress.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                String textStr = I2cSettingsPage.this.fDeviceAddress.getText();
                if (textStr == null) {
                    return;
                }
                if (!I2cSettingsPage.isValidHexString(textStr)) {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_DeviceAddress_isHex);
                    return;
                }
                if (textStr.isEmpty()) {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_DeviceAddress_isNotEmpty);
                    return;
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.loadSettings();
    }

    private Combo addLabeledCombo(Composite composite, String label) {
        return this.addLabeledCombo(composite, label, true);
    }

    private Combo addLabeledCombo(Composite composite, String label, boolean readonly) {
        new Label(composite, 131072).setText(label);
        int flags = 4;
        Combo combo = new Combo(composite, flags |= 8);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    private void loadCombo(Combo ctlCombo, List<?> table) {
        for (String label : table) {
            String[] items = ctlCombo.getItems();
            if (Arrays.asList(items).contains(label)) continue;
            ctlCombo.add(label);
        }
    }

    protected void dispatchModifiedEvent() {
        if (this.modifiedListener != null) {
            this.modifiedListener.modified((ISettings)this.fTerminalSettings);
        }
    }

    public IModifiedListener getModifiedListener() {
        return this.modifiedListener;
    }

    public void setModifiedListener(IModifiedListener modifiedListener) {
        this.modifiedListener = modifiedListener;
    }

    public static boolean isValidHexString(String hexString, boolean withPrefix) {
        if (withPrefix) {
            return hexDataPatternWithPerfix.matcher(hexString).matches();
        }
        return hexDataPattern.matcher(hexString).matches();
    }

    public static boolean isValidHexString(String str) {
        return I2cSettingsPage.isValidHexString(str, false) || I2cSettingsPage.isValidHexString(str, true);
    }
}

