/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.api.telnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.soyatec.connector.api.IConnection;
import org.soyatec.connector.api.IConnectionManager;
import org.soyatec.connector.api.telnet.ITelnetSettings;
import org.soyatec.exceptions.TelnetLoginException;
import org.soyatec.exceptions.TimeoutException;

public final class TelnetConnection
implements IConnection<ITelnetSettings>,
Runnable {
    static int timeout = 1000;
    private static final int isLinuxSystem = 0;
    private static final int isAndroidSystem = 1;
    private String name;
    private InputStream remoteInput;
    private OutputStream remoteOutput;
    private Socket socket;
    private ITelnetSettings telnetSetting;
    IConnectionManager connectionManager;
    private List<OutputStream> localOutputs = new ArrayList<OutputStream>();
    private byte[] buffer = new byte[64];
    private boolean autoReceive = false;
    private StringBuilder receivedBuffer = new StringBuilder();
    private OutputStream currentReceivedOut = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            TelnetConnection.this.receivedBuffer.append((char)b);
        }
    };

    private TelnetConnection(Socket socket, ITelnetSettings telnetSettings) throws IOException {
        this.socket = socket;
        this.setSettings(telnetSettings);
        this.remoteInput = socket.getInputStream();
        this.remoteOutput = socket.getOutputStream();
    }

    public static TelnetConnection createConnection(ITelnetSettings telnetSettings) throws IOException {
        InetSocketAddress address = new InetSocketAddress(telnetSettings.getHost(), telnetSettings.getNetworkPort());
        Socket socket = new Socket();
        socket.connect(address, telnetSettings.getTimeout() * 1000);
        socket.setOOBInline(true);
        socket.setKeepAlive(true);
        TelnetConnection telnetConnector = new TelnetConnection(socket, telnetSettings);
        telnetConnector.start();
        return telnetConnector;
    }

    public void start() {
        new Thread(this).start();
    }

    public void removeAllOutputStream() {
        this.localOutputs.clear();
    }

    public void addOutputStream(OutputStream out) {
        if (out == null) {
            return;
        }
        if (!this.localOutputs.contains(out)) {
            this.localOutputs.add(out);
        }
    }

    public void removeOutputStream(OutputStream out) {
        if (this.localOutputs.contains(out)) {
            this.localOutputs.remove(out);
        }
    }

    public boolean login() throws IOException, TimeoutException, TelnetLoginException {
        if (this.telnetSetting.getLoginName() != null && this.telnetSetting.getPassword() != null) {
            return this.login(this.telnetSetting.getLoginName(), this.telnetSetting.getPassword());
        }
        return this.login("root", "\n");
    }

    public boolean login(String name, String psd) throws IOException, TimeoutException, TelnetLoginException {
        this.addOutputStream(this.currentReceivedOut);
        String commandPrompt = "#";
        String loginPrompt = "login:";
        String passwordPrompt = "Password:";
        if (this.telnetSetting != null) {
            commandPrompt = this.telnetSetting.getCommandPrompt();
            loginPrompt = this.telnetSetting.getLoginPrompt();
            passwordPrompt = this.telnetSetting.getPasswordPrompt();
        }
        boolean temp = this.isAutoReceive();
        this.setAutoReceive(true);
        long start = System.currentTimeMillis();
        boolean flag = false;
        if (this.getSettings() != null) {
            while (System.currentTimeMillis() - start < (long)(this.getSettings().getTimeout() * 1000)) {
                if (this.receivedBuffer.indexOf(loginPrompt) != -1) {
                    flag = false;
                    break;
                }
                if (this.receivedBuffer.indexOf(commandPrompt) == -1) continue;
                flag = true;
                break;
            }
        }
        if (this.getSettings() != null && !flag) {
            if (this.receivedBuffer.indexOf(loginPrompt) == -1) {
                throw new TimeoutException("Timeout wilte waiting for '" + loginPrompt + "'!");
            }
            this.remoteOutput.write((String.valueOf(name) + "\n").getBytes(System.getProperty("file.encoding")));
            this.receivedBuffer.delete(0, this.receivedBuffer.length());
            start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start < (long)(this.getSettings().getTimeout() * 1000)) {
                if (this.receivedBuffer.indexOf(passwordPrompt) != -1) break;
            }
            if (this.receivedBuffer.indexOf(passwordPrompt) == -1) {
                throw new TimeoutException("Timeout wilte waiting for '" + passwordPrompt + "'!");
            }
            this.receivedBuffer.delete(0, this.receivedBuffer.length());
            if (psd != null && !psd.isEmpty()) {
                this.remoteOutput.write((String.valueOf(psd) + "\n").getBytes(System.getProperty("file.encoding")));
            } else {
                this.remoteOutput.write("\n".getBytes(System.getProperty("file.encoding")));
            }
            boolean psdSuccess = false;
            while (System.currentTimeMillis() - start < (long)(this.getSettings().getTimeout() * 1000)) {
                if (this.receivedBuffer.indexOf(commandPrompt) == -1) continue;
                psdSuccess = true;
                break;
            }
            this.removeOutputStream(this.currentReceivedOut);
            if (psdSuccess) {
                this.setAutoReceive(temp);
                this.receivedBuffer.delete(0, this.receivedBuffer.length());
                return true;
            }
            throw new TelnetLoginException("Login name and password is not correct!");
        }
        this.setAutoReceive(temp);
        this.receivedBuffer.delete(0, this.receivedBuffer.length());
        return true;
    }

    public OutputStream getRemoteOutputStream() {
        return this.remoteOutput;
    }

    public void close() {
        this.setConnectionManager(null);
        this.localOutputs.clear();
        if (this.remoteInput != null) {
            try {
                this.remoteInput.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.remoteInput = null;
        }
        if (this.remoteOutput != null) {
            try {
                this.remoteOutput.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.remoteOutput = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.socket = null;
        }
    }

    public static void main(String[] args) throws IOException, TimeoutException, TelnetLoginException {
        TelnetConnection connect = TelnetConnection.createConnection(new ITelnetSettings(){

            @Override
            public int getTimeout() {
                return 2000;
            }

            @Override
            public String getStatusString(String strConnected) {
                return "";
            }

            @Override
            public int getNetworkPort() {
                return 23;
            }

            @Override
            public String getHost() {
                return "192.168.1.6";
            }

            @Override
            public String getSummary() {
                return String.valueOf(this.getHost()) + ":" + this.getNetworkPort();
            }

            @Override
            public String getCommandPrompt() {
                return "#";
            }

            @Override
            public String getLoginPrompt() {
                return "login:";
            }

            @Override
            public String getPasswordPrompt() {
                return "Password:";
            }

            @Override
            public String getLoginName() {
                return "root";
            }

            @Override
            public String getPassword() {
                return "";
            }
        });
        connect.login();
    }

    private void notifyConnectionInterrupted() {
        if (this.connectionManager != null) {
            this.connectionManager.notifyConnectionInterrupted((IConnection)this);
        } else {
            System.err.println("notifyConnectionInterrupted\t" + this);
        }
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        while (this.remoteInput != null && this.socket != null && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isClosed()) {
            try {
                if (this.remoteInput.available() > 0) {
                    while (this.remoteInput.available() > 0 && this.isAutoReceive()) {
                        int read = this.remoteInput.read(this.buffer);
                        this.dispach(Arrays.copyOf(this.buffer, read));
                    }
                    time = System.currentTimeMillis();
                    continue;
                }
                if (System.currentTimeMillis() - time > (long)timeout) {
                    this.send(null);
                    time = System.currentTimeMillis();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                this.notifyConnectionInterrupted();
                return;
            }
        }
    }

    private void dispach(byte[] received) {
        Object[] array;
        Object[] objectArray = array = this.localOutputs.toArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object op = objectArray[n2];
            try {
                if (op instanceof OutputStream) {
                    ((OutputStream)op).write(received);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public boolean isAutoReceive() {
        return this.autoReceive;
    }

    public void setAutoReceive(boolean autoReceive) {
        this.autoReceive = autoReceive;
    }

    public boolean isConnected() {
        return this.remoteInput != null && this.remoteOutput != null;
    }

    public void send(String data) throws IOException {
        if (data == null) {
            try {
                this.socket.sendUrgentData(7);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.notifyConnectionInterrupted();
            }
            return;
        }
        if (this.remoteOutput != null) {
            this.remoteOutput.write(data.getBytes(System.getProperty("file.encoding")));
        }
    }

    public void send(char data) throws IOException {
        if (this.remoteOutput != null) {
            this.remoteOutput.write(data);
        }
    }

    public String getName() {
        return this.name;
    }

    public ITelnetSettings getSettings() {
        return this.telnetSetting;
    }

    public void setSettings(ITelnetSettings settings) {
        this.telnetSetting = settings;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean updateSettings(ITelnetSettings settings) {
        return false;
    }

    public InputStream getRemoteInputStream() {
        return this.remoteInput;
    }

    public void update() {
    }

    public void setConnectionManager(IConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }
}

