/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.api.serial;

import gnu.io.CommPortIdentifier;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class SerialProperties {
    protected List<String> fSerialPortTable;
    protected List<String> fBaudRateTable;
    protected List<String> fDataBitsTable;
    protected List<String> fStopBitsTable;
    protected List<String> fParityTable;
    protected List<String> fFlowControlTable;
    protected String fDefaultConnType;
    protected String fDefaultSerialPort;
    protected String fDefaultBaudRate;
    protected String fDefaultDataBits;
    protected String fDefaultStopBits;
    protected String fDefaultParity;
    protected String fDefaultFlowControl;

    public SerialProperties() {
        this.setupProperties();
    }

    public List<String> getSerialPortTable() {
        return this.fSerialPortTable;
    }

    public List<String> getBaudRateTable() {
        return this.fBaudRateTable;
    }

    public List<String> getDataBitsTable() {
        return this.fDataBitsTable;
    }

    public List<String> getStopBitsTable() {
        return this.fStopBitsTable;
    }

    public List<String> getParityTable() {
        return this.fParityTable;
    }

    public List<String> getFlowControlTable() {
        return this.fFlowControlTable;
    }

    public String getDefaultConnType() {
        return this.fDefaultConnType;
    }

    public String getDefaultSerialPort() {
        return this.fDefaultSerialPort;
    }

    public String getDefaultBaudRate() {
        return this.fDefaultBaudRate;
    }

    public String getDefaultDataBits() {
        return this.fDefaultDataBits;
    }

    public String getDefaultStopBits() {
        return this.fDefaultStopBits;
    }

    public String getDefaultParity() {
        return this.fDefaultParity;
    }

    public String getDefaultFlowControl() {
        return this.fDefaultFlowControl;
    }

    public String getDefaultTimeout() {
        return "5";
    }

    private void setupProperties() {
        this.fSerialPortTable = new Vector<String>();
        this.fBaudRateTable = new Vector<String>();
        this.fDataBitsTable = new Vector<String>();
        this.fStopBitsTable = new Vector<String>();
        this.fParityTable = new Vector<String>();
        this.fFlowControlTable = new Vector<String>();
        this.fDefaultConnType = "";
        this.fDefaultSerialPort = "";
        this.fDefaultBaudRate = "";
        this.fDefaultDataBits = "";
        this.fDefaultStopBits = "";
        this.fDefaultParity = "";
        this.fDefaultFlowControl = "";
        this.fBaudRateTable.add("300");
        this.fBaudRateTable.add("1200");
        this.fBaudRateTable.add("2400");
        this.fBaudRateTable.add("4800");
        this.fBaudRateTable.add("9600");
        this.fBaudRateTable.add("19200");
        this.fBaudRateTable.add("38400");
        this.fBaudRateTable.add("57600");
        this.fBaudRateTable.add("115200");
        this.fDataBitsTable.add("5");
        this.fDataBitsTable.add("6");
        this.fDataBitsTable.add("7");
        this.fDataBitsTable.add("8");
        this.fStopBitsTable.add("1");
        this.fStopBitsTable.add("1_5");
        this.fStopBitsTable.add("2");
        this.fParityTable.add("None");
        this.fParityTable.add("Even");
        this.fParityTable.add("Odd");
        this.fParityTable.add("Mark");
        this.fParityTable.add("Space");
        this.fFlowControlTable.add("None");
        this.fFlowControlTable.add("RTS/CTS");
        this.fFlowControlTable.add("Xon/Xoff");
        this.fDefaultBaudRate = this.fBaudRateTable.get(8);
        this.fDefaultDataBits = this.fDataBitsTable.get(3);
        this.fDefaultStopBits = this.fStopBitsTable.get(0);
        this.fDefaultParity = this.fParityTable.get(0);
        this.fDefaultFlowControl = this.fFlowControlTable.get(0);
        this.reloadingSerialPort();
    }

    public void reloadingSerialPort() {
        this.fSerialPortTable.clear();
        try {
            Enumeration portIdEnum = CommPortIdentifier.getPortIdentifiers();
            while (portIdEnum.hasMoreElements()) {
                CommPortIdentifier identifier = (CommPortIdentifier)portIdEnum.nextElement();
                String strName = identifier.getName();
                int nPortType = identifier.getPortType();
                if (nPortType != 1) continue;
                this.fSerialPortTable.add(strName);
                if (this.fDefaultSerialPort != null) continue;
                this.fDefaultSerialPort = strName;
            }
        }
        catch (Throwable e) {
            System.out.println("The RXTX library has not been installed properly!");
        }
        Collections.sort(this.fSerialPortTable);
        if (!this.fSerialPortTable.isEmpty() && !this.fSerialPortTable.contains(this.fDefaultSerialPort)) {
            this.fDefaultSerialPort = this.fSerialPortTable.get(0);
        }
    }
}

