package org.soyatec.connector.api.i2c.jni;

import org.soyatec.connector.api.i2c.I2cUtils;

import com.sun.jna.Library;
import com.sun.jna.Native;

public interface II2cDllByJNA extends Library {
	II2cDllByJNA instance = (II2cDllByJNA) Native.loadLibrary(
			I2cUtils.getInstallPath() + "Resources/I2C/libhiice.dll",
			II2cDllByJNA.class);

	/**
	 * This function opens the indexed channel and returns a handle to it.
	 * 
	 * @param index
	 *            Index of the channel,0 or 1.
	 * @param baudrate
	 *            Set the I2C baud rate.
	 * @return
	 */

	public int I2C_OpenChannel(int index, int baudrate);

	/**
	 * Closes a channel and frees all resources that were used by it.
	 * 
	 * @return
	 */
	public int I2C_CloseChannel(int index);

	/**
	 * This function writes the specified number of bytes from an addressed I2C
	 * slave.
	 * 
	 * @param deviceAddress
	 *            Address of the I2C slave
	 * @param sizetowrite
	 *            Number of bytes to be written
	 * @param inputbuffer
	 *            Pointer to the buffer from where data is to be written
	 * @param sizetoread
	 *            Number of bytes to be read
	 * @param outputbuffer
	 *            Number of bytes to be read
	 * @return
	 */
	public int I2C_DeviceStream(int index, int deviceAddress, int sizetowrite,
			byte inputbuffer[], int sizetoread, byte outputbuffer[]);

}
