/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.IBrowserViewerContainer;
import org.eclipse.ui.internal.browser.WebBrowserUtil;
import org.eclipse.ui.internal.browser.WebBrowserViewDropAdapter;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public class WebBrowserView
extends ViewPart
implements IBrowserViewerContainer,
ISetSelectionTarget {
    public static final String WEB_BROWSER_VIEW_ID = "org.eclipse.ui.browser.view";
    protected BrowserViewer viewer;
    protected ISelectionListener listener;

    public void createPartControl(Composite parent) {
        int style = WebBrowserUtil.decodeStyle(this.getViewSite().getSecondaryId());
        this.viewer = new BrowserViewer(parent, style);
        this.viewer.setContainer(this);
        this.initDragAndDrop();
    }

    public void dispose() {
        if (this.viewer != null) {
            this.viewer.setContainer(null);
        }
        if (this.listener != null) {
            this.removeSelectionListener();
        }
    }

    public void setURL(String url) {
        if (this.viewer != null) {
            this.viewer.setURL(url);
        }
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public boolean close() {
        try {
            this.getSite().getPage().hideView((IViewPart)this);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IActionBars getActionBars() {
        return this.getViewSite().getActionBars();
    }

    public void openInExternalBrowser(String url) {
        try {
            URL theURL = new URL(url);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(theURL);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (PartInitException partInitException) {}
    }

    public void addSelectionListener() {
        if (this.listener != null) {
            return;
        }
        this.listener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                WebBrowserView.this.onSelectionChange(selection);
            }
        };
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.listener);
    }

    private void onSelectionChange(ISelection selection) {
        IAdaptable adapt;
        URL url;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        Object obj = sel.getFirstElement();
        if (obj instanceof IAdaptable && (url = this.getURLFromAdaptable(adapt = (IAdaptable)obj)) != null) {
            this.setURL(url.toExternalForm());
        }
    }

    private URL getURLFromAdaptable(IAdaptable adapt) {
        File file;
        IPath path = (IPath)adapt.getAdapter(IPath.class);
        if (path != null && (file = path.toFile()).exists() && this.isWebFile(file.getName())) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return (URL)adapt.getAdapter(URL.class);
    }

    public void removeSelectionListener() {
        if (this.listener == null) {
            return;
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.listener);
        this.listener = null;
    }

    protected boolean isWebFile(String name) {
        return name.endsWith("html") || name.endsWith("htm") || name.endsWith("gif") || name.endsWith("jpg");
    }

    protected void initDragAndDrop() {
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget((Control)this.viewer, 17);
        dropTarget.setTransfer(transfers);
        dropTarget.addDropListener((DropTargetListener)new WebBrowserViewDropAdapter(this.viewer));
    }

    public void selectReveal(ISelection selection) {
        this.onSelectionChange(selection);
    }

    public void setBrowserViewName(String name) {
        this.setPartName(name);
    }

    public void setBrowserViewTooltip(String tip) {
        this.setTitleToolTip(tip);
    }
}

