/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.update;

import com.soyatec.hisilicon.platform.core.IToolManager;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.core.internal.DeviceManager;
import com.soyatec.hisilicon.platform.ui.internal.ToolStateControlUtils;
import com.soyatec.hisilicon.platform.ui.update.UpdateFileChecker;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class UpdateFileInstaller
implements Runnable {
    public static final UpdateFileInstaller INSTANCE = new UpdateFileInstaller();
    protected boolean isOK = false;

    private UpdateFileInstaller() {
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public void run() {
        IToolManager toolManager = PlatformCoreActivator.getDefault().getToolManager();
        HashMap<String, ToolDescriptor> updateList = UpdateFileChecker.INSTANCE.getUpdateFileList();
        for (Map.Entry<String, ToolDescriptor> entry : updateList.entrySet()) {
            File toolFile;
            block7: {
                String newToolPath = entry.getKey();
                toolFile = new File(newToolPath);
                if (!toolFile.exists()) continue;
                ToolDescriptor newTool = entry.getValue();
                ToolDescriptor oldTool = null;
                List installIUs = PlatformCoreActivator.getDefault().getToolManager().getInstalledToolAndPlatformIUs();
                List listTools = toolManager.collectFeatureToolsAndPlatform(installIUs);
                for (ToolDescriptor tool : listTools) {
                    if (!tool.getName().equals(newTool.getName())) continue;
                    oldTool = tool;
                }
                if (oldTool == null) {
                    if (toolFile.delete()) continue;
                    System.out.print("Delete temp file failed.");
                    continue;
                }
                try {
                    ToolStateControlUtils.setAutoModifyToolState(oldTool, null);
                    toolManager.uninstallIU(oldTool.iu, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    if (toolFile.delete()) continue;
                    System.out.print("Delete temp file failed.");
                    continue;
                }
                try {
                    toolManager.installIU(newToolPath, newTool.iu, (IProgressMonitor)new NullProgressMonitor());
                    IInstallableUnit iu = toolManager.findInstallIU(newTool.iu.getId(), newTool.iu.getVersion().toString());
                    if (iu == null) break block7;
                    ToolDescriptor installedTool = new ToolDescriptor(iu);
                    DeviceManager deviceManager = (DeviceManager)DeviceManager.getInstance();
                    deviceManager.combinedNewToolSuiltableChips((String)installedTool.getProperties().get("build.id"), (String)installedTool.getProperties().get("Chips"));
                }
                catch (Exception e) {
                    if (toolFile.delete()) continue;
                    System.out.print("Delete temp file failed.");
                    continue;
                }
            }
            if (toolFile.delete()) continue;
            System.out.print("Delete temp file failed.");
        }
        this.isOK = true;
    }
}

