/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.update;

import com.soyatec.hisilicon.platform.core.IToolManager;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.ui.internal.EncryptZipUtil;
import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class UpdateFileChecker
implements Runnable {
    private static final String DIR_UPDATES = "updates/";
    private static final String UPDATE_EXT = ".upd";
    private static final String UPDATE_ZIP = ".zip";
    public static final UpdateFileChecker INSTANCE = new UpdateFileChecker();
    HashMap<String, ToolDescriptor> updateFileList = new HashMap();
    protected boolean isOK = false;

    private UpdateFileChecker() {
    }

    public boolean isOK() {
        return this.isOK;
    }

    public HashMap<String, ToolDescriptor> getUpdateFileList() {
        return this.updateFileList;
    }

    @Override
    public void run() {
        File[] files;
        File dirUpdates = new File(String.valueOf(Platform.getInstallLocation().getURL().getFile()) + DIR_UPDATES);
        if (!dirUpdates.exists()) {
            this.isOK = true;
            return;
        }
        IToolManager toolManager = PlatformCoreActivator.getDefault().getToolManager();
        File[] fileArray = files = dirUpdates.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                File file = fileArray[n2];
                if (!file.isDirectory() && file.getAbsolutePath().endsWith(UPDATE_EXT)) {
                    File unzip = new File(String.valueOf(file.getAbsolutePath()) + UPDATE_ZIP);
                    EncryptZipUtil.decryptZip(file, unzip);
                    if (file.delete() && unzip.exists()) {
                        ToolDescriptor tool;
                        block6: {
                            tool = null;
                            try {
                                IInstallableUnit unit = toolManager.findToolUnit(unzip.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
                                if (unit == null) break block6;
                                tool = new ToolDescriptor(unit);
                            }
                            catch (Exception e) {
                                break block7;
                            }
                        }
                        this.updateFileList.put(unzip.getAbsolutePath(), tool);
                    }
                }
            }
            ++n2;
        }
        this.isOK = true;
    }
}

