/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.tool;

import com.soyatec.hisilicon.platform.core.IToolManager;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.core.internal.DeviceManager;
import com.soyatec.hisilicon.platform.ui.Messages;
import com.soyatec.hisilicon.platform.ui.PlatformUIActivator;
import com.soyatec.hisilicon.platform.ui.internal.BundleUtils;
import com.soyatec.hisilicon.platform.ui.internal.ControlFactory;
import com.soyatec.hisilicon.platform.ui.internal.PatchUtils;
import com.soyatec.hisilicon.platform.ui.internal.PerspectiveUtil;
import com.soyatec.hisilicon.platform.ui.internal.PlatformStateControlUtils;
import com.soyatec.hisilicon.platform.ui.internal.RegisterUtils;
import com.soyatec.hisilicon.platform.ui.internal.TestBuildUtils;
import com.soyatec.hisilicon.platform.ui.internal.ToolStateControlUtils;
import com.soyatec.hisilicon.platform.ui.internal.ToolUpdateUtils;
import com.soyatec.hisilicon.platform.ui.tool.ApplyPlatformPatchDialog;
import com.soyatec.hisilicon.platform.ui.tool.ConfigurationManagementDialog;
import com.soyatec.hisilicon.platform.ui.tool.InstallToolWizard;
import com.soyatec.hisilicon.platform.ui.tool.RegisterDialog;
import com.soyatec.hisilicon.platform.ui.tool.ToolDetialDialog;
import com.soyatec.hisilicon.platform.ui.tool.UpgradeToolDialog;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

public class ToolManagerDialog
extends Dialog {
    protected ToolDescriptor selectedTool;
    private DetalPanel detailPanel;
    private TableViewer toolListTable;
    private List<IInstallableUnit> installIUs;
    private List<ToolDescriptor> installTools;
    private List<ToolDescriptor> activatedTools = new ArrayList<ToolDescriptor>();
    private List<ToolDescriptor> newInstalledTools = new ArrayList<ToolDescriptor>();
    private Button installNewToolBtn;
    private IToolManager toolManager;

    public ToolManagerDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.toolManager = PlatformCoreActivator.getDefault().getToolManager();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ToolManagerDialog_0);
        newShell.setSize(800, 600);
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (ToolManagerDialog.this.activatedTools.size() > 0) {
                    Map<String, IExtension> reg = PerspectiveUtil.loadPerspectiveRegistry();
                    ArrayList<String> rs = new ArrayList<String>();
                    HashMap<String, Integer> needUpdatePerspectiveIDS = new HashMap<String, Integer>();
                    for (ToolDescriptor t : ToolManagerDialog.this.activatedTools) {
                        List<String> ids = PerspectiveUtil.finPerspectiveDeclareIds(t, reg);
                        if (ids.size() == 0) continue;
                        String id = ids.get(0);
                        rs.add(id);
                        needUpdatePerspectiveIDS.put(id, 1);
                    }
                    PerspectiveUtil.addPerspectiveToWelcomeView(needUpdatePerspectiveIDS);
                }
            }
        });
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.marginHeight = 0;
        SashForm sash = ControlFactory.createSashForm(comp, 65792);
        this.installIUs = this.toolManager.getInstalledToolAndPlatformIUs();
        this.installTools = this.toolManager.collectFeatureToolsAndPlatform(this.installIUs);
        this.createMasterPanel(sash);
        this.createDetailPanel(sash);
        sash.setWeights(new int[]{1, 2});
        return comp;
    }

    private void createDetailPanel(SashForm sash) {
        this.detailPanel = new DetalPanel((Composite)sash, 0);
    }

    private void createMasterPanel(SashForm sash) {
        Composite comp = ControlFactory.createCompositeEx(sash, 1, 1808, 1);
        ControlFactory.createLabel(comp, Messages.ToolManagerDialog_1, 1);
        String[] input = this.getTableInput();
        this.toolListTable = ControlFactory.createTableViewer(comp, input, -1, -1, 65540);
        this.toolListTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int index;
                ISelection sel = event.getSelection();
                if (sel instanceof IStructuredSelection && (index = ToolManagerDialog.this.toolListTable.getTable().getSelectionIndex()) >= 0 && index < ToolManagerDialog.this.installTools.size()) {
                    ToolManagerDialog.this.selectedTool = (ToolDescriptor)ToolManagerDialog.this.installTools.get(index);
                    ToolManagerDialog.this.refreshDetailPanel();
                    ToolManagerDialog.this.updateButtonState();
                }
            }
        });
        this.updateBundleForeground();
        this.installNewToolBtn = ControlFactory.createPushButton(comp, Messages.ToolManagerDialog_2, 768, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolManagerDialog.this.installNewTool();
            }
        });
        GridData layoutData = (GridData)this.installNewToolBtn.getLayoutData();
        layoutData.heightHint = 40;
        this.installNewToolBtn.setLayoutData((Object)layoutData);
        if (!PlatformStateControlUtils.isPlatformEnabled()) {
            this.installNewToolBtn.setEnabled(false);
        }
    }

    private String[] getTableInput() {
        return this.toolManager.getToolNames(this.installTools);
    }

    protected void installNewTool() {
        final InstallToolWizard wizard = new InstallToolWizard(this.getTableInput());
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            UIJob job = new UIJob("installing"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ToolDescriptor toolDesc = wizard.getToolDescriptor();
                    String str = String.valueOf(Messages.ToolManagerDialog_3) + toolDesc.getName() + " " + toolDesc.getVersion();
                    monitor.beginTask(str, 100);
                    String url = wizard.getInstallZipFile();
                    ToolDescriptor desc = null;
                    try {
                        ToolManagerDialog.this.toolManager.installIU(url, toolDesc.iu, (IProgressMonitor)new NullProgressMonitor());
                        ToolManagerDialog.this.installIUs = ToolManagerDialog.this.toolManager.getInstalledToolIUs();
                        IInstallableUnit installIU = ToolManagerDialog.this.toolManager.findInstallIU(toolDesc.iu.getId(), toolDesc.iu.getVersion().toString());
                        if (installIU == null) {
                            return Status.CANCEL_STATUS;
                        }
                        desc = new ToolDescriptor(installIU);
                        ToolManagerDialog.this.installTools.add(desc);
                        Table table = ToolManagerDialog.this.toolListTable.getTable();
                        DeviceManager deviceManager = (DeviceManager)DeviceManager.getInstance();
                        deviceManager.combinedNewToolSuiltableChips((String)desc.getProperties().get("build.id"), (String)desc.getProperties().get("Chips"));
                        String[] selectChips = wizard.getSelectChips();
                        if (selectChips != null && selectChips.length > 0) {
                            deviceManager.combinedNewTestToolSuiltableChips(selectChips, (String)desc.getProperties().get("build.id"));
                        }
                        table.setRedraw(false);
                        table.removeAll();
                        ToolManagerDialog.this.toolListTable.add((Object[])ToolManagerDialog.this.getTableInput());
                        table.setRedraw(true);
                        wizard.clean();
                    }
                    catch (Exception e) {
                        if (e.getMessage().equals(Messages.ToolManagerDialog_4)) {
                            MessageDialog.openError((Shell)ToolManagerDialog.this.getShell(), (String)Messages.ToolManagerDialog_5, (String)Messages.InstallToolWizardPage_01);
                        } else {
                            MessageDialog.openError((Shell)ToolManagerDialog.this.getShell(), (String)Messages.ToolManagerDialog_5, (String)e.getMessage());
                        }
                        return Status.CANCEL_STATUS;
                    }
                    String code = wizard.getRegisterCode();
                    if (code != null && code.length() > 0 && !RegisterUtils.registerCode(desc.getProperties(), code)) {
                        MessageDialog.openError((Shell)ToolManagerDialog.this.getShell(), (String)Messages.ToolManagerDialog_6, (String)Messages.ToolManagerDialog_7);
                        return Status.CANCEL_STATUS;
                    }
                    ToolManagerDialog.this.newInstalledTools.add(desc);
                    PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logInfo(String.valueOf((String)desc.getProperties().get("tool.name")) + " : " + Messages.INSTALL_NEWTOOL_LOG);
                    return Status.OK_STATUS;
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    int severity = event.getResult().getSeverity();
                    if (severity != 8 && severity != 4) {
                        ToolUpdateUtils.requestRestart(3);
                    }
                }
            });
            job.setSystem(true);
            job.schedule();
        }
    }

    protected void refreshDetailPanel() {
        this.detailPanel.setInput(this.selectedTool);
    }

    protected void toggleTool(ToolDescriptor tool) {
        String expireWarning;
        if (tool == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ToolManagerDialog_36, (String)Messages.ToolManagerDialog_37);
            return;
        }
        List list = tool.getPlugins();
        if (list.size() == 0) {
            return;
        }
        boolean originalEnabled = BundleUtils.isToolEnabled(tool);
        if (!originalEnabled && (expireWarning = RegisterUtils.getExpireWarning(tool.getProperties())) != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ToolManagerDialog_38, (String)expireWarning);
            return;
        }
        String message = originalEnabled ? Messages.ToolManagerDialog_40 : Messages.ToolManagerDialog_41;
        boolean confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.ToolManagerDialog_42, (String)message);
        if (confirm) {
            if (originalEnabled) {
                BundleUtils.closeToolPerspective(tool);
                PerspectiveUtil.removePerspectiveShortcut(tool);
                ToolStateControlUtils.setHandModifyToolState(tool, false);
            } else {
                ToolStateControlUtils.setHandModifyToolState(tool, true);
            }
            for (Object o : list) {
                ToolDescriptor.PluginDetail p = (ToolDescriptor.PluginDetail)o;
                BundleUtils.setBundleEnabled(p.getPluginId(), !originalEnabled);
            }
            this.updateBundleForeground();
            if (originalEnabled) {
                if (this.activatedTools.contains(tool)) {
                    this.activatedTools.remove(tool);
                }
                PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logInfo(String.valueOf((String)tool.getProperties().get("tool.name")) + " : " + Messages.DISABLE_TOOL_LOG);
            } else {
                if (!this.activatedTools.contains(tool)) {
                    this.activatedTools.add(tool);
                }
                PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logInfo(String.valueOf((String)tool.getProperties().get("tool.name")) + " : " + Messages.ENABLE_TOOL_LOG);
            }
            this.refreshDetailPanel();
        }
    }

    protected void uninstallTool(final ToolDescriptor tool) {
        if (tool == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ToolManagerDialog_43, (String)Messages.ToolManagerDialog_44);
            return;
        }
        MessageBox dialog = ControlFactory.createYesNoDialog(Messages.ToolManagerDialog_45, String.valueOf(Messages.ToolManagerDialog_46) + tool.getName() + "?");
        int res = dialog.open();
        if (res == 64) {
            UIJob job = new UIJob("uninstalling"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    String toolName = (String)tool.getProperties().get("tool.name");
                    try {
                        ToolStateControlUtils.setAutoModifyToolState(tool, null);
                        List list = tool.getPlugins();
                        for (Object o : list) {
                            ToolDescriptor.PluginDetail p = (ToolDescriptor.PluginDetail)o;
                            BundleUtils.setBundleEnabled(p.getPluginId(), false);
                        }
                        ToolManagerDialog.this.toolManager.uninstallIU(tool.iu, monitor);
                        ToolUpdateUtils.applyProfileChanges();
                        RegisterUtils.clearLicense(tool);
                        int index = ToolManagerDialog.this.installTools.indexOf(tool);
                        ToolManagerDialog.this.toolListTable.getTable().remove(index);
                        ToolManagerDialog.this.installTools.remove(tool);
                        ToolManagerDialog.this.selectedTool = null;
                        ToolManagerDialog.this.refreshDetailPanel();
                        PerspectiveUtil.removePerspectiveShortcut(tool);
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)ToolManagerDialog.this.getShell(), (String)Messages.ToolManagerDialog_49, (String)e.getMessage());
                        return Status.CANCEL_STATUS;
                    }
                    PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logInfo(String.valueOf(toolName) + " : " + Messages.UNINSTALL_TOOL_LOG);
                    return Status.OK_STATUS;
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    int severity = event.getResult().getSeverity();
                    if (severity != 8 && severity != 4) {
                        ToolUpdateUtils.requestRestart(3);
                    }
                }
            });
            job.setSystem(true);
            job.schedule();
        }
    }

    protected void upgradeTool(ToolDescriptor tool) {
        if (tool == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ToolManagerDialog_50, (String)Messages.ToolManagerDialog_51);
            return;
        }
        IInstallableUnit installableUnit = tool.getInstallableUnit();
        boolean platformUnit = this.toolManager.isPlatformUnit(installableUnit);
        if (!platformUnit) {
            UpgradeToolDialog dialog = new UpgradeToolDialog(this.getShell(), tool);
            dialog.setNewInstalledTools(this.newInstalledTools);
            if (dialog.open() == 0) {
                ToolDescriptor newTool = dialog.getNewTool();
                int index = this.installTools.indexOf(tool);
                this.installTools.set(index, newTool);
                this.installIUs = this.toolManager.getInstalledToolIUs();
                this.selectedTool = newTool;
                if (dialog.isUpgrade()) {
                    PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logInfo(String.valueOf((String)tool.getProperties().get("tool.name")) + " : " + Messages.UPGRADE_TOOL_LOG);
                } else {
                    PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logInfo(String.valueOf((String)tool.getProperties().get("tool.name")) + " : " + Messages.DEGRADE_TOOL_LOG);
                }
                this.refreshDetailPanel();
            }
        } else {
            ApplyPlatformPatchDialog dialog = new ApplyPlatformPatchDialog(this.getShell());
            if (dialog.open() == 0) {
                PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logInfo(String.valueOf((String)tool.getProperties().get("tool.name")) + " : " + Messages.Apply_Platform_Patch);
                this.refreshDetailPanel();
            }
        }
    }

    protected void configurationManagement(ToolDescriptor tool) {
        if (tool == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ToolManagerDialog_52, (String)Messages.ToolManagerDialog_53);
            return;
        }
        ConfigurationManagementDialog dialog = new ConfigurationManagementDialog(this.getShell(), tool);
        dialog.open();
    }

    protected void showToolDetail(ToolDescriptor tool) {
        if (tool == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ToolManagerDialog_54, (String)Messages.ToolManagerDialog_55);
            return;
        }
        ToolDetialDialog dialog = new ToolDetialDialog(this.getShell(), tool);
        dialog.open();
    }

    protected void registerTool(ToolDescriptor tool) {
        if (tool == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ToolManagerDialog_56, (String)Messages.ToolManagerDialog_57);
            return;
        }
        RegisterDialog dialog = new RegisterDialog(this.getShell(), tool);
        if (dialog.open() == 0) {
            IInstallableUnit installableUnit = tool.getInstallableUnit();
            if (this.toolManager.isPlatformUnit(installableUnit)) {
                PlatformStateControlUtils.setPlatformState(true);
                ToolStateControlUtils.autoEnableToolsForPlatform();
                this.updateButtonState();
            } else {
                ToolStateControlUtils.autoEnableToolForAuthority(tool);
            }
            this.refreshDetailPanel();
            this.updateBundleForeground();
            PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logInfo(String.valueOf((String)tool.getProperties().get("tool.name")) + " : " + Messages.REGIST_TOOL_LOG);
        }
    }

    protected void updateBundleForeground() {
        int i;
        ArrayList<String> disabledToolName = new ArrayList<String>();
        ArrayList<String> unRegisterToolName = new ArrayList<String>();
        if (this.installTools != null && this.installTools.size() > 0) {
            i = 0;
            while (i < this.installTools.size()) {
                boolean enabled = true;
                if (this.toolManager.isPlatformUnit(this.installTools.get(i).getInstallableUnit())) {
                    if (!PlatformStateControlUtils.isPlatformEnabled()) {
                        disabledToolName.add(this.installTools.get(i).getName());
                        enabled = false;
                    }
                } else if (!BundleUtils.isToolEnabled(this.installTools.get(i))) {
                    disabledToolName.add(this.installTools.get(i).getName());
                    enabled = false;
                }
                if (enabled && !BundleUtils.isToolRegistered(this.installTools.get(i)) && !TestBuildUtils.isTestBuild(this.installTools.get(i).getProperties()) && !RegisterUtils.isUnlimited(this.installTools.get(i).getProperties())) {
                    unRegisterToolName.add(this.installTools.get(i).getName());
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.toolListTable.getTable().getItemCount()) {
            TableItem item = this.toolListTable.getTable().getItem(i);
            String name = (String)item.getData();
            if (name != null) {
                if (disabledToolName.contains(name)) {
                    item.setForeground(this.getShell().getDisplay().getSystemColor(15));
                } else if (unRegisterToolName.contains(name)) {
                    item.setForeground(this.getShell().getDisplay().getSystemColor(3));
                } else {
                    item.setForeground(this.getShell().getDisplay().getSystemColor(2));
                }
            }
            ++i;
        }
    }

    private void updateButtonState() {
        IInstallableUnit installableUnit = this.selectedTool.getInstallableUnit();
        boolean platformUnit = this.toolManager.isPlatformUnit(installableUnit);
        if (PlatformStateControlUtils.isPlatformEnabled()) {
            boolean enabled;
            Boolean state;
            this.installNewToolBtn.setEnabled(true);
            if (platformUnit) {
                this.detailPanel.getEnableDisableBtn().setEnabled(false);
                this.detailPanel.getUnistallBtn().setEnabled(false);
                this.detailPanel.getUpgradeDegradeBtn().setText(Messages.ToolManagerDialog_18_1);
                this.detailPanel.getConfigManagementBtn().setEnabled(true);
                this.detailPanel.getShowPluginDetailBtn().setEnabled(true);
                this.detailPanel.getRegistToolBtn().setEnabled(true);
            } else {
                this.detailPanel.setButtonState(true);
                this.detailPanel.getUpgradeDegradeBtn().setText(Messages.ToolManagerDialog_18);
            }
            String toolStatePreferences = ToolStateControlUtils.getToolStatePreferences(this.selectedTool);
            if (toolStatePreferences.length() > 0 && !(state = Boolean.valueOf(toolStatePreferences)).booleanValue() && !(enabled = BundleUtils.isToolEnabled(this.selectedTool))) {
                this.detailPanel.getEnableDisableBtn().setEnabled(false);
            }
        } else {
            this.installNewToolBtn.setEnabled(false);
            if (platformUnit) {
                this.detailPanel.getEnableDisableBtn().setEnabled(false);
                this.detailPanel.getUnistallBtn().setEnabled(false);
                this.detailPanel.getUpgradeDegradeBtn().setEnabled(false);
                this.detailPanel.getConfigManagementBtn().setEnabled(false);
                this.detailPanel.getShowPluginDetailBtn().setEnabled(false);
                this.detailPanel.getRegistToolBtn().setEnabled(true);
            } else {
                this.detailPanel.setButtonState(false);
            }
        }
    }

    class DetalPanel
    extends Composite {
        private ToolDescriptor tool;
        private Text nameField;
        private Text versionField;
        private Text providerField;
        private Text releaseDateField;
        private Text stateField;
        private Text registerStateField;
        private Text registerDateField;
        private Text licenseField;
        private Button enableDisableBtn;
        private Button unistallBtn;
        private Button upgradeDegradeBtn;
        private Button configManagementBtn;
        private Button showPluginDetailBtn;
        private Button registToolBtn;

        public DetalPanel(Composite parent, int style) {
            super(parent, style);
            this.createControl(parent);
        }

        protected void createControl(Composite parent) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginTop = 20;
            gridLayout.marginBottom = 0;
            this.setLayout((Layout)gridLayout);
            SashForm sash = ControlFactory.createSashForm(this, 66048);
            Composite top = new Composite((Composite)sash, 0);
            top.setLayout((Layout)new GridLayout(2, false));
            this.nameField = ControlFactory.createLabeledText(top, Messages.ToolManagerDialog_8, 8, null);
            this.versionField = ControlFactory.createLabeledText(top, Messages.ToolManagerDialog_9, 8, null);
            this.providerField = ControlFactory.createLabeledText(top, Messages.ToolManagerDialog_10, 8, null);
            this.releaseDateField = ControlFactory.createLabeledText(top, Messages.ToolManagerDialog_11, 8, null);
            this.stateField = ControlFactory.createLabeledText(top, Messages.ToolManagerDialog_12, 8, null);
            this.registerStateField = ControlFactory.createLabeledText(top, Messages.ToolManagerDialog_13, 8, null);
            this.registerDateField = ControlFactory.createLabeledText(top, Messages.ToolManagerDialog_14, 8, null);
            ControlFactory.createLabel(top, Messages.ToolManagerDialog_15, 2);
            this.licenseField = ControlFactory.createLongTextField(top, 2, 2058);
            Composite comp = ControlFactory.createComposite((Composite)sash, 2);
            GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(true).applyTo(comp);
            this.createButtons(comp);
            if (!PlatformStateControlUtils.isPlatformEnabled()) {
                this.setButtonState(false);
            }
            sash.setWeights(new int[]{80, 20});
            ControlFactory.setEditable(false, this.nameField, this.versionField, this.providerField, this.releaseDateField, this.stateField, this.registerStateField, this.registerDateField);
        }

        private void createButtons(Composite comp) {
            this.enableDisableBtn = ControlFactory.createPushButton(comp, Messages.ToolManagerDialog_16, 1808, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolManagerDialog.this.toggleTool(DetalPanel.this.tool);
                }
            });
            this.unistallBtn = ControlFactory.createPushButton(comp, Messages.ToolManagerDialog_17, 1808, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolManagerDialog.this.uninstallTool(DetalPanel.this.tool);
                }
            });
            this.upgradeDegradeBtn = ControlFactory.createPushButton(comp, Messages.ToolManagerDialog_18, 1808, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolManagerDialog.this.upgradeTool(DetalPanel.this.tool);
                }
            });
            this.configManagementBtn = ControlFactory.createPushButton(comp, Messages.ToolManagerDialog_19, 1808, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolManagerDialog.this.configurationManagement(DetalPanel.this.tool);
                }
            });
            this.showPluginDetailBtn = ControlFactory.createPushButton(comp, Messages.ToolManagerDialog_20, 1808, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolManagerDialog.this.showToolDetail(DetalPanel.this.tool);
                }
            });
            this.registToolBtn = ControlFactory.createPushButton(comp, Messages.ToolManagerDialog_21, 1808, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolManagerDialog.this.registerTool(DetalPanel.this.tool);
                }
            });
        }

        public void setInput(ToolDescriptor tool) {
            this.tool = tool;
            if (tool != null) {
                ToolDescriptor.ToolProperties info = tool.props;
                String name = this.trim(info.getName());
                if (PatchUtils.isPlatformPatched()) {
                    IInstallableUnit installableUnit = tool.getInstallableUnit();
                    boolean platformUnit = ToolManagerDialog.this.toolManager.isPlatformUnit(installableUnit);
                    if (platformUnit) {
                        try {
                            IInstallableUnit patchUnit = ToolManagerDialog.this.toolManager.findInstallIU("com.soyatec.hisilicon.platform.update.feature.feature.group", null);
                            if (patchUnit != null) {
                                name = String.valueOf(name) + "-[" + Messages.Patch_Version + patchUnit.getVersion() + "]";
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this.nameField.isDisposed()) {
                    return;
                }
                this.nameField.setText(name);
                this.versionField.setText(this.trim(info.getVersion()));
                this.providerField.setText(this.trim(info.getProvider()));
                this.releaseDateField.setText(this.trim(info.getReleaseDate()));
                this.stateField.setText(BundleUtils.isToolEnabled(tool) ? Messages.ToolManagerDialog_22 : Messages.ToolManagerDialog_23);
                if (TestBuildUtils.isTestBuild(tool.getProperties())) {
                    this.registerStateField.setText(Messages.ToolManagerDialog_24_1);
                    this.registerDateField.setText(this.trim(null));
                } else if (RegisterUtils.isUnlimited(tool.getProperties())) {
                    this.registerStateField.setText(Messages.ToolManagerDialog_24);
                    this.registerDateField.setText(this.trim(null));
                } else {
                    Date d = RegisterUtils.getRegisterDate(tool.getProperties());
                    if (d != null) {
                        String code = RegisterUtils.getRegisterCode(tool.getProperties());
                        if (!RegisterUtils.isValidRegisterCode(tool.getProperties(), code)) {
                            this.registerStateField.setText(Messages.ToolManagerDialog_58);
                        } else {
                            this.registerStateField.setText(Messages.ToolManagerDialog_25);
                        }
                        this.registerDateField.setText(d.toLocaleString());
                    } else {
                        this.registerStateField.setText(String.valueOf(Messages.ToolManagerDialog_26) + RegisterUtils.getRemainingTrialPeriod(tool));
                        this.registerDateField.setText(this.trim(null));
                    }
                }
                this.licenseField.setText(this.trim(info.getLicense()));
            } else {
                this.nameField.setText("");
                this.versionField.setText("");
                this.providerField.setText("");
                this.releaseDateField.setText("");
                this.stateField.setText("");
                this.registerStateField.setText("");
                this.registerDateField.setText("");
                this.licenseField.setText("");
            }
        }

        public String trim(String str) {
            return str == null ? "N/A" : str.trim();
        }

        public Button getEnableDisableBtn() {
            return this.enableDisableBtn;
        }

        public Button getUnistallBtn() {
            return this.unistallBtn;
        }

        public Button getUpgradeDegradeBtn() {
            return this.upgradeDegradeBtn;
        }

        public Button getConfigManagementBtn() {
            return this.configManagementBtn;
        }

        public Button getShowPluginDetailBtn() {
            return this.showPluginDetailBtn;
        }

        public Button getRegistToolBtn() {
            return this.registToolBtn;
        }

        public void setButtonState(boolean state) {
            this.getEnableDisableBtn().setEnabled(state);
            this.getUnistallBtn().setEnabled(state);
            this.getUpgradeDegradeBtn().setEnabled(state);
            this.getConfigManagementBtn().setEnabled(state);
            this.getShowPluginDetailBtn().setEnabled(state);
            this.getRegistToolBtn().setEnabled(state);
        }
    }
}

