/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.tool;

import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.ui.Messages;
import com.soyatec.hisilicon.platform.ui.internal.ControlFactory;
import com.soyatec.hisilicon.platform.ui.tool.ViewerProviderFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ToolDetialDialog
extends Dialog {
    private Text nameField;
    private Text versionField;
    private Text providerField;
    private Text releaseDateField;
    private ToolDescriptor toolDesc;
    private TableViewer pluginDetailViewer;

    public ToolDetialDialog(Shell parentShell, ToolDescriptor tool) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.toolDesc = tool;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ToolDetialDialog_0);
        newShell.setSize(480, 400);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData(4, 0x1000000, true, false);
        parent.setLayoutData((Object)data);
        Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        GridData okGD = (GridData)okButton.getLayoutData();
        okGD.horizontalAlignment = 0x1000000;
        okGD.grabExcessHorizontalSpace = true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.createOverviewGroup(comp);
        this.createDetailGroup(comp);
        this.initData();
        return comp;
    }

    private void initData() {
        ToolDescriptor.ToolProperties props = this.toolDesc.props;
        this.nameField.setText(this.trim(props.getName()));
        this.versionField.setText(this.trim(props.getVersion()));
        this.providerField.setText(this.trim(props.getProvider()));
        this.releaseDateField.setText(this.trim(props.getReleaseDate()));
        this.pluginDetailViewer.setInput((Object)this.toolDesc.getPlugins());
    }

    private void createDetailGroup(Composite comp) {
        Group detailGroup = ControlFactory.createGroup(comp, Messages.ToolDetialDialog_1, 1, 1808);
        this.pluginDetailViewer = ControlFactory.createTableViewer((Composite)detailGroup, -1, -1, 67584, this.getColumnNames(), new int[]{20, 30, 30, 20});
        this.pluginDetailViewer.setLabelProvider((IBaseLabelProvider)ViewerProviderFactory.getLabelProvider(ToolDescriptor.PluginDetail.class));
        this.pluginDetailViewer.setContentProvider((IContentProvider)ViewerProviderFactory.getListContentProvider());
    }

    private void createOverviewGroup(Composite comp) {
        Group group = ControlFactory.createGroup(comp, Messages.ToolDetialDialog_2, 4);
        this.nameField = ControlFactory.createLabeledText((Composite)group, Messages.ToolDetialDialog_3, 2048, null);
        this.versionField = ControlFactory.createLabeledText((Composite)group, Messages.ToolDetialDialog_4, 2048, null);
        this.providerField = ControlFactory.createLabeledText((Composite)group, Messages.ToolDetialDialog_5, 2048, null);
        this.releaseDateField = ControlFactory.createLabeledText((Composite)group, Messages.ToolDetialDialog_6, 2048, null);
        ControlFactory.setEditable(false, this.nameField, this.versionField, this.providerField, this.releaseDateField);
    }

    private String[] getColumnNames() {
        return new String[]{Messages.ToolDetialDialog_7, Messages.ToolDetialDialog_8, Messages.ToolDetialDialog_9, Messages.ToolDetialDialog_10};
    }

    public String trim(String str) {
        return str == null ? "N/A" : str.trim();
    }
}

