/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import com.soyatec.hisilicon.platform.api.IDeviceChangedListener;
import com.soyatec.hisilicon.platform.api.chips.Chip;
import com.soyatec.hisilicon.platform.core.IToolManager;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.core.internal.DeviceManager;
import com.soyatec.hisilicon.platform.ui.internal.BundleUtils;
import com.soyatec.hisilicon.platform.ui.internal.PerspectiveUtil;
import com.soyatec.hisilicon.platform.ui.internal.ToolEntryAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;

public class ToolEntryBarManager
implements IDeviceChangedListener {
    public static final ToolEntryBarManager INSTANCE = new ToolEntryBarManager();

    private ToolEntryBarManager() {
    }

    private ToolDescriptor findToolByPerspectivePluginID(String pluginID) {
        IToolManager toolManager = PlatformCoreActivator.getDefault().getToolManager();
        List installTools = toolManager.collectFeatureToolsAndPlatform(toolManager.getInstalledToolAndPlatformIUs());
        if (installTools != null && installTools.size() > 0) {
            int i = 0;
            while (i < installTools.size()) {
                ToolDescriptor toolDescriptor = (ToolDescriptor)installTools.get(i);
                String[] pluginIds = toolDescriptor.getPluginIds();
                List<String> list = Arrays.asList(pluginIds);
                if (list.contains(pluginID)) {
                    return toolDescriptor;
                }
                ++i;
            }
        }
        return null;
    }

    public void init() {
        DeviceManager.getInstance().addDeviceChangedListener((IDeviceChangedListener)this);
    }

    public void deviceChanged(Chip chip) {
        IExtension[] extensions;
        IContributionItem[] items;
        IToolBarManager toolbar = null;
        WorkbenchWindow window = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IContributionItem[] iContributionItemArray = items = window.getCoolBarManager2().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ToolBarContributionItem tbci;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ToolBarContributionItem && (tbci = (ToolBarContributionItem)item).getId().equals("tool_entry")) {
                toolbar = tbci.getToolBarManager();
                break;
            }
            ++n2;
        }
        if (toolbar == null) {
            return;
        }
        toolbar.removeAll();
        ArrayList<String> perspectivesIds = new ArrayList<String>();
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint ep = extReg.getExtensionPoint("org.eclipse.ui.perspectives");
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n3 = extensions.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement[] configurationElements;
            IExtension extension = iExtensionArray[n4];
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
            int n5 = configurationElements.length;
            int n6 = 0;
            while (n6 < n5) {
                IConfigurationElement element = iConfigurationElementArray[n6];
                String perspectiveID = element.getAttribute("id");
                if (!perspectiveID.equals("com.soyatec.hisilicon.platform.ui.Perspective")) {
                    perspectivesIds.add(perspectiveID);
                }
                ++n6;
            }
            ++n4;
        }
        String currentDevice = chip.getName();
        PerspectiveRegistry persReg = (PerspectiveRegistry)PlatformUI.getWorkbench().getPerspectiveRegistry();
        PerspectiveDescriptor perspective = (PerspectiveDescriptor)persReg.findPerspectiveWithId("com.soyatec.hisilicon.platform.ui.Perspective");
        ToolEntryAction action = new ToolEntryAction(perspective.getLabel(), perspective);
        if (!action.init()) {
            return;
        }
        ActionContributionItem tbci = new ActionContributionItem((IAction)action);
        tbci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolbar.add((IContributionItem)tbci);
        for (String perspectiveID : perspectivesIds) {
            ToolDescriptor tool;
            perspective = (PerspectiveDescriptor)persReg.findPerspectiveWithId(perspectiveID);
            if (perspective == null || (tool = this.findToolByPerspectivePluginID(perspective.getPluginId())) == null) continue;
            if (!BundleUtils.suitableForChip(tool, currentDevice)) {
                if (window.getActivePage().getPerspective() == perspective) {
                    try {
                        PerspectiveUtil.openPerspective("com.soyatec.hisilicon.platform.ui.Perspective");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                PerspectiveUtil.closePerpective(perspective.getId());
                continue;
            }
            action = new ToolEntryAction(tool.getName(), perspective);
            if (!action.init()) continue;
            tbci = new ActionContributionItem((IAction)action);
            tbci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            toolbar.add((IContributionItem)tbci);
        }
        toolbar.update(true);
    }
}

