/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import com.soyatec.hisilicon.platform.ui.internal.Base64;
import com.soyatec.hisilicon.platform.ui.internal.ReflectUtil;
import com.soyatec.hisilicon.platform.ui.internal.StringConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.ui.WorkbenchEncoding;

public class TestBuildUtils {
    private static String LINE_SEP = StringConstants.decode("3338");
    private static String SPACE_SEP = StringConstants.decode("605449");
    private static String TEST_BUILD = StringConstants.decode("549665952489735581166692");
    private static String TRUE = StringConstants.decode("1953658213");
    private static String KEY_ALGORITHM = StringConstants.decode("4477761");
    private static String SIGNATURE_ALGORITHM = StringConstants.decode("100682056017579205850321729");
    private static String SIG = StringConstants.decode("7563623");
    private static String ORG_ECLIPSE_EQUINOX_P2 = StringConstants.decode("10674491078084225838530363895422676461838320513026372142");
    private static String JAVA_SECURITY_KEY_FACTORY = StringConstants.decode("2608447482597353261333165008531386025052865138478231286393");
    private static String UPDATE = StringConstants.decode("129125580895333");
    private static String JAVA_SECURITY_SIGNATURE = StringConstants.decode("10189247978895911177082675814575726808219914844178313829");
    private static String GET_INSTANCE = StringConstants.decode("124998463548682745364243301");
    private static String INIT_VERIFY = StringConstants.decode("497885221342885790180985");
    private static String GENERATE_PUBLIC = StringConstants.decode("2097124399582798381219256713636195");
    private static String JAVA_SECURITY_SPEC_X509_ENCODED_KEY_SPEC = StringConstants.decode("52905600271653581246875512122309518518511744853134121544190262448053293812687565497591139");
    private static String VERIFY = StringConstants.decode("130178083284601");

    public static boolean isTestBuild(Map<String, String> originalMap) {
        if (originalMap == null) {
            return false;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        Set<String> keySet = originalMap.keySet();
        if (keySet != null && keySet.size() > 0) {
            for (String key : keySet) {
                if (key.startsWith(ORG_ECLIPSE_EQUINOX_P2)) continue;
                props.put(key, originalMap.get(key));
            }
        }
        if (props.size() == 0) {
            return false;
        }
        String sig = (String)props.get(SIG);
        if (sig == null) {
            return false;
        }
        if (!TRUE.equalsIgnoreCase((String)props.get(TEST_BUILD))) {
            return false;
        }
        props.put(SIG, "");
        try {
            String pk = "MIIBuDCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYUAAoGBAK0FLREZx6nvY5LPBD7tismbO2rIeIWvCzPo9miqKAYpbmjOFhGksQbox1sS6pI2sNCaxBWHo3/OXueV+o9yYiazgzHiBQMGPP7QJ6KK3oH/g9+bsZRxEybu5kj8nQRVwxiaeklLOPrAkdBcBwCR9+EK6i93d0hPtPXWKul2he3n";
            String str = TestBuildUtils.toString(props);
            boolean bl = TestBuildUtils.verify(str.getBytes(WorkbenchEncoding.getWorkbenchDefaultEncoding()), Base64.decode(pk), Base64.decode(sig));
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            props.put(SIG, sig);
        }
        return false;
    }

    public static boolean verify(byte[] data, byte[] key, byte[] sign) {
        try {
            Object k = ReflectUtil.getInstance(JAVA_SECURITY_KEY_FACTORY, GET_INSTANCE, KEY_ALGORITHM);
            Object x = ReflectUtil.newInstance(JAVA_SECURITY_SPEC_X509_ENCODED_KEY_SPEC, new Object[]{key});
            Object p = ReflectUtil.invoke(k, GENERATE_PUBLIC, x);
            Object s = ReflectUtil.getInstance(JAVA_SECURITY_SIGNATURE, GET_INSTANCE, SIGNATURE_ALGORITHM);
            ReflectUtil.invoke(s, INIT_VERIFY, p);
            ReflectUtil.invoke(s, UPDATE, new Object[]{data});
            return (Boolean)ReflectUtil.invoke(s, VERIFY, new Object[]{sign});
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String toString(Map<String, String> props) {
        TreeSet<String> keys = new TreeSet<String>();
        keys.addAll(props.keySet());
        StringBuilder sb = new StringBuilder();
        for (String k : keys) {
            String v = props.get(k);
            sb.append(k).append(SPACE_SEP).append(v).append(LINE_SEP);
        }
        return sb.toString();
    }
}

