/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import com.soyatec.hisilicon.platform.core.IToolManager;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.core.log.HiLog;
import com.soyatec.hisilicon.platform.core.log.HiLogs;
import com.soyatec.hisilicon.platform.ui.Messages;
import com.soyatec.hisilicon.platform.ui.PlatformUIActivator;
import com.soyatec.hisilicon.platform.ui.internal.ControlFactory;
import com.soyatec.hisilicon.platform.ui.internal.HiLogUtils;
import com.soyatec.hisilicon.platform.ui.internal.LogUtils;
import com.soyatec.hisilicon.platform.ui.tool.ViewerProviderFactory;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class ShowLogDialog
extends Dialog {
    private DateTime startTime;
    private DateTime endTime;
    private CCombo logLevel;
    private static final int exportLogBtnID = 101;
    private static final int clearLogBtnID = 102;
    private TableViewer logTableViewer;
    private List<ToolDescriptor> installTools;
    private CheckboxTableViewer toolsViewer;
    private HiLogUtils.LogViewerFilter logViewerFilter = new HiLogUtils.LogViewerFilter();

    public ShowLogDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ShowLogDialog_0);
        newShell.setSize(800, 500);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 101, Messages.ShowLogDialog_2, false);
        this.createButton(parent, 102, Messages.ShowLogDialog_3, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Control comp = super.createDialogArea(parent);
        SashForm sash = ControlFactory.createSashForm((Composite)comp, 65792);
        this.createMasterPanel(sash);
        this.createDetailPanel(sash);
        sash.setWeights(new int[]{1, 2});
        return comp;
    }

    private void createDetailPanel(SashForm sash) {
        Composite comp = ControlFactory.createComposite((Composite)sash, 1);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        comp.setLayout((Layout)gl);
        Label logs = ControlFactory.createLabel(comp, Messages.ShowLogDialog_4, 1);
        logs.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        logs.setForeground(this.getShell().getDisplay().getSystemColor(9));
        this.logTableViewer = LogUtils.createTableViewer(comp, -1, -1, 67584, this.getColumnNames(), new int[]{20, 20, 60});
        this.logTableViewer.addFilter((ViewerFilter)this.logViewerFilter);
        this.logTableViewer.setLabelProvider((IBaseLabelProvider)ViewerProviderFactory.getLabelProvider(HiLog.class));
        this.logTableViewer.setContentProvider((IContentProvider)ViewerProviderFactory.getListContentProvider());
    }

    private void createMasterPanel(SashForm sash) {
        Composite comp = ControlFactory.createComposite((Composite)sash, 2, 2048, 1808, 1);
        this.startTime = ControlFactory.createDateField(comp, Messages.ShowLogDialog_5);
        this.endTime = ControlFactory.createDateField(comp, Messages.ShowLogDialog_6);
        ControlFactory.createLabel(comp, Messages.ShowLogDialog_7, 1);
        this.logLevel = ControlFactory.createSelectCCombo(comp, this.getLogLevels(), null);
        ControlFactory.createLabel(comp, Messages.ShowLogDialog_8, 2);
        String[] allTools = null;
        try {
            String platformToolName;
            IToolManager m;
            ToolDescriptor platformTool;
            String[] installToolNames = this.getInstallTools();
            if (installToolNames != null && installToolNames.length > 0) {
                allTools = installToolNames;
            }
            if ((platformTool = (m = PlatformCoreActivator.getDefault().getToolManager()).findPlatformTool()) != null && (platformToolName = (String)platformTool.getProperties().get("tool.name")) != null) {
                if (allTools != null) {
                    allTools = Arrays.copyOf(allTools, allTools.length + 1);
                    allTools[allTools.length - 1] = platformToolName;
                } else {
                    allTools = new String[]{platformToolName};
                }
            }
        }
        catch (Exception e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        this.toolsViewer = ControlFactory.createCheckboxTableViewer(comp, allTools, -1, -1, 4);
        GridDataFactory.swtDefaults().grab(true, true).align(4, 4).span(2, 1).applyTo((Control)this.toolsViewer.getTable());
        Button queryLogBtn = new Button(comp, 0);
        queryLogBtn.setText(Messages.ShowLogDialog_1);
        GridDataFactory.swtDefaults().grab(false, false).align(131072, 0x1000000).span(2, 1).applyTo((Control)queryLogBtn);
        queryLogBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Map map = ShowLogDialog.this.constructSearchConditionMap();
                ShowLogDialog.this.logTableViewer.setInput(HiLogUtils.queryLogs(map));
                ShowLogDialog.this.logTableViewer.refresh();
            }
        });
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (101 == buttonId) {
            FileDialog fd = new FileDialog(this.getShell(), 8192);
            String path = fd.open();
            if (path != null) {
                this.processLogsOutput(path);
            }
        } else if (102 == buttonId) {
            HiLogUtils.deleteLogs(this.getCurrentLogs(), HiLogUtils.findLogDelFile());
            this.logViewerFilter.updateCurrentFilterLogs();
            this.logTableViewer.setInput(null);
            this.logTableViewer.refresh();
        }
    }

    private void processLogsOutput(String path) {
        ArrayList<HiLog> list = this.getCurrentLogs();
        HiLogs hilogs = new HiLogs();
        hilogs.setHilogs(list);
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");
            PlatformCoreActivator.getDefault().saveXml((Object)hilogs, (Writer)out);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ShowLogDialog_9, (String)(String.valueOf(Messages.ShowLogDialog_10) + e.getMessage()));
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ShowLogDialog_11, (String)Messages.ShowLogDialog_12);
    }

    private ArrayList<HiLog> getCurrentLogs() {
        ArrayList<HiLog> list = new ArrayList<HiLog>();
        TableItem[] items = this.logTableViewer.getTable().getItems();
        if (items != null && items.length > 0) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                HiLog hiLog = (HiLog)item.getData();
                list.add(hiLog);
                ++n2;
            }
        }
        return list;
    }

    private Map<String, Object> constructSearchConditionMap() {
        List<Object> checkedToolNameList;
        String[] array;
        List<String> list;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object[] checkedToolNames = this.toolsViewer.getCheckedElements();
        if (checkedToolNames != null && checkedToolNames.length > 0 && (list = Arrays.asList(array = (checkedToolNameList = Arrays.asList(checkedToolNames)).toArray(new String[0]))) != null && list.size() > 0) {
            map.put("tool.name", list);
        }
        if (!this.logLevel.getText().equals(Level.ALL.getName())) {
            map.put("log.level", this.logLevel.getText());
        }
        map.put("starttime", HiLogUtils.convertDate(this.startTime, true).getTimeInMillis());
        map.put("endtime", HiLogUtils.convertDate(this.endTime, false).getTimeInMillis());
        return map;
    }

    private String[] getColumnNames() {
        return new String[]{Messages.ShowLogDialog_13, Messages.ShowLogDialog_14, Messages.ShowLogDialog_15};
    }

    private String[] getLogLevels() {
        return new String[]{Level.ALL.getName(), Level.INFO.getName(), Level.WARNING.getName(), "ERROR", "FATAL"};
    }

    private String[] getInstallTools() {
        IToolManager m = PlatformCoreActivator.getDefault().getToolManager();
        this.installTools = m.collectFeatureTools(m.getInstalledToolIUs());
        return m.getToolNames(this.installTools);
    }
}

