/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.ui.PlatformUIActivator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.datalocation.Location;

public class IniUtils {
    public static final String NL_KEY = "osgi.nl";
    public static final String DEFAULT_ECLIPSE_INI = "eclipse.ini";
    public static final String DEFAULT_ECLIPSE_CONFIG_INI = "config.ini";

    public static File findConfigFile() {
        File ini;
        Location installLocation = Platform.getInstallLocation();
        String file = installLocation.getURL().getFile();
        File installFolder = new File(file);
        if (installFolder.exists() && (ini = new File(installFolder, "configuration" + File.separator + DEFAULT_ECLIPSE_CONFIG_INI)).exists()) {
            return ini;
        }
        return null;
    }

    public static void updateIniConfiguration(String key, String value) {
        File ini = IniUtils.findConfigFile();
        if (ini != null && ini.exists()) {
            IniUtils.updateSetting(ini, key, value);
        }
    }

    public static String getIniConfiguration(String key) {
        File ini = IniUtils.findConfigFile();
        if (ini != null && ini.exists()) {
            return IniUtils.getSetting(ini, key);
        }
        return "";
    }

    public static String getSetting(File ini, String key) {
        String rs;
        block13: {
            FileInputStream input = null;
            rs = "";
            try {
                try {
                    input = new FileInputStream(ini);
                    Properties prop = new Properties();
                    prop.load(input);
                    if (prop.get(key) != null) {
                        rs = String.valueOf(prop.get(key));
                    }
                }
                catch (Exception e) {
                    PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                    if (input == null) break block13;
                    try {
                        input.close();
                    }
                    catch (IOException e2) {
                        PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return rs;
    }

    public static void updateSetting(File ini, String key, String value) {
        FileInputStream input = null;
        Properties prop = null;
        try {
            try {
                input = new FileInputStream(ini);
                prop = new Properties();
                prop.load(input);
                prop.put(key, value);
            }
            catch (Exception e) {
                PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e2) {
                    PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e2.getMessage(), (Throwable)e2);
                    return;
                }
                return;
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                return;
            }
        }
        if (prop != null && prop.size() > 0) {
            FileOutputStream output = null;
            try {
                try {
                    output = new FileOutputStream(ini);
                    prop.store(output, null);
                }
                catch (Exception e) {
                    PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (IOException e3) {
                        PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e3.getMessage(), (Throwable)e3);
                    }
                }
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e) {
                    PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

