/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ControlFactory {
    public static File openFileDialog(Shell shell, File startingDirectory, File filterPath, String[] extensions) {
        String file;
        FileDialog dialog = new FileDialog(shell, 0x10001000);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        } else if (filterPath != null) {
            dialog.setFilterPath(filterPath.getPath());
        }
        if (extensions != null) {
            dialog.setFilterExtensions(extensions);
        }
        if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
            return new File(file);
        }
        return null;
    }

    public static Text createFileField(final Composite parent, String label, String buttonText, final SelectionListener l) {
        final Text text = ControlFactory.createLabeledText(parent, label, 0, null);
        ControlFactory.createPushButton(parent, buttonText, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                File f = text.getText() != null ? new File(text.getText()) : null;
                f = ControlFactory.openFileDialog(parent.getShell(), f, null, null);
                if (f != null) {
                    text.setText(f.getAbsolutePath());
                }
                if (l != null) {
                    l.widgetSelected(e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return text;
    }

    public static Text createFileFieldWithWidth(final Composite parent, String label, String buttonText, int labelWidthHint, final SelectionListener l) {
        final Text text = ControlFactory.createLabeledTextWithWidth(parent, label, 0, labelWidthHint, null);
        ControlFactory.createPushButton(parent, buttonText, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                File f = text.getText() != null ? new File(text.getText()) : null;
                f = ControlFactory.openFileDialog(parent.getShell(), f, null, null);
                if (f != null) {
                    text.setText(f.getAbsolutePath());
                }
                if (l != null) {
                    l.widgetSelected(e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return text;
    }

    public static DateTime createDateField(Composite parent, String label) {
        Label lbl = new Label(parent, 0);
        lbl.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lbl.setText(label);
        DateTime date = new DateTime(parent, 2080);
        date.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        return date;
    }

    public static Text createLabeledText(Composite parent, String label, int style, ModifyListener listener) {
        final Label lbl = new Label(parent, 0);
        lbl.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lbl.setText(label);
        Text text = new Text(parent, 0x800 | style){

            public void setEnabled(boolean flag) {
                lbl.setEnabled(flag);
                super.setEnabled(flag);
            }

            protected void checkSubclass() {
            }
        };
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (listener != null) {
            text.addModifyListener(listener);
        }
        return text;
    }

    public static Text createLabeledTextWithWidth(Composite parent, String label, int style, int labelWidthHint, ModifyListener listener) {
        final Label lbl = new Label(parent, 0);
        GridData gridData = new GridData(1, 0x1000000, false, false);
        gridData.widthHint = labelWidthHint;
        lbl.setLayoutData((Object)gridData);
        lbl.setText(label);
        Text text = new Text(parent, 0x800 | style){

            public void setEnabled(boolean flag) {
                lbl.setEnabled(flag);
                super.setEnabled(flag);
            }

            protected void checkSubclass() {
            }
        };
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (listener != null) {
            text.addModifyListener(listener);
        }
        return text;
    }

    public static Button createPushButton(Composite parent, String key, SelectionListener listener) {
        Button button = new Button(parent, 8);
        if (key != null) {
            button.setText(JFaceResources.getString((String)key));
        }
        button.setFont(parent.getFont());
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    public static SashForm createSashForm(Composite parent, int style) {
        SashForm sashForm = new SashForm(parent, style);
        GridData data = new GridData(1808);
        sashForm.setLayoutData((Object)data);
        return sashForm;
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        return ControlFactory.createCompositeEx(parent, numColumns, 768, 1);
    }

    public static Composite createCompositeEx(Composite parent, int numColumns, int layoutMode, int span) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(numColumns, false));
        GridData gd = new GridData(layoutMode);
        gd.horizontalSpan = span;
        composite.setLayoutData((Object)gd);
        return composite;
    }

    public static Composite createCompositeEx(SashForm parent, int numColumns, int layoutMode, int span) {
        Composite composite = new Composite((Composite)parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(numColumns, false));
        return composite;
    }

    public static Composite createComposite(Composite parent, int numColumns, int style, int layoutMode, int span) {
        Composite composite = new Composite(parent, style);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(numColumns, false));
        GridData gd = new GridData(layoutMode);
        gd.horizontalSpan = span;
        composite.setLayoutData((Object)gd);
        return composite;
    }

    public static Label createLabel(Composite parent, String text, int widthHint, int heightHint, int style, int span) {
        Label label = new Label(parent, style);
        label.setFont(parent.getFont());
        label.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = widthHint;
        gd.heightHint = heightHint;
        label.setLayoutData((Object)gd);
        return label;
    }

    public static Label createLabel(Composite parent, String text, int span) {
        return ControlFactory.createLabel(parent, text, -1, -1, 16384, span);
    }

    public static Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setFont(group.getFont());
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        button.setBackground(group.getBackground());
        button.setForeground(group.getForeground());
        return button;
    }

    public static Button createRadioButton(Composite group, String label, String value, SelectionListener listener) {
        Button button = new Button(group, 16400);
        button.setFont(group.getFont());
        button.setText(label);
        button.setData((Object)(value == null ? label : value));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        button.setLayoutData((Object)data);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    public static Button createPushButton(Composite parent, String label, int layoutMode, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        button.addSelectionListener(listener);
        GridData data = new GridData(layoutMode);
        button.setLayoutData((Object)data);
        return button;
    }

    public static Text createTextField(Composite parent) {
        return ControlFactory.createTextField(parent, 2052);
    }

    public static Text createTextField(Composite parent, int style) {
        Text text = new Text(parent, style);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Text createLongTextField(Composite parent, int span, int style) {
        Text text = new Text(parent, style);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = span;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Group createGroup(Composite parent, String label, int nColumns) {
        return ControlFactory.createGroup(parent, label, nColumns, 768);
    }

    public static Group createGroup(Composite parent, String label, int nColumns, int style) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setText(label);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(style));
        return group;
    }

    public static List createList(Composite parent, String strdata, String selData) {
        List list = new List(parent, 4);
        list.setFont(parent.getFont());
        GridData data = new GridData();
        list.setLayoutData((Object)data);
        StringTokenizer st = new StringTokenizer(strdata, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        if (selData == null) {
            if (list.getItemCount() > 0) {
                list.select(0);
            }
        } else {
            ControlFactory.selectList(list, selData);
        }
        return list;
    }

    public static void selectList(List list, String selData) {
        int n_sel = list.indexOf(selData);
        if (n_sel < 0) {
            n_sel = 0;
        }
        list.select(n_sel);
    }

    public static TableViewer createTableViewer(Composite parent, String[] opt_list, int width, int height, int style) {
        Composite composite = new Composite(parent, 0);
        TableColumnLayout tcl = new TableColumnLayout();
        composite.setLayout((Layout)tcl);
        GridData data = new GridData(1808);
        if (width != -1) {
            data.widthHint = width;
        }
        if (height != -1) {
            data.heightHint = height;
        }
        composite.setLayoutData((Object)data);
        TableViewer listViewer = new TableViewer(composite, 0x800 | style);
        TableColumn column = new TableColumn(listViewer.getTable(), 0);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100));
        if (opt_list != null && opt_list.length > 0) {
            listViewer.add((Object[])opt_list);
        }
        return listViewer;
    }

    public static TableViewer createTableViewer(Composite parent, int width, int height, int style, String[] columns, int[] colWidths) {
        TableViewer listViewer = new TableViewer(parent, 0x800 | style);
        GridData data = new GridData(1808);
        if (width != -1) {
            data.widthHint = width;
        }
        if (height != -1) {
            data.heightHint = height;
        }
        listViewer.getTable().setLayoutData((Object)data);
        Table table = listViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columns[i]);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(colWidths[i], true));
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        return listViewer;
    }

    public static void deactivateCellEditor(TableViewer viewer) {
        if (viewer == null) {
            return;
        }
        CellEditor[] es = viewer.getCellEditors();
        TableItem[] items = viewer.getTable().getSelection();
        if (items.length >= 0) {
            int i = 0;
            while (i < es.length) {
                CellEditor e = es[i];
                if (e.isActivated()) {
                    if (e.isValueValid()) {
                        Object[] properties = viewer.getColumnProperties();
                        Object value = e.getValue();
                        viewer.cancelEditing();
                        viewer.getCellModifier().modify((Object)items[0], (String)properties[i], value);
                        break;
                    }
                    viewer.cancelEditing();
                    break;
                }
                ++i;
            }
        }
    }

    public static CheckboxTableViewer createCheckboxTableViewer(Composite parent, String[] opt_list, int width, int height, int style) {
        Table table = new Table(parent, 2080);
        table.setFont(parent.getFont());
        CheckboxTableViewer listViewer = new CheckboxTableViewer(table);
        GridData data = new GridData(style);
        if (width != -1) {
            data.widthHint = width;
        }
        if (height != -1) {
            data.heightHint = height;
        }
        if ((style & 4) != 0) {
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 256;
            data.verticalAlignment = 16;
        }
        listViewer.getTable().setLayoutData((Object)data);
        if (opt_list != null) {
            listViewer.add((Object[])opt_list);
        }
        return listViewer;
    }

    public static CheckboxTableViewer createCheckboxTableViewer(Composite parent, int width, int height, int style, String[] columns, int[] colWidths) {
        CheckboxTableViewer listViewer = ControlFactory.createCheckboxTableViewer(parent, null, width, height, style);
        Table table = listViewer.getTable();
        table.setFont(parent.getFont());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column = table.getColumn(0);
        column.setText(columns[0]);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(colWidths[0], false));
        int i = 1;
        while (i < columns.length) {
            column = new TableColumn(table, 0);
            column.setText(columns[i]);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(colWidths[i], false));
            ++i;
        }
        return listViewer;
    }

    public static CCombo createSelectCCombo(Composite parent, String strdata, String selData) {
        return ControlFactory.createSelectCCombo(parent, strdata, selData, 2056);
    }

    public static CCombo createSelectCCombo(Composite parent, String strdata, String selData, int style) {
        CCombo combo = new CCombo(parent, style);
        combo.setFont(parent.getFont());
        GridData data = new GridData(768);
        combo.setLayoutData((Object)data);
        StringTokenizer st = new StringTokenizer(strdata, ",");
        while (st.hasMoreTokens()) {
            combo.add(st.nextToken());
        }
        if (selData == null || selData.length() == 0) {
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        } else {
            ControlFactory.selectCCombo(combo, selData);
        }
        return combo;
    }

    public static CCombo createSelectCCombo(Composite parent, String[] strdata, String selData) {
        return ControlFactory.createSelectCCombo(parent, strdata, selData, 2060);
    }

    public static CCombo createSelectCCombo(Composite parent, String[] strdata, String selData, int style) {
        CCombo combo = new CCombo(parent, style);
        combo.setFont(parent.getFont());
        GridData data = new GridData(768);
        combo.setLayoutData((Object)data);
        int i = 0;
        while (i < strdata.length) {
            combo.add(strdata[i]);
            ++i;
        }
        if (selData == null) {
            combo.select(0);
        } else {
            ControlFactory.selectCCombo(combo, selData);
        }
        return combo;
    }

    public static void selectCCombo(CCombo combo, String selData) {
        int n_sel = combo.indexOf(selData);
        if (n_sel < 0) {
            n_sel = 0;
        }
        combo.select(n_sel);
    }

    public static Combo createSelectCombo(Composite parent, String strdata, String selData) {
        return ControlFactory.createSelectCombo(parent, strdata, selData, 2056);
    }

    public static Combo createSelectCombo(Composite parent, String strdata, String selData, int style) {
        Combo combo = new Combo(parent, style);
        combo.setFont(parent.getFont());
        GridData data = new GridData(768);
        combo.setLayoutData((Object)data);
        StringTokenizer st = new StringTokenizer(strdata, ",");
        while (st.hasMoreTokens()) {
            combo.add(st.nextToken());
        }
        if (selData == null || selData.length() == 0) {
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        } else {
            ControlFactory.selectCombo(combo, selData);
        }
        return combo;
    }

    public static Combo createSelectCombo(Composite parent, String[] strdata, String selData) {
        return ControlFactory.createSelectCombo(parent, strdata, selData, 2060);
    }

    public static Combo createSelectCombo(Composite parent, String[] strdata, String selData, int style) {
        Combo combo = new Combo(parent, style);
        combo.setFont(parent.getFont());
        GridData data = new GridData(768);
        combo.setLayoutData((Object)data);
        int i = 0;
        while (i < strdata.length) {
            combo.add(strdata[i]);
            ++i;
        }
        if (selData == null) {
            combo.select(0);
        } else {
            ControlFactory.selectCombo(combo, selData);
        }
        return combo;
    }

    public static void selectCombo(Combo combo, String selData) {
        int n_sel = combo.indexOf(selData);
        if (n_sel < 0) {
            if ((combo.getStyle() & 8) == 0) {
                combo.setText(selData);
                return;
            }
            n_sel = 0;
        }
        combo.select(n_sel);
    }

    public static Shell createDialogShell() {
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return new Shell(parent, 2144);
    }

    public static MessageBox createDialog(String title, String message, int style) {
        MessageBox box = new MessageBox(ControlFactory.createDialogShell(), style | 0x10000);
        box.setText(title);
        box.setMessage(message);
        return box;
    }

    public static MessageBox createYesNoDialog(String title, String message) {
        return ControlFactory.createDialog(title, message, 196);
    }

    public static MessageBox createOkDialog(String title, String message) {
        return ControlFactory.createDialog(title, message, 34);
    }

    public static MessageBox createOkCancelDialog(String title, String message) {
        return ControlFactory.createDialog(title, message, 290);
    }

    public static Button createCheckButton(Composite parent, String key, SelectionListener listener) {
        Button button = new Button(parent, 32);
        if (key != null) {
            button.setText(JFaceResources.getString((String)key));
        }
        button.setFont(parent.getFont());
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    public static ListViewer createListViewer(Composite c, String[] lines) {
        ListViewer lv = new ListViewer(c, 2816);
        List l = lv.getList();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            l.add(s);
            ++n2;
        }
        GridData gd = new GridData(1808);
        l.setLayoutData((Object)gd);
        return lv;
    }

    public static ListViewer createListViewer(Composite c, String[] lines, Font font, int maxHeightHintInLines, int maxWidthInChars) {
        ListViewer lv = new ListViewer(c, 2816);
        List l = lv.getList();
        l.setFont(font);
        int maxWidthSeen = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() > maxWidthSeen) {
                maxWidthSeen = s.length();
            }
            l.add(s);
            ++n2;
        }
        GridData gd = new GridData(1808);
        gd.heightHint = l.getItemHeight() * (lines.length < maxHeightHintInLines ? lines.length : maxHeightHintInLines);
        GC gc = new GC((Drawable)l);
        int avgCharWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        gd.widthHint = avgCharWidth * (maxWidthSeen < maxWidthInChars ? maxWidthSeen : maxWidthInChars);
        l.setLayoutData((Object)gd);
        return lv;
    }

    public static void setChildrenVisible(Composite composite, boolean visible) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setVisible(visible);
            ++n2;
        }
    }

    public static void setEnabledRecursively(Control c, boolean enabled) {
        c.setEnabled(enabled);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                ControlFactory.setEnabledRecursively(child, enabled);
                ++n2;
            }
        }
    }

    public static void setExpandedRecursively(Object treeOrTreeItem, boolean expand) {
        TreeItem[] tia = treeOrTreeItem instanceof Tree ? ((Tree)treeOrTreeItem).getItems() : new TreeItem[]{(TreeItem)treeOrTreeItem};
        TreeItem[] treeItemArray = tia;
        int n = tia.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            ti.setExpanded(expand);
            TreeItem[] treeItemArray2 = ti.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem child = treeItemArray2[n4];
                ControlFactory.setExpandedRecursively(child, expand);
                ++n4;
            }
            ++n2;
        }
    }

    public static String trimmedValue(Text text) {
        String value = null;
        if (text != null && (value = text.getText().trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    public static Object nvl(Object arg0, Object arg1) {
        return arg0 != null ? arg0 : arg1;
    }

    public static Label createEmptyLabel(Composite parent) {
        Label lbl = new Label(parent, 0);
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        return lbl;
    }

    public static Composite createEmptyPanel(Composite parent) {
        return ControlFactory.createEmptyPanel(parent, "");
    }

    public static Composite createEmptyPanel(Composite parent, String fictiveStringToSetWidth) {
        Composite hlpComposite = new Composite(parent, 0);
        hlpComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        StackLayout hlpStackLayout = new StackLayout();
        hlpComposite.setLayout((Layout)hlpStackLayout);
        Label hlpEmptyLabel = ControlFactory.createEmptyLabel(hlpComposite);
        Text hlpFictiveText = ControlFactory.createGridText(hlpComposite, 1, 0, null, 0);
        hlpFictiveText.setText(fictiveStringToSetWidth);
        hlpStackLayout.topControl = hlpEmptyLabel;
        return hlpComposite;
    }

    public static Combo createGridCombo(Composite parent, int horizontalSpan, int widthHint, SelectionListener selectionListener, ModifyListener modifyListener, int style) {
        Combo combo = new Combo(parent, style);
        GridData data = new GridData(4, 0x1000000, true, false);
        if (horizontalSpan > 0) {
            data.horizontalSpan = horizontalSpan;
        }
        if (widthHint > 0) {
            data.widthHint = widthHint;
        }
        combo.setLayoutData((Object)data);
        if (selectionListener != null) {
            combo.addSelectionListener(selectionListener);
        }
        if (modifyListener != null) {
            combo.addModifyListener(modifyListener);
        }
        return combo;
    }

    public static Combo createGridEnumCombo(Composite parent, int horizontalSpan, int widthHint, Enum<?>[] values, SelectionListener selectionListener, ModifyListener modifyListener, int style) {
        Combo combo = ControlFactory.createGridCombo(parent, horizontalSpan, widthHint, selectionListener, modifyListener, style);
        Enum<?>[] enumArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> value = enumArray[n2];
            combo.add(value.toString());
            ++n2;
        }
        combo.select(0);
        return combo;
    }

    public static Label createGridLabel(Composite parent, String string, int horizontalSpan, int widthHint, int style) {
        Label lbl = new Label(parent, style);
        GridData data = new GridData(4, 0x1000000, false, false);
        if (widthHint > 0) {
            data.widthHint = widthHint;
        }
        if (horizontalSpan > 1) {
            data.horizontalSpan = horizontalSpan;
        }
        lbl.setLayoutData((Object)data);
        lbl.setText(string);
        return lbl;
    }

    public static Text createGridText(Composite parent, int horizontalSpan, int widthHint, ModifyListener listener, int style) {
        return ControlFactory.createNoBorderGridText(parent, horizontalSpan, widthHint, listener, 0x800 | style);
    }

    public static Text createNoBorderGridText(Composite parent, int horizontalSpan, int widthHint, ModifyListener listener, int style) {
        Text text = new Text(parent, style);
        GridData data = new GridData(4, 0x1000000, true, false);
        if (horizontalSpan > 0) {
            data.horizontalSpan = horizontalSpan;
        }
        if (widthHint > 0) {
            data.widthHint = widthHint;
        }
        text.setLayoutData((Object)data);
        if (listener != null) {
            text.addModifyListener(listener);
        }
        return text;
    }

    public static void setColor(Color systemColor, Label ... labels) {
        Label[] labelArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            Label lb = labelArray[n2];
            lb.setForeground(systemColor);
            ++n2;
        }
    }

    public static void setEditable(boolean b, Text ... fields) {
        Text[] textArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Text t = textArray[n2];
            t.setEditable(b);
            ++n2;
        }
    }
}

