/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import java.io.IOException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleUtils {
    private static final String CONSOLE_NAME = "build_console";

    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static void printMessage(String message) {
        MessageConsole myConsole = ConsoleUtils.findConsole(CONSOLE_NAME);
        MessageConsoleStream out = myConsole.newMessageStream();
        out.println(message);
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void showConsoleView() {
        MessageConsole myConsole = ConsoleUtils.findConsole(CONSOLE_NAME);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        String id = "org.eclipse.ui.console.ConsoleView";
        try {
            IConsoleView view = (IConsoleView)page.showView(id);
            view.display((IConsole)myConsole);
        }
        catch (PartInitException e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
    }

    public static void printMessage(String[] lines) {
        if (lines == null || lines.length == 0) {
            return;
        }
        MessageConsole myConsole = ConsoleUtils.findConsole(CONSOLE_NAME);
        MessageConsoleStream out = myConsole.newMessageStream();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            out.println(line);
            ++n2;
        }
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

