/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.rcp;

import com.soyatec.hisilicon.platform.rcp.ApplicationWorkbenchWindowAdvisor;
import com.soyatec.hisilicon.platform.rcp.internal.WorkbenchAdvisorHack;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.statushandlers.IStatusDialogConstants;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.statushandlers.WorkbenchStatusDialogManager;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisorHack {
    private AbstractStatusHandler hiToolErrorHandler;

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return "com.soyatec.hisilicon.platform.ui.Perspective";
    }

    public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
        if (this.hiToolErrorHandler == null) {
            this.hiToolErrorHandler = new HiToolErrorHandler();
        }
        return this.hiToolErrorHandler;
    }

    private static class HiToolErrorHandler
    extends AbstractStatusHandler {
        private static final QualifiedName HINT = new QualifiedName("org.eclipse.ui.workbench.statusHandlers.adapters", "hint");
        private WorkbenchStatusDialogManager statusDialogManager;

        private HiToolErrorHandler() {
        }

        public boolean supportsNotification(int type) {
            if (type == 1) {
                return true;
            }
            return super.supportsNotification(type);
        }

        public void handle(StatusAdapter statusAdapter, int style) {
            try {
                statusAdapter.setProperty(HINT, (Object)style);
                boolean processed = false;
                IStatus status = statusAdapter.getStatus();
                if (status != null && status.getException() instanceof InvalidRegistryObjectException) {
                    WorkbenchPlugin.getDefault().getLog().log(statusAdapter.getStatus());
                    processed = true;
                }
                if (!processed && (style & 1) == 1) {
                    StatusManager.getManager().addLoggedStatus(statusAdapter.getStatus());
                    WorkbenchPlugin.getDefault().getLog().log(statusAdapter.getStatus());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void showStatusAdapter(StatusAdapter statusAdapter, boolean block) {
            if (!PlatformUI.isWorkbenchRunning()) {
                WorkbenchPlugin.log((IStatus)statusAdapter.getStatus());
                return;
            }
            this.getStatusDialogManager().addStatusAdapter(statusAdapter, block);
            if (block) {
                Shell shell;
                while ((shell = this.getStatusDialogShell()) != null && !shell.isDisposed()) {
                    if (shell.getDisplay().readAndDispatch()) continue;
                    Display.getDefault().sleep();
                }
            }
        }

        private Shell getStatusDialogShell() {
            return (Shell)this.getStatusDialogManager().getProperty(IStatusDialogConstants.SHELL);
        }

        private WorkbenchStatusDialogManager getStatusDialogManager() {
            if (this.statusDialogManager == null) {
                this.statusDialogManager = new WorkbenchStatusDialogManager(null);
                this.statusDialogManager.setProperty(IStatusDialogConstants.SHOW_SUPPORT, (Object)Boolean.TRUE);
                this.statusDialogManager.setProperty(IStatusDialogConstants.HANDLE_OK_STATUSES, (Object)Boolean.TRUE);
                this.statusDialogManager.setProperty(IStatusDialogConstants.ERRORLOG_LINK, (Object)Boolean.TRUE);
                this.configureStatusDialog(this.statusDialogManager);
            }
            return this.statusDialogManager;
        }

        protected void configureStatusDialog(WorkbenchStatusDialogManager statusDialog) {
        }

        private static interface INotificationTypes {
            public static final int HANDLED = 1;
        }
    }
}

