/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.osgi.internal.security;

import com.soyatec.hisilicon.platform.osgi.internal.log.EclipseLogListener;
import java.util.Timer;
import java.util.TimerTask;

public class TaskRunner {
    private Timer timer = new Timer(true);
    private static final TaskRunner instance = new TaskRunner();

    TaskRunner() {
    }

    public static TaskRunner getInstance() {
        return instance;
    }

    public void launchOnce(final Runnable op, int delay) {
        try {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        op.run();
                    }
                    catch (Exception e) {
                        EclipseLogListener.logPlatformError(e.getMessage(), e);
                    }
                }
            }, delay);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void launchSpecificTimes(Runnable op, int delay, int times) {
        int i = 0;
        while (i < times) {
            this.launchOnce(op, delay);
            ++i;
        }
    }

    public void launchRepeat(final Runnable op, int delay, int period) {
        try {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        op.run();
                    }
                    catch (Exception e) {
                        EclipseLogListener.logPlatformError(e.getMessage(), e);
                    }
                }
            }, delay, (long)period);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

