/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.osgi.internal;

import com.soyatec.hisilicon.platform.osgi.internal.log.EclipseLogListener;
import com.soyatec.hisilicon.platform.osgi.internal.security.StringConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class P2InfUtils {
    private static String PROPERTIES_PREFIX = StringConstants.decode("135940097263483138087416622");
    private static String VALUE = StringConstants.decode("508440638821");
    private static String DOT_VALUE = StringConstants.decode("13078009732228413");
    private static String NAME = StringConstants.decode("1851878757");
    private static String DOT_NAME = StringConstants.decode("51051615839549");

    public static void saveP2Inf(Map<String, String> map, Writer w) throws IOException {
        int index = 0;
        TreeSet<String> keys = new TreeSet<String>(map.keySet());
        try {
            for (String k : keys) {
                String value = map.get(k);
                String line = String.valueOf(PROPERTIES_PREFIX) + index + DOT_NAME + k + "\n";
                w.write(line);
                line = String.valueOf(PROPERTIES_PREFIX) + index + DOT_VALUE + value + "\n";
                w.write(line);
                ++index;
            }
            w.flush();
        }
        finally {
            try {
                w.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Map<String, String> loadP2Inf(InputStream in) {
        Properties p;
        HashMap<String, String> iuProperties;
        block18: {
            iuProperties = new HashMap<String, String>();
            p = new Properties();
            try {
                try {
                    p.load(in);
                }
                catch (Exception e) {
                    EclipseLogListener.logPlatformError(e.getMessage(), e);
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ArrayList<String> keys = new ArrayList<String>(p.stringPropertyNames());
        Collections.sort(keys);
        Iterator it = keys.iterator();
        String key = "";
        while (it.hasNext()) {
            if (key != null && !key.startsWith(PROPERTIES_PREFIX)) {
                key = (String)it.next();
                continue;
            }
            if (key == null) continue;
            int dotIndex = key.indexOf(46, PROPERTIES_PREFIX.length());
            if (dotIndex == -1) {
                throw new IllegalStateException("bad token: " + key);
            }
            String prefix = key.substring(0, dotIndex + 1);
            String propertyName = null;
            String propertyValue = null;
            while (key != null && key.startsWith(prefix)) {
                String token = key.substring(prefix.length());
                if (token.equals(NAME)) {
                    propertyName = p.getProperty(key);
                } else if (token.equals(VALUE)) {
                    propertyValue = p.getProperty(key);
                }
                if (!it.hasNext()) break;
                key = (String)it.next();
            }
            if (propertyName == null || propertyValue == null) continue;
            iuProperties.put(propertyName, propertyValue);
        }
        return iuProperties;
    }

    public static Map<String, String> loadP2Inf(File f) throws FileNotFoundException {
        if (!f.exists()) {
            return new HashMap<String, String>();
        }
        return P2InfUtils.loadP2Inf(new FileInputStream(f));
    }
}

