/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.core.internal;

import com.soyatec.hisilicon.platform.core.IToolManager;
import com.soyatec.hisilicon.platform.core.Messages;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.core.internal.HisiErrorLog;
import com.soyatec.hisilicon.platform.core.internal.P2Utils;
import com.soyatec.hisilicon.platform.core.internal.StringConstants;
import com.soyatec.hisilicon.platform.core.internal.ToolFilter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

public class ToolManager
implements IToolManager {
    private static String COPYRIGHT = StringConstants.decode("1834257714965148821620");
    private static String TRUE = StringConstants.decode("1953658213");
    private static String ID_FEATURE_GROUP = StringConstants.decode("10094463917596447559979757208760261063223131799725371439");
    private static String BUCKMINSTER = StringConstants.decode("80343454941683828890297714");
    public static final String Platform_Updatble_Feature = "com.soyatec.hisilicon.platform.update.feature";
    public static final String Platform_Updatble_Feature_Group = "com.soyatec.hisilicon.platform.update.feature.feature.group";
    private static String ID = StringConstants.decode("26980");
    private static String ZIP = StringConstants.decode("779774320");
    private static String UPD = StringConstants.decode("779448420");
    private static String TOOL_PLUGINS = StringConstants.decode("36034978083527504076355497587");
    public static final String FEATURE_GROUP = StringConstants.decode("941103490146189284522303861781872");
    private static String ECLIPSE_P2_PROFILE = StringConstants.decode("8832172937528445164687600416771833374272613");
    private static String LICENSE = StringConstants.decode("30515173109166949");
    private static String PLATFORM_PROPERTY = StringConstants.decode("341953090008327039971949");
    private static String JAR = StringConstants.decode("778723698");
    private static String TOOL_PROPERTY = StringConstants.decode("79617225355116");
    private static String VERSION = StringConstants.decode("33325589488824174");
    public static final int EXIT_FORCED = 2;
    public static final int EXIT_FAIL = 1;
    public static final int EXIT_OK = 0;
    private final List<IInstallableUnit> installedToolIUs = new ArrayList<IInstallableUnit>();
    private final List<IInstallableUnit> installedPlatformIUs = new ArrayList<IInstallableUnit>();
    private final List<ToolDescriptor> installedTools = new ArrayList<ToolDescriptor>();
    private final List<ToolDescriptor> installedPlatforms = new ArrayList<ToolDescriptor>();
    protected static final String FILE_SCHEME = "file";

    public void clearInstalledInformation() {
        this.installedToolIUs.clear();
        this.installedPlatformIUs.clear();
        this.installedTools.clear();
        this.installedPlatforms.clear();
    }

    private void initInstalledInformation() {
        this.clearInstalledInformation();
        try {
            IProfile profile = P2Utils.getProfile();
            if (profile == null) {
                return;
            }
            IQueryResult result = profile.available(QueryUtil.createIUAnyQuery(), null);
            for (IInstallableUnit unit : result) {
                try {
                    ToolDescriptor r;
                    if (this.isToolUnit(unit)) {
                        this.installedToolIUs.add(unit);
                        if (!unit.getId().endsWith(FEATURE_GROUP)) continue;
                        r = new ToolDescriptor(unit);
                        this.installedTools.add(r);
                        continue;
                    }
                    if (!this.isPlatformUnit(unit)) continue;
                    this.installedPlatformIUs.add(unit);
                    if (!unit.getId().endsWith(FEATURE_GROUP)) continue;
                    r = new ToolDescriptor(unit);
                    this.installedPlatforms.add(r);
                }
                catch (Exception e) {
                    HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            HisiErrorLog.getInstance((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getToolInfo(IInstallableUnit iu) {
        Map props;
        HashMap<String, String> map = new HashMap<String, String>();
        String id = iu.getId();
        if (id.endsWith(FEATURE_GROUP)) {
            id = id.substring(0, id.length() - 14);
        }
        map.put(ID, id);
        if (iu.getVersion() != null) {
            map.put(VERSION, iu.getVersion().toString());
        }
        if (iu.getCopyright() != null) {
            map.put(COPYRIGHT, iu.getCopyright().getBody());
        }
        if (iu.getLicenses() != null && iu.getLicenses().size() > 0) {
            Iterator itor = iu.getLicenses().iterator();
            map.put(LICENSE, ((ILicense)itor.next()).getBody());
        }
        if ((props = iu.getProperties()) != null) {
            Set keys = props.entrySet();
            for (Map.Entry key : keys) {
                map.put((String)key.getKey(), (String)key.getValue());
            }
        }
        return map;
    }

    @Override
    public ToolDescriptor findPlatformTool() throws Exception {
        if (this.installedPlatforms.size() == 0) {
            this.initInstalledInformation();
        }
        if (this.installedPlatforms.size() == 0) {
            return null;
        }
        return this.installedPlatforms.get(0);
    }

    @Override
    public IInstallableUnit findInstallIU(String id, String ver) throws Exception {
        IQueryResult roots;
        IProfile profile = P2Utils.getProfile();
        Version version = Version.create((String)ver);
        IQuery query = QueryUtil.createIUQuery((String)id, (Version)version);
        if (version == null) {
            query = QueryUtil.createLatestQuery((IQuery)query);
        }
        if (!(roots = profile.query(query, null)).isEmpty()) {
            return (IInstallableUnit)roots.iterator().next();
        }
        return null;
    }

    @Override
    public int installIU(String url, IInstallableUnit iu, IProgressMonitor monitor) throws Exception {
        P2Utils.updateProfile();
        URI site = this.getSite(url);
        PlatformCoreActivator bucky = PlatformCoreActivator.getDefault();
        IProvisioningAgentProvider agentProvider = bucky.getService(IProvisioningAgentProvider.class);
        IProvisioningAgent agent = agentProvider.createAgent(null);
        String profileId = bucky.getBundle().getBundleContext().getProperty(ECLIPSE_P2_PROFILE);
        if (profileId == null) {
            profileId = BUCKMINSTER;
            System.setProperty(ECLIPSE_P2_PROFILE, profileId);
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        try {
            IProfile profile = profileRegistry.getProfile(profileId);
            ProfileChangeRequest request = new ProfileChangeRequest(profile);
            request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
            request.setProfileProperty("org.eclipse.equinox.p2.installFolder", P2Utils.getIntallDestination());
            request.setProfileProperty("org.eclipse.equinox.p2.cache", P2Utils.getIntallDestination());
            request.add(iu);
            int n = ToolManager.planAndExecute(agent, profile, request, ToolManager.createContext(agent, site), monitor);
            return n;
        }
        finally {
            agent.stop();
            bucky.ungetService(agentProvider);
            this.clearInstalledInformation();
        }
    }

    @Override
    public IProvisioningAgent getAgent() {
        P2Utils.updateProfile();
        PlatformCoreActivator bucky = PlatformCoreActivator.getDefault();
        IProvisioningAgent agent = null;
        try {
            IProvisioningAgentProvider agentProvider = bucky.getService(IProvisioningAgentProvider.class);
            agent = agentProvider.createAgent(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return agent;
    }

    @Override
    public URI getSite(String url) {
        String p2Repos = url;
        URI site = ToolManager.normalizeToURI(p2Repos);
        return site;
    }

    @Override
    public int uninstallIU(IInstallableUnit iu, IProgressMonitor monitor) throws Exception {
        PlatformCoreActivator bucky = PlatformCoreActivator.getDefault();
        IProvisioningAgentProvider agentProvider = bucky.getService(IProvisioningAgentProvider.class);
        IProvisioningAgent agent = agentProvider.createAgent(null);
        String profileId = bucky.getBundle().getBundleContext().getProperty(ECLIPSE_P2_PROFILE);
        if (profileId == null) {
            profileId = BUCKMINSTER;
            System.setProperty(ECLIPSE_P2_PROFILE, profileId);
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        try {
            IProfile profile = profileRegistry.getProfile(profileId);
            ProfileChangeRequest request = new ProfileChangeRequest(profile);
            request.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
            request.remove(iu);
            int n = ToolManager.planAndExecute(agent, profile, request, null, monitor);
            return n;
        }
        finally {
            agent.stop();
            bucky.ungetService(agentProvider);
            this.clearInstalledInformation();
        }
    }

    @Override
    public List<IInstallableUnit> getInstalledToolIUs() {
        if (this.installedToolIUs.size() == 0) {
            this.initInstalledInformation();
        }
        return this.installedToolIUs;
    }

    @Override
    public List<IInstallableUnit> getInstalledToolAndPlatformIUs() {
        if (this.installedToolIUs.size() == 0 || this.installedPlatformIUs.size() == 0) {
            this.initInstalledInformation();
        }
        ArrayList<IInstallableUnit> list = new ArrayList<IInstallableUnit>();
        list.addAll(this.installedToolIUs);
        list.addAll(this.installedPlatformIUs);
        return list;
    }

    static int planAndExecute(IProvisioningAgent agent, IProfile profile, ProfileChangeRequest request, ProvisioningContext context, IProgressMonitor monitor) throws CoreException {
        IPlanner planner = (IPlanner)agent.getService(IPlanner.SERVICE_NAME);
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, context, monitor);
        IStatus status = plan.getStatus();
        if (status.getSeverity() == 8) {
            return 2;
        }
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        IPhaseSet set = PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{PhaseSetFactory.PHASE_COLLECT, PhaseSetFactory.PHASE_UNCONFIGURE, PhaseSetFactory.PHASE_UNINSTALL, PhaseSetFactory.PHASE_PROPERTY, PhaseSetFactory.PHASE_INSTALL, PhaseSetFactory.PHASE_CONFIGURE});
        IEngine engine = (IEngine)agent.getService(IEngine.SERVICE_NAME);
        status = engine.perform(plan, set, monitor);
        if (status.getSeverity() == 8) {
            return 2;
        }
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        return 0;
    }

    static ProvisioningContext createContext(IProvisioningAgent agent, URI site) throws URISyntaxException {
        if (P2Utils.getIntallDestination() == null) {
            return null;
        }
        URI dest = new File(P2Utils.getIntallDestination()).toURI();
        URI[] repoLocations = new URI[]{site, dest};
        ProvisioningContext context = new ProvisioningContext(agent);
        context.setArtifactRepositories(repoLocations);
        return context;
    }

    static IQueryResult<IInstallableUnit> getRootIUs(IProvisioningAgent agent, URI site, IProfile profile, String iuName, Version version, IProgressMonitor monitor) throws Exception {
        IMetadataRepositoryManager queryable;
        if (!iuName.endsWith(FEATURE_GROUP)) {
            iuName = String.valueOf(iuName) + FEATURE_GROUP;
        }
        IQuery query = QueryUtil.createIUQuery((String)iuName, (Version)version);
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (site == null) {
            queryable = repoManager;
            subMon.worked(80);
        } else {
            queryable = repoManager.loadRepository(site, (IProgressMonitor)subMon.newChild(80));
        }
        IQueryResult roots = queryable.query(QueryUtil.createLatestQuery((IQuery)query), (IProgressMonitor)subMon.newChild(10));
        if (roots.isEmpty()) {
            roots = profile.query(query, (IProgressMonitor)subMon.newChild(10));
        }
        if (roots.isEmpty()) {
            throw new Exception(Messages.ToolManager_1);
        }
        return roots;
    }

    static URI normalizeToURI(String surl) {
        URL url;
        try {
            surl = surl.replace(" ", "%20");
            surl = ToolManager.makeLocalURIString(surl);
            url = new URL(surl);
        }
        catch (MalformedURLException e) {
            try {
                url = new File(surl).toURI().toURL();
            }
            catch (MalformedURLException e2) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.ToolManager_0, (Object)surl));
            }
        }
        return URI.create(url.toString());
    }

    @Override
    public IInstallableUnit findToolUnit(String url, IProgressMonitor monitor) throws Exception {
        IInstallableUnit[] units = this.listRootIUs(url, monitor);
        if (units == null || units.length == 0) {
            return null;
        }
        IInstallableUnit[] iInstallableUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            if (this.isToolUnit(iu)) {
                return iu;
            }
            ++n2;
        }
        return units[0];
    }

    IInstallableUnit[] listRootIUs(String url, IProgressMonitor monitor) throws Exception {
        URI site = this.getSite(url);
        PlatformCoreActivator bucky = PlatformCoreActivator.getDefault();
        IProvisioningAgentProvider agentProvider = bucky.getService(IProvisioningAgentProvider.class);
        IProvisioningAgent agent = agentProvider.createAgent(null);
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IQueryResult roots = repoManager.loadRepository(site, (IProgressMonitor)subMon.newChild(8)).query(QueryUtil.createLatestQuery((IQuery)new FeatureQuery()), (IProgressMonitor)subMon.newChild(2));
            IInstallableUnit[] iInstallableUnitArray = (IInstallableUnit[])roots.toArray(IInstallableUnit.class);
            return iInstallableUnitArray;
        }
        finally {
            agent.stop();
            bucky.ungetService(agentProvider);
            subMon.done();
        }
    }

    static String makeLocalURIString(String path) {
        try {
            URI localURI = URIUtil.fromString((String)path);
            return URIUtil.toUnencodedString((URI)ToolManager.localRepoURIHelper(localURI));
        }
        catch (URISyntaxException e) {
            return path;
        }
    }

    static URI localRepoURIHelper(URI location) {
        if (location == null) {
            return null;
        }
        if (location.getScheme() == null) {
            location = new File(location.getPath()).getAbsoluteFile().toURI();
        } else if (location.getScheme().length() == 1) {
            location = new File(URIUtil.toUnencodedString((URI)location)).toURI();
        } else if (!FILE_SCHEME.equalsIgnoreCase(location.getScheme())) {
            return location;
        }
        String lowerCase = location.toString().toLowerCase();
        if (lowerCase.endsWith(JAR) || lowerCase.endsWith(ZIP) || lowerCase.endsWith(UPD)) {
            return URIUtil.toJarURI((URI)location, null);
        }
        return location;
    }

    @Override
    public boolean isToolUnit(IInstallableUnit unit) {
        String p = unit.getProperty(TOOL_PROPERTY);
        return TRUE.equalsIgnoreCase(p) && !ToolFilter.isHiToolFilterIU(unit.getId());
    }

    @Override
    public boolean isPlatformUnit(IInstallableUnit unit) {
        String p = unit.getProperty(PLATFORM_PROPERTY);
        return TRUE.equalsIgnoreCase(p);
    }

    @Override
    public Set<String> getToolPlugins(IInstallableUnit iu) {
        HashSet<String> list = new HashSet<String>();
        String plugins = iu.getProperty(TOOL_PLUGINS);
        if (plugins != null) {
            String[] arr;
            String[] stringArray = arr = plugins.split(";");
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                list.add(p);
                ++n2;
            }
        }
        return list;
    }

    @Override
    public String[] getToolNames(List<ToolDescriptor> tools) {
        ArrayList<String> names = new ArrayList<String>();
        for (ToolDescriptor t : tools) {
            names.add(t.getName());
        }
        String[] input = names.toArray(new String[names.size()]);
        return input;
    }

    @Override
    public List<ToolDescriptor> collectFeatureTools(List<IInstallableUnit> installIUs) {
        if (this.installedTools.size() == 0) {
            this.initInstalledInformation();
        }
        return this.installedTools;
    }

    @Override
    public List<ToolDescriptor> collectFeatureToolsAndPlatform(List<IInstallableUnit> installIUs) {
        if (this.installedTools.size() == 0 || this.installedPlatforms.size() == 0) {
            this.initInstalledInformation();
        }
        ArrayList<ToolDescriptor> list = new ArrayList<ToolDescriptor>();
        list.addAll(this.installedTools);
        list.addAll(this.installedPlatforms);
        return list;
    }

    @Override
    public IInstallableUnit findPlatformUpdatableUnit(String url, IProgressMonitor monitor) throws Exception {
        IInstallableUnit[] units = this.listRootIUs(url, monitor);
        if (units == null || units.length == 0) {
            return null;
        }
        IInstallableUnit[] iInstallableUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            String id = iu.getId();
            if (id.endsWith(FEATURE_GROUP)) {
                id = id.substring(0, id.length() - 14);
            }
            if (id.equals(Platform_Updatble_Feature)) {
                return iu;
            }
            ++n2;
        }
        return units[0];
    }

    static class FeatureQuery
    extends ExpressionMatchQuery<IInstallableUnit> {
        public FeatureQuery() {
            super(IInstallableUnit.class, ID_FEATURE_GROUP, new Object[0]);
        }
    }
}

