/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.core.internal;

import com.soyatec.hisilicon.platform.api.IHisiLog;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class HisiErrorLog
implements IHisiLog {
    private static Map<Plugin, HisiErrorLog> map = new HashMap<Plugin, HisiErrorLog>();
    private ILog logger = null;
    private String pluginID = null;

    private HisiErrorLog(Plugin plugin) {
        try {
            this.logger = plugin.getLog();
            this.pluginID = plugin.getBundle().getSymbolicName();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static IHisiLog getInstance(Plugin plugin) {
        IHisiLog hisiErrorLog = map.get(plugin);
        if (hisiErrorLog == null) {
            hisiErrorLog = new HisiErrorLog(plugin);
        }
        return hisiErrorLog;
    }

    public void logCancel(String message) {
        if (this.logger != null && this.pluginID != null) {
            this.logger.log((IStatus)new Status(8, this.pluginID, message));
        }
    }

    public void logError(String message, Throwable exception) {
        if (this.logger != null && this.pluginID != null) {
            this.logger.log((IStatus)new Status(4, this.pluginID, 0, message, exception));
        }
    }

    public void logInfo(String message) {
        if (this.logger != null && this.pluginID != null) {
            this.logger.log((IStatus)new Status(1, this.pluginID, message));
        }
    }

    public void logOk(String message) {
        if (this.logger != null && this.pluginID != null) {
            this.logger.log((IStatus)new Status(0, this.pluginID, message));
        }
    }

    public void logWarning(String message) {
        if (this.logger != null && this.pluginID != null) {
            this.logger.log((IStatus)new Status(2, this.pluginID, message));
        }
    }
}

