/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.telnet;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.telnet.NetworkPortMap;
import org.eclipse.tm.internal.terminal.telnet.TelnetMessages;
import org.eclipse.tm.internal.terminal.telnet.TelnetSettings;

public class TelnetSettingsPage
implements ISettingsPage {
    private Text fHostText;
    private Combo fNetworkPortCombo;
    private Text fTimeout;
    private final TelnetSettings fTerminalSettings;

    public TelnetSettingsPage(TelnetSettings settings) {
        this.fTerminalSettings = settings;
    }

    public void saveSettings() {
        this.fTerminalSettings.setHost(this.fHostText.getText());
        this.fTerminalSettings.setTimeout(this.fTimeout.getText());
        this.fTerminalSettings.setNetworkPort(this.getNetworkPort());
    }

    public void loadSettings() {
        if (this.fTerminalSettings != null) {
            this.setHost(this.fTerminalSettings.getHost());
            this.setTimeout(this.fTerminalSettings.getTimeoutString());
            this.setNetworkPort(this.fTerminalSettings.getNetworkPortString());
        }
    }

    private void setHost(String strHost) {
        if (strHost == null) {
            strHost = "";
        }
        this.fHostText.setText(strHost);
    }

    private void setTimeout(String timeout) {
        if (timeout == null || timeout.length() == 0) {
            timeout = "5";
        }
        this.fTimeout.setText(timeout);
    }

    private void setNetworkPort(String strNetworkPort) {
        if (strNetworkPort != null) {
            int nIndex;
            String strPortName = this.getNetworkPortMap().findPortName(strNetworkPort);
            if (strPortName == null) {
                strPortName = strNetworkPort;
            }
            if ((nIndex = this.fNetworkPortCombo.indexOf(strPortName)) == -1) {
                this.fNetworkPortCombo.setText(strNetworkPort);
            } else {
                this.fNetworkPortCombo.select(nIndex);
            }
        }
    }

    private String getNetworkPort() {
        String portText = this.fNetworkPortCombo.getText();
        String mappedPort = this.getNetworkPortMap().findPort(portText);
        return mappedPort != null ? mappedPort : portText;
    }

    private NetworkPortMap getNetworkPortMap() {
        return this.fTerminalSettings.getProperties().getNetworkPortMap();
    }

    public boolean validateSettings() {
        int p;
        block4: {
            if (this.fHostText.getText().trim().length() == 0) {
                return false;
            }
            try {
                p = Integer.parseInt(this.getNetworkPort().trim());
                if (p > 0 && p <= 65535) break block4;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        p = Integer.parseInt(this.fTimeout.getText().trim());
        return p >= 0;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(768);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        Label ctlLabel = new Label(composite, 131072);
        ctlLabel.setText(String.valueOf(TelnetMessages.HOST) + ":");
        gridData = new GridData(768);
        this.fHostText = new Text(composite, 2048);
        this.fHostText.setLayoutData((Object)gridData);
        ctlLabel = new Label(composite, 131072);
        ctlLabel.setText(String.valueOf(TelnetMessages.PORT) + ":");
        gridData = new GridData(768);
        this.fNetworkPortCombo = new Combo(composite, 4);
        this.fNetworkPortCombo.setLayoutData((Object)gridData);
        List table = this.getNetworkPortMap().getNameTable();
        Collections.sort(table);
        this.loadCombo(this.fNetworkPortCombo, table);
        new Label(composite, 131072).setText(String.valueOf(TelnetMessages.TIMEOUT) + ":");
        this.fTimeout = new Text(composite, 2048);
        this.fTimeout.setLayoutData((Object)new GridData(768));
        this.loadSettings();
    }

    private void loadCombo(Combo ctlCombo, List table) {
        Iterator iter = table.iterator();
        while (iter.hasNext()) {
            String label = (String)iter.next();
            ctlCombo.add(label);
        }
    }

    public void addListener(ISettingsPage.Listener listener) {
    }

    public void removeListener(ISettingsPage.Listener listener) {
    }
}

