/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.telnet;

import com.hisilicon.terminal.control.HisiVT100TerminalControl;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.telnet.TelnetConnection;
import org.eclipse.tm.internal.terminal.telnet.TelnetConnector;

class TelnetConnectWorker
extends Thread {
    private final ITerminalControl fControl;
    private final TelnetConnector fConn;

    protected TelnetConnectWorker(TelnetConnector conn, ITerminalControl control) {
        this.fControl = control;
        this.fConn = conn;
        this.fControl.setState(TerminalState.CONNECTING);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int remaining = 10;
        while (remaining >= 0) {
            Object var8_13;
            if (remaining < 10) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                try {
                    int nTimeout = this.fConn.getTelnetSettings().getTimeout() * 1000;
                    String strHost = this.fConn.getTelnetSettings().getHost();
                    int nPort = this.fConn.getTelnetSettings().getNetworkPort();
                    InetSocketAddress address = new InetSocketAddress(strHost, nPort);
                    Socket socket = new Socket();
                    socket.connect(address, nTimeout);
                    remaining = 0;
                    socket.setOOBInline(true);
                    this.fConn.setSocket(socket);
                    TelnetConnection connection = new TelnetConnection(this.fConn, socket);
                    socket.setKeepAlive(true);
                    this.fConn.setTelnetConnection(connection);
                    connection.start();
                    this.fControl.setState(TerminalState.CONNECTED);
                }
                catch (UnknownHostException ex) {
                    remaining = 0;
                    String txt = "Unknown host: " + ex.getMessage();
                    this.connectFailed(txt, "Unknown host: " + ex.getMessage() + "\n");
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    remaining = 0;
                    this.connectFailed(socketTimeoutException.getMessage(), "Connection Error!\n" + socketTimeoutException.getMessage());
                }
                catch (ConnectException connectException) {
                    if (remaining == 0) {
                        this.connectFailed(connectException.getMessage(), "Connection refused!");
                    }
                }
                catch (Exception exception) {
                    remaining = 0;
                    Logger.logException((Exception)exception);
                    this.connectFailed(exception.getMessage(), "");
                }
            }
            catch (Throwable throwable) {
                var8_13 = null;
                --remaining;
                throw throwable;
            }
            {
                var8_13 = null;
                --remaining;
                continue;
            }
            break;
        }
        return;
    }

    private void connectFailed(String terminalText, String msg) {
        Logger.log((String)terminalText);
        if (this.fControl instanceof HisiVT100TerminalControl) {
            HisiVT100TerminalControl control = (HisiVT100TerminalControl)this.fControl;
            ITerminalConnector currentConnector = control.getfConnector();
            if (control.getTerminalConnector().getId().equals("org.eclipse.tm.internal.terminal.telnet.TelnetConnector")) {
                this.fControl.displayTextInTerminal(terminalText);
                this.fConn.cleanSocket();
                this.fControl.setState(TerminalState.CLOSED);
                this.fControl.setMsg(msg);
            } else {
                this.fConn.cleanSocket();
            }
        }
    }
}

