/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.serial;

import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.serial.ISerialSettings;
import org.eclipse.tm.internal.terminal.serial.SerialProperties;

public class SerialSettings
implements ISerialSettings {
    protected String fSerialPort;
    protected String fBaudRate;
    protected String fDataBits;
    protected String fStopBits;
    protected String fParity;
    protected String fFlowControl;
    protected String fTimeout;
    private final SerialProperties fProperties = new SerialProperties();

    @Override
    public String getSerialPort() {
        return this.fSerialPort;
    }

    public void setSerialPort(String strSerialPort) {
        this.fSerialPort = strSerialPort;
    }

    public String getBaudRateString() {
        return this.fBaudRate;
    }

    @Override
    public int getBaudRate() {
        int nBaudRate;
        try {
            nBaudRate = Integer.parseInt(this.fBaudRate);
        }
        catch (NumberFormatException numberFormatException) {
            nBaudRate = SerialProperties.DefaultBaudRate;
        }
        return nBaudRate;
    }

    public void setBaudRate(String strBaudRate) {
        this.fBaudRate = strBaudRate;
    }

    public String getDataBitsString() {
        return this.fDataBits;
    }

    @Override
    public int getDataBits() {
        if (this.fDataBits.equals("5")) {
            return 5;
        }
        if (this.fDataBits.equals("6")) {
            return 6;
        }
        if (this.fDataBits.equals("7")) {
            return 7;
        }
        return 8;
    }

    public void setDataBits(String strDataBits) {
        this.fDataBits = strDataBits;
    }

    public String getStopBitsString() {
        return this.fStopBits;
    }

    @Override
    public int getStopBits() {
        if (this.fStopBits.equals("1_5")) {
            return 3;
        }
        if (this.fStopBits.equals("2")) {
            return 2;
        }
        return 1;
    }

    public void setStopBits(String strStopBits) {
        this.fStopBits = strStopBits;
    }

    public String getParityString() {
        return this.fParity;
    }

    @Override
    public int getParity() {
        if (this.fParity.equals("Even")) {
            return 2;
        }
        if (this.fParity.equals("Odd")) {
            return 1;
        }
        if (this.fParity.equals("Mark")) {
            return 3;
        }
        if (this.fParity.equals("Space")) {
            return 4;
        }
        return 0;
    }

    public void setParity(String strParity) {
        this.fParity = strParity;
    }

    public String getFlowControlString() {
        return this.fFlowControl;
    }

    @Override
    public int getFlowControl() {
        if (this.fFlowControl.equals("RTS/CTS")) {
            return 1;
        }
        if (this.fFlowControl.equals("Xon/Xoff")) {
            return 4;
        }
        return 0;
    }

    public void setFlowControl(String strFlow) {
        this.fFlowControl = strFlow;
    }

    @Override
    public String getSummary() {
        return String.valueOf(this.getSerialPort()) + ", " + this.getBaudRateString() + ", " + this.getDataBitsString() + ", " + this.getStopBitsString() + ", " + this.getParityString() + ", " + this.getFlowControlString();
    }

    @Override
    public void load(ISettingsStore store) {
        this.fSerialPort = store.get("SerialPort", this.fProperties.getDefaultSerialPort());
        this.fBaudRate = store.get("BaudRate", this.fProperties.getDefaultBaudRate());
        this.fDataBits = store.get("DataBits", this.fProperties.getDefaultDataBits());
        this.fStopBits = store.get("StopBits", this.fProperties.getDefaultStopBits());
        this.fParity = store.get("Parity", this.fProperties.getDefaultParity());
        this.fFlowControl = store.get("FlowControl", this.fProperties.getDefaultFlowControl());
        this.fTimeout = store.get("Timeout", this.fProperties.getDefaultTimeout());
    }

    @Override
    public void save(ISettingsStore store) {
        store.put("SerialPort", this.fSerialPort);
        store.put("BaudRate", this.fBaudRate);
        store.put("DataBits", this.fDataBits);
        store.put("StopBits", this.fStopBits);
        store.put("Parity", this.fParity);
        store.put("FlowControl", this.fFlowControl);
    }

    public SerialProperties getProperties() {
        return this.fProperties;
    }

    @Override
    public int getTimeout() {
        try {
            return Integer.parseInt(this.fTimeout);
        }
        catch (NumberFormatException numberFormatException) {
            return 10;
        }
    }

    public String getTimeoutString() {
        return this.fTimeout;
    }

    public void setTimeout(String timeout) {
        this.fTimeout = timeout;
    }
}

