/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.views;

import com.hisilicon.hiregbin.Activator;
import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.exception.InvalidExcelException;
import com.hisilicon.hiregbin.model.GlobleInfo;
import com.hisilicon.hiregbin.model.devices.IDeviceListener;
import com.hisilicon.hiregbin.model.devices.IDeviceSetting;
import com.hisilicon.hiregbin.model.reg.ParsedMainData;
import com.hisilicon.hiregbin.model.reg.excel.ExcelData;
import com.hisilicon.hiregbin.perspectives.HiRegbinPerspective;
import com.hisilicon.hiregbin.preferences.PanelPreferences;
import com.hisilicon.hiregbin.processor.PrepareSetting;
import com.hisilicon.hiregbin.ui.PanelComposite;
import com.hisilicon.hiregbin.ui.TempExcelSelectDialog;
import com.hisilicon.hiregbin.utility.ExcelDataHelper;
import com.hisilicon.hiregbin.utility.FileUtils;
import com.soyatec.hisilicon.platform.api.IDeviceChangedListener;
import com.soyatec.hisilicon.platform.api.IDeviceManager;
import com.soyatec.hisilicon.platform.api.chips.Chip;
import com.soyatec.hisilicon.platform.api.chips.Tool;
import com.soyatec.hisilicon.platform.ui.internal.PerspectiveUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.dom4j.DocumentException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.xml.sax.SAXException;

public class RegbinView
extends ViewPart
implements IDeviceListener,
IDeviceChangedListener,
IPerspectiveListener4,
ControlListener {
    public static final String ID = RegbinView.class.getName();
    private static String currentChip;
    private static boolean notLoadImportExcelDataSuccess;
    private PanelComposite panelComposite;
    private IDeviceManager deviceManager;
    private IDeviceSetting deviceSetting = null;
    private Composite parent;
    private boolean loadFlag = false;
    private boolean isClose = false;
    private static final String Hi3716MV330_SERIES_CHIP_NAME = "Hi3716MV330";
    private static boolean isHi3716MV330Series;
    private static boolean isHi3716MV310Series;
    private static boolean isHi3716MV410Series;
    private static boolean isHi3716MV430Series;
    private static boolean isHi3798CV200Series;
    private static boolean isHi3798MV200Series;
    private static boolean isHi3796MV200Series;
    private static boolean isHi3716V550Series;
    private static boolean isHi3798MV310Series;
    private static boolean isHi3796CV300Series;

    static {
        isHi3716MV330Series = false;
        isHi3716MV310Series = false;
        isHi3716MV410Series = false;
        isHi3716MV430Series = false;
        isHi3798CV200Series = false;
        isHi3798MV200Series = false;
        isHi3796MV200Series = false;
        isHi3716V550Series = false;
        isHi3798MV310Series = false;
        isHi3796CV300Series = false;
    }

    public void createPartControl(Composite parent) {
        parent.setBackground(GlobleInfo.white);
        this.parent = parent;
        try {
            if (!this.loadFlag) {
                while (!this.selectTempFile(false)) {
                }
                if (this.isClose) {
                    return;
                }
                this.createPanelControl(parent);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private Control createPanelControl(Composite parent) {
        this.panelComposite = new PanelComposite(parent, new PrepareSetting(null));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.panelComposite, "com.hisilicon.hiregbin.hiregbin_context_hiregbinParam");
        return this.panelComposite;
    }

    public void setFocus() {
        TabFolder tabFolder;
        if (this.panelComposite != null && (tabFolder = this.panelComposite.getTabFolder()) != null && tabFolder.getSelectionIndex() == 0) {
            this.panelComposite.getTabFolder().setSelection(this.panelComposite.getPinDemuxItem());
            this.panelComposite.getTabFolder().setSelection(this.panelComposite.getBaseSettingItem());
            this.panelComposite.update();
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        long currentTimeMillis = System.currentTimeMillis();
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference sreference = bundleContext.getServiceReference(IDeviceManager.class);
        if (sreference == null) {
            this.loadChipProperties("Hi3716MV310");
            return;
        }
        this.deviceManager = (IDeviceManager)bundleContext.getService(sreference);
        this.deviceManager.addDeviceChangedListener((IDeviceChangedListener)this);
        String currentDevice = this.deviceManager.getCurrentDevice();
        if (currentDevice == null || currentDevice.trim().length() == 0) {
            return;
        }
        this.loadChipProperties(currentDevice);
        try {
            this.deviceChanged(this.deviceManager.findChipByName(currentDevice));
            if (Platform.inDebugMode()) {
                System.out.println("------init() Time=\t" + (System.currentTimeMillis() - currentTimeMillis) + "ms");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadChipProperties(String chipName) {
        String propertiesFile = "Resources/HiRegbin/" + chipName + ".chip";
        if (FileUtils.toAbsolutePath(propertiesFile) == null) {
            return;
        }
        if (!FileUtils.isExists(FileUtils.toAbsolutePath(propertiesFile))) {
            return;
        }
    }

    public void deviceChanged(Chip chip) {
        if (chip == null) {
            return;
        }
        if (currentChip != null && currentChip.equals(chip.getName())) {
            return;
        }
        if (RegbinView.isNotLoadImportExcelDataSuccess()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)RegbinView.this.getSite().getShell(), (String)Messages.Message_Warning, (String)Messages.PanelComposite_Wait_Import_ExcelData_Load_Success);
                }
            });
            RegbinView.setCurrentChip(currentChip);
            return;
        }
        try {
            RegbinView.setCurrentChip(chip.getName());
            RegbinView.setHi3716MV330Series(currentChip.contains(Hi3716MV330_SERIES_CHIP_NAME));
            RegbinView.setHi3716MV310Series(this.checkHi3716MV310(currentChip));
            RegbinView.setHi3716MV410Series(this.checkHi3716MV410(currentChip));
            RegbinView.setHi3716MV430Series(this.checkHi3716MV430(currentChip));
            RegbinView.setHi3798CV200Series(this.checkHi3798CV200(currentChip));
            RegbinView.setHi3798MV200Series(this.checkHi3798MV200(currentChip));
            RegbinView.setHi3796MV200Series(this.checkHi3796MV200(currentChip));
            RegbinView.setHi3798MV310Series(this.checkHi3798MV310(currentChip));
            RegbinView.setHi3796CV300Series(this.checkHi3796CV300(currentChip));
            IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(ID);
            if (view != null && view instanceof RegbinView) {
                while (!this.selectTempFile(false)) {
                }
                if (this.isClose) {
                    return;
                }
                if (Platform.inDevelopmentMode()) {
                    this.deviceChanged(chip.getName());
                } else {
                    ArrayList toolList = chip.getToolList();
                    for (Tool tool : toolList) {
                        List containingPlugin = tool.getContainingPlugin();
                        if (containingPlugin == null) continue;
                        for (String string : containingPlugin) {
                            String[] split;
                            if (!string.equals(Activator.getDefault().getBundle().getSymbolicName())) continue;
                            String param = tool.getParam();
                            if (param == null) {
                                this.deviceChanged(chip.getName());
                                return;
                            }
                            String[] stringArray = split = param.split(",");
                            int n = split.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String p = stringArray[n2];
                                String[] keyvalue = p.split("=");
                                if (keyvalue.length == 2 && "type".equalsIgnoreCase(keyvalue[0].trim())) {
                                    this.deviceChanged(keyvalue[1]);
                                    return;
                                }
                                ++n2;
                            }
                            this.deviceChanged(chip.getName());
                            return;
                        }
                    }
                }
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public boolean selectTempFile(boolean isLoad) throws DocumentException {
        String[] curExcelSuffix = null;
        curExcelSuffix = isHi3716MV310Series && !isHi3716MV330Series || isHi3716MV410Series ? TempExcelSelectDialog.getExcelSuffixTemp() : TempExcelSelectDialog.getExcelSuffixBin();
        TempExcelSelectDialog tempExcelSelectDialog = new TempExcelSelectDialog(Display.getCurrent().getActiveShell(), curExcelSuffix);
        int open = tempExcelSelectDialog.open();
        if (open == 0) {
            String tempFilePath = tempExcelSelectDialog.getTempFilePath();
            if (tempFilePath == null || tempFilePath.length() <= 0) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)RegbinView.this.getSite().getShell(), (String)Messages.Message_Error, (String)Messages.PanelComposite_TempFile_Isvalid);
                    }
                });
                return false;
            }
            if (!new File(tempFilePath).exists()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)RegbinView.this.getSite().getShell(), (String)Messages.Message_Error, (String)Messages.PanelComposite_TempFile_Not_Exist);
                    }
                });
                return false;
            }
            ProgressMonitorDialog progress = new ProgressMonitorDialog(null);
            try {
                progress.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(NLS.bind((String)Messages.PanelComposite_Load_TempFile, (Object)new File(tempFilePath).getName()), -1);
                        monitor.setTaskName(NLS.bind((String)Messages.PanelComposite_Load_TempFile, (Object)new File(tempFilePath).getName()));
                        RegbinView.this.loadFlag = RegbinView.this.loadTempExcel(tempFilePath);
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.isClose = false;
            return this.loadFlag;
        }
        if (!isLoad) {
            this.closeRegBinPerspective();
        }
        this.isClose = true;
        this.loadFlag = true;
        return true;
    }

    private void closeRegBinPerspective() {
        new Thread(){

            @Override
            public void run() {
                try {
                    5.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PerspectiveUtil.closePerpective((String)"com.hisilicon.hiregbin.perspectives.HiRegbinPerspective");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }.start();
    }

    public boolean loadTempExcel(String tempFilePath) {
        ExcelData excelData;
        block7: {
            try {
                excelData = this.readExcel(tempFilePath);
                if (excelData != null) break block7;
                if (ExcelDataHelper.isCheckGpioNotCorrect()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.Message_Lack_Of_Gpio_Group, (Object)ExcelDataHelper.getLackOfGpio()));
                        }
                    });
                } else {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)RegbinView.this.getSite().getShell(), (String)Messages.Message_Error, (String)NLS.bind((String)Messages.PanelComposite_TempFile_Please_Select_Again, (Object)currentChip));
                            PanelPreferences.CONFIG.setTempFilePath(tempFilePath);
                        }
                    });
                }
                return false;
            }
            catch (DocumentException e1) {
                e1.printStackTrace();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)RegbinView.this.getSite().getShell(), (String)Messages.Message_Error, (String)Messages.PanelComposite_Load_TempFile_Error);
                    }
                });
                return false;
            }
        }
        try {
            ParsedMainData parsedMainData = ExcelDataHelper.toParsedMainDataNew(excelData);
            ExcelDataHelper.setExcelData(excelData);
            ExcelDataHelper.setParsedMainData(parsedMainData);
            ExcelDataHelper.setDemoParsedMainData(parsedMainData);
            PanelPreferences.CONFIG.setTempFilePath(tempFilePath);
            RegbinView.setNotLoadImportExcelDataSuccess(true);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExcelData excelDataforImport = null;
                    try {
                        excelDataforImport = RegbinView.this.readExcel(tempFilePath);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (DocumentException e) {
                        e.printStackTrace();
                    }
                    ExcelDataHelper.setExcelDataforImport(excelDataforImport);
                    RegbinView.setNotLoadImportExcelDataSuccess(false);
                }
            });
            thread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)RegbinView.this.getSite().getShell(), (String)Messages.Message_Error, (String)Messages.PanelComposite_Load_TempFile_Error);
                }
            });
            return false;
        }
        return true;
    }

    protected ExcelData readExcel(String excelFilePath) throws DocumentException, NumberFormatException {
        String chipName;
        String fileName;
        ExcelData dataFromExecl;
        block15: {
            File excelFile;
            block14: {
                dataFromExecl = null;
                excelFile = new File(excelFilePath);
                fileName = excelFile.getName();
                File file = new File(fileName);
                if (!file.exists() && file.isDirectory()) {
                    return null;
                }
                System.out.println(fileName);
                chipName = fileName.substring(0, fileName.indexOf("_"));
                if (chipName.equalsIgnoreCase(RegbinView.getCurrentChip())) break block14;
                int regBaseIndex = fileName.indexOf("reg_base");
                if (fileName.indexOf("reg_base") == -1 || (chipName = fileName.substring(0, regBaseIndex - 1)).equalsIgnoreCase(RegbinView.getCurrentChip())) break block14;
                return null;
            }
            dataFromExecl = ExcelDataHelper.loadDataFromExcel(excelFile);
            if (dataFromExecl != null) break block15;
            return null;
        }
        try {
            if (!ExcelDataHelper.isV120RegFomatVersion(dataFromExecl) && !RegbinView.isHi3716MV330Series()) {
                String demoType = "";
                String otherString = "";
                chipName = "";
                if (fileName.lastIndexOf("_") + "_".length() < fileName.toLowerCase().indexOf(".xlsm")) {
                    otherString = fileName.substring(0, fileName.lastIndexOf("_"));
                }
                if (otherString.indexOf("_") > 0) {
                    chipName = otherString.substring(0, otherString.indexOf("_"));
                }
                if (otherString.indexOf("_") + 1 < otherString.length() && (demoType = otherString.substring(otherString.indexOf("_") + "_".length(), otherString.lastIndexOf("_"))).indexOf("_") > 0) {
                    demoType = demoType.substring(0, demoType.indexOf("_"));
                }
                dataFromExecl.getExcelMainData().setDdrType(demoType);
                dataFromExecl.getExcelMainData().setChipName(chipName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidExcelException e) {
            e.printStackTrace();
            return null;
        }
        catch (OpenXML4JException e) {
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return dataFromExecl;
    }

    public void deviceChanged(String deviceName) {
        if (deviceName == null || deviceName.trim().length() == 0) {
            return;
        }
        this.loadChipProperties(deviceName);
        Chip chip = new Chip();
        chip.setName(deviceName);
        this.deviceChanged(chip);
        this.deviceChanged();
    }

    public void deviceChanged() {
        if (this.parent != null) {
            if (this.panelComposite != null && !this.panelComposite.isDisposed()) {
                this.panelComposite.dispose();
            }
            this.createPanelControl(this.parent);
            this.parent.layout();
        }
    }

    public void dispose() {
        IWorkbenchWindow workbenchWindow;
        if (this.deviceManager != null) {
            this.deviceManager.removeDeviceChangedListener((IDeviceChangedListener)this);
        }
        if ((workbenchWindow = this.getViewSite().getPage().getWorkbenchWindow()) != null) {
            workbenchWindow.removePerspectiveListener((IPerspectiveListener)this);
            workbenchWindow.getShell().removeControlListener((ControlListener)this);
        }
        super.dispose();
    }

    @Override
    public void deviceChanged(IDeviceSetting device) {
        if (device == this.deviceSetting) {
            return;
        }
        this.deviceSetting = device;
        if (device == null) {
            return;
        }
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (HiRegbinPerspective.class.getName().equals(perspective.getId())) {
            if (this.deviceManager == null) {
                return;
            }
            String currentDevice = this.deviceManager.getCurrentDevice();
            if (currentChip.equals(currentDevice)) {
                return;
            }
            RegbinView.setCurrentChip(currentDevice);
            this.deviceChanged(this.deviceManager.findChipByName(currentChip));
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
    }

    private boolean checkHi3716MV310(String chipName) {
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3716MV310") || chipName.equalsIgnoreCase("Hi3716MV310_CA") || chipName.equalsIgnoreCase("Hi3716MV320") || chipName.equalsIgnoreCase(Hi3716MV330_SERIES_CHIP_NAME) || chipName.equalsIgnoreCase("Hi3716MV330_CA") || chipName.equalsIgnoreCase("Hi3110EV500_CA") || chipName.equalsIgnoreCase("Hi3110EV500") || chipName.equalsIgnoreCase("Hi3110EV500_CA");
    }

    private boolean checkHi3716MV410(String chipName) {
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3716MV410") || chipName.equalsIgnoreCase("Hi3716MV410_CA") || chipName.equalsIgnoreCase("Hi3716MV420") || chipName.equalsIgnoreCase("Hi3716MV420_CA");
    }

    private boolean checkHi3716MV430(String chipName) {
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3716MV430") || chipName.equalsIgnoreCase("Hi3716MV430N");
    }

    private boolean checkHi3798CV200(String chipName) {
        boolean isHi3798CV200Series;
        if (chipName == null) {
            return false;
        }
        boolean bl = isHi3798CV200Series = chipName.equalsIgnoreCase("Hi3798CV200") || chipName.equalsIgnoreCase("Hi3716MV410_CA_N") || chipName.equalsIgnoreCase("Hi3716MV420_CA_N") || chipName.equalsIgnoreCase("Hi3751V620") || chipName.equalsIgnoreCase("Hi3751V551") || chipName.equalsIgnoreCase("Hi3751V553");
        if (isHi3798CV200Series) {
            boolean isHi3716V550Series;
            boolean bl2 = isHi3716V550Series = chipName.equalsIgnoreCase("Hi3751V551") || chipName.equalsIgnoreCase("Hi3751V553");
            if (isHi3716V550Series) {
                RegbinView.setHi3716V550Series(true);
            } else {
                RegbinView.setHi3716V550Series(false);
            }
            return true;
        }
        RegbinView.setHi3716V550Series(false);
        return false;
    }

    private boolean checkHi3798MV200(String chipName) {
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3798MV200") || chipName.equalsIgnoreCase("Hi3716DV110") || chipName.equalsIgnoreCase("Hi3798MV300");
    }

    private boolean checkHi3798MV310(String chipName) {
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3798MV310") || chipName.equalsIgnoreCase("Hi3798MV300E") || chipName.equalsIgnoreCase("Hi3798MV320") || chipName.equalsIgnoreCase("Hi3798MV300H") || chipName.equalsIgnoreCase("Hi3798MV200H") || chipName.equalsIgnoreCase("Hi3561MV100");
    }

    private boolean checkHi3796CV300(String chipName) {
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3796CV300");
    }

    private boolean checkHi3796MV200(String chipName) {
        if (chipName == null) {
            return false;
        }
        return chipName.equalsIgnoreCase("Hi3796MV200") || chipName.equalsIgnoreCase("Hi3796AV200") || chipName.equalsIgnoreCase("Hi3716MV450");
    }

    public boolean isClose() {
        return this.isClose;
    }

    public void setClose(boolean isClose) {
        this.isClose = isClose;
    }

    public static String getCurrentChip() {
        return currentChip;
    }

    public static void setCurrentChip(String currentChip) {
        RegbinView.currentChip = currentChip;
    }

    public static boolean isNotLoadImportExcelDataSuccess() {
        return notLoadImportExcelDataSuccess;
    }

    public static void setNotLoadImportExcelDataSuccess(boolean notloadImportExcelDataSuccess) {
        notLoadImportExcelDataSuccess = notloadImportExcelDataSuccess;
    }

    public static boolean isHi3716MV330Series() {
        return isHi3716MV330Series;
    }

    public static void setHi3716MV330Series(boolean isHi3716MV330Series) {
        RegbinView.isHi3716MV330Series = isHi3716MV330Series;
    }

    public static boolean isHi3716MV310Series() {
        return isHi3716MV310Series;
    }

    public static void setHi3716MV310Series(boolean isHi3716MV310Series) {
        RegbinView.isHi3716MV310Series = isHi3716MV310Series;
    }

    public static boolean isHi3716MV410Series() {
        return isHi3716MV410Series;
    }

    public static void setHi3716MV410Series(boolean isHi3716MV410Series) {
        RegbinView.isHi3716MV410Series = isHi3716MV410Series;
    }

    public static boolean isHi3716MV430Series() {
        return isHi3716MV430Series;
    }

    public static void setHi3716MV430Series(boolean isHi3716MV430Series) {
        RegbinView.isHi3716MV430Series = isHi3716MV430Series;
    }

    public static boolean isHi3798CV200Series() {
        return isHi3798CV200Series;
    }

    public static void setHi3798CV200Series(boolean isHi3798CV200Series) {
        RegbinView.isHi3798CV200Series = isHi3798CV200Series;
    }

    public static boolean isHi3798MV200Series() {
        return isHi3798MV200Series;
    }

    public static void setHi3798MV200Series(boolean isHi3798MV200Series) {
        RegbinView.isHi3798MV200Series = isHi3798MV200Series;
    }

    public static boolean isHi3716V550Series() {
        return isHi3716V550Series;
    }

    public static void setHi3716V550Series(boolean isHi3716V550Series) {
        RegbinView.isHi3716V550Series = isHi3716V550Series;
    }

    public static boolean isHi3796MV200Series() {
        return isHi3796MV200Series;
    }

    public static void setHi3796MV200Series(boolean isHi3796MV200Series) {
        RegbinView.isHi3796MV200Series = isHi3796MV200Series;
    }

    public static boolean isHi3798MV310Series() {
        return isHi3798MV310Series;
    }

    public static void setHi3798MV310Series(boolean isHi3798MV310Series) {
        RegbinView.isHi3798MV310Series = isHi3798MV310Series;
    }

    public static boolean isHi3796CV300Series() {
        return isHi3796CV300Series;
    }

    public static void setHi3796CV300Series(boolean isHi3796CV300Series) {
        RegbinView.isHi3796CV300Series = isHi3796CV300Series;
    }

    static /* synthetic */ void access$0(RegbinView regbinView, boolean bl) {
        regbinView.loadFlag = bl;
    }

    static /* synthetic */ String access$1() {
        return currentChip;
    }
}

