/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.utility;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XLSXCovertCSVReader {
    private OPCPackage xlsxPackage;
    private int minColumns;
    private PrintStream output;
    private String sheetName;

    public XLSXCovertCSVReader(OPCPackage pkg, PrintStream output, String sheetName, int minColumns) {
        this.xlsxPackage = pkg;
        this.output = output;
        this.minColumns = minColumns;
        this.sheetName = sheetName;
    }

    public List<String[]> processSheet(StylesTable styles, ReadOnlySharedStringsTable strings, InputStream sheetInputStream) throws IOException, ParserConfigurationException, SAXException {
        InputSource sheetSource = new InputSource(sheetInputStream);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        SAXParser saxParser = saxFactory.newSAXParser();
        XMLReader sheetParser = saxParser.getXMLReader();
        MyXSSFSheetHandler handler = new MyXSSFSheetHandler(styles, strings, this.minColumns, this.output);
        sheetParser.setContentHandler(handler);
        sheetParser.parse(sheetSource);
        return handler.getRows();
    }

    public List<String[]> process() throws IOException, OpenXML4JException, ParserConfigurationException, SAXException {
        ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(this.xlsxPackage);
        XSSFReader xssfReader = new XSSFReader(this.xlsxPackage);
        List<String[]> list = null;
        StylesTable styles = xssfReader.getStylesTable();
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        while (iter.hasNext()) {
            InputStream stream = iter.next();
            String sheetNameTemp = iter.getSheetName();
            if (!this.sheetName.equals(sheetNameTemp)) continue;
            list = this.processSheet(styles, strings, stream);
            stream.close();
        }
        return list;
    }

    public static List<String[]> readerExcel(String path, String sheetName, int minColumns) throws IOException, OpenXML4JException, ParserConfigurationException, SAXException {
        OPCPackage p = OPCPackage.open((String)path, (PackageAccess)PackageAccess.READ);
        XLSXCovertCSVReader xlsx2csv = new XLSXCovertCSVReader(p, System.out, sheetName, minColumns);
        List<String[]> list = xlsx2csv.process();
        p.close();
        return list;
    }

    static /* synthetic */ int access$0(XLSXCovertCSVReader xLSXCovertCSVReader) {
        return xLSXCovertCSVReader.minColumns;
    }

    class MyXSSFSheetHandler
    extends DefaultHandler {
        private StylesTable stylesTable;
        private ReadOnlySharedStringsTable sharedStringsTable;
        private final PrintStream output;
        private final int minColumnCount;
        private boolean vIsOpen;
        private xssfDataType nextDataType;
        private short formatIndex;
        private String formatString;
        private final DataFormatter formatter;
        private int thisColumn = -1;
        private int lastColumnNumber = -1;
        private StringBuffer value;
        private String[] record;
        private List<String[]> rows = new ArrayList<String[]>();
        private boolean isCellNull = false;

        public MyXSSFSheetHandler(StylesTable styles, ReadOnlySharedStringsTable strings, int cols, PrintStream target) {
            this.stylesTable = styles;
            this.sharedStringsTable = strings;
            this.minColumnCount = cols;
            this.output = target;
            this.value = new StringBuffer();
            this.nextDataType = xssfDataType.NUMBER;
            this.formatter = new DataFormatter();
            this.record = new String[this.minColumnCount];
            this.rows.clear();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("inlineStr".equals(name) || "v".equals(name)) {
                this.vIsOpen = true;
                this.value.setLength(0);
            } else if ("c".equals(name)) {
                String r = attributes.getValue("r");
                int firstDigit = -1;
                int c = 0;
                while (c < r.length()) {
                    if (Character.isDigit(r.charAt(c))) {
                        firstDigit = c;
                        break;
                    }
                    ++c;
                }
                this.thisColumn = this.nameToColumn(r.substring(0, firstDigit));
                this.nextDataType = xssfDataType.NUMBER;
                this.formatIndex = (short)-1;
                this.formatString = null;
                String cellType = attributes.getValue("t");
                String cellStyleStr = attributes.getValue("s");
                if ("b".equals(cellType)) {
                    this.nextDataType = xssfDataType.BOOL;
                } else if ("e".equals(cellType)) {
                    this.nextDataType = xssfDataType.ERROR;
                } else if ("inlineStr".equals(cellType)) {
                    this.nextDataType = xssfDataType.INLINESTR;
                } else if ("s".equals(cellType)) {
                    this.nextDataType = xssfDataType.SSTINDEX;
                } else if ("str".equals(cellType)) {
                    this.nextDataType = xssfDataType.FORMULA;
                } else if (cellStyleStr != null) {
                    int styleIndex = Integer.parseInt(cellStyleStr);
                    XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
                    this.formatIndex = style.getDataFormat();
                    this.formatString = style.getDataFormatString();
                    if (this.formatString == null) {
                        this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            String thisStr = null;
            if ("v".equals(name)) {
                switch (this.nextDataType) {
                    case BOOL: {
                        char first = this.value.charAt(0);
                        thisStr = first == '0' ? "FALSE" : "TRUE";
                        break;
                    }
                    case ERROR: {
                        thisStr = "\"ERROR:" + this.value.toString() + '\"';
                        break;
                    }
                    case FORMULA: {
                        thisStr = String.valueOf('\"') + this.value.toString() + '\"';
                        break;
                    }
                    case INLINESTR: {
                        XSSFRichTextString rtsi = new XSSFRichTextString(this.value.toString());
                        thisStr = rtsi.toString();
                        break;
                    }
                    case SSTINDEX: {
                        String sstIndex = this.value.toString();
                        try {
                            int idx = Integer.parseInt(sstIndex);
                            XSSFRichTextString rtss = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx));
                            thisStr = rtss.toString();
                        }
                        catch (NumberFormatException ex) {
                            this.output.println("Failed to parse SST index '" + sstIndex + "': " + ex.toString());
                        }
                        break;
                    }
                    case NUMBER: {
                        String n = this.value.toString();
                        if (HSSFDateUtil.isADateFormat((int)this.formatIndex, (String)n)) {
                            Double d = Double.parseDouble(n);
                            Date date = HSSFDateUtil.getJavaDate((double)d);
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            thisStr = sdf.format(date);
                            break;
                        }
                        if (this.formatString != null) {
                            thisStr = this.formatter.formatRawCellContents(Double.parseDouble(n), (int)this.formatIndex, this.formatString);
                            break;
                        }
                        thisStr = n;
                        break;
                    }
                    default: {
                        thisStr = "(TODO: Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
                    }
                }
                if (this.lastColumnNumber == -1) {
                    this.lastColumnNumber = 0;
                }
                if (thisStr == null) {
                    this.isCellNull = true;
                }
                if (this.thisColumn < this.record.length) {
                    this.record[this.thisColumn] = thisStr;
                }
                if (this.thisColumn > -1) {
                    this.lastColumnNumber = this.thisColumn;
                }
            } else if ("row".equals(name)) {
                if (XLSXCovertCSVReader.this.minColumns > 0) {
                    if (this.lastColumnNumber == -1) {
                        this.lastColumnNumber = 0;
                    }
                    if (!this.isCellNull || this.record[0] != null || this.record[1] != null || this.record[2] != null || this.record[3] != null) {
                        this.rows.add((String[])this.record.clone());
                        this.isCellNull = false;
                        int i = 0;
                        while (i < this.record.length) {
                            this.record[i] = null;
                            ++i;
                        }
                    }
                }
                this.lastColumnNumber = -1;
            }
        }

        public List<String[]> getRows() {
            return this.rows;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.vIsOpen) {
                this.value.append(ch, start, length);
            }
        }

        private int nameToColumn(String name) {
            int column = -1;
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                column = (column + 1) * 26 + c - 65;
                ++i;
            }
            return column;
        }
    }

    static enum xssfDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER;

    }
}

