/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.utility;

import com.hisilicon.hiregbin.utility.FileUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class TextReader {
    protected static final HashMap<String, Properties> sections = new HashMap();
    private static ArrayList<String> newList = new ArrayList();
    private Properties current = null;
    public static final String CONFIG_NAME = "ConfigName";
    public static final String DDR_PARAM_SETTING = "DdrParamters";
    public static final String MAC_NAME = "MacName";
    public static final String PHY_ADDRESS = "PhyAddress";
    public static final String GPIO_GROUP_NUM = "GpioGroupNum";
    public static final String GPIO_BITS = "GpioBits";
    public static final String GPIO = "GPIO";
    public static final String STARTUP = "Startup";
    public static final String DDRPHY = "DdrPhy";

    public TextReader(String filename) throws IOException {
        BufferedReader reader = null;
        try {
            try {
                sections.clear();
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), System.getProperty("file.encoding")));
                this.read(reader);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void read(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            this.parseLine(line);
        }
    }

    private void parseLine(String line) {
        if ((line = line.trim()).matches("^\\[\\S+\\]$")) {
            String currentSecion = line.replaceFirst("^\\[(\\S+)\\]$", "$1");
            this.current = new Properties();
            sections.put(currentSecion, this.current);
        } else if (line.matches(".*=.*") && this.current != null) {
            int i = line.indexOf(61);
            String name = line.substring(0, i);
            String value = line.substring(i + 1);
            this.current.setProperty(name, value);
        }
    }

    public String getValue(String section, String name) {
        Properties p = sections.get(section);
        if (p == null) {
            return null;
        }
        String value = p.getProperty(name);
        return value;
    }

    public static String writeKeyAndValue(String key, String value) {
        StringBuilder stBuilder = new StringBuilder();
        stBuilder.append(key);
        stBuilder.append("=");
        stBuilder.append(value);
        return stBuilder.toString();
    }

    public static void initCreateFile() {
        if (newList != null) {
            newList.clear();
        } else {
            newList = new ArrayList();
        }
    }

    public static void addParam(String secionName, String paramName, String value) {
        String paramStr = TextReader.writeKeyAndValue(paramName, value);
        int seciconInde = -1;
        if (newList != null) {
            int i = 0;
            while (i < newList.size()) {
                String string = newList.get(i);
                if (string.equals(secionName)) {
                    seciconInde = i;
                    break;
                }
                ++i;
            }
            if (seciconInde != -1) {
                newList.add(seciconInde, paramStr);
            } else {
                newList.add(paramStr);
            }
        }
    }

    public static void addSecion(String secionName) {
        String indexStr = "[" + secionName + "]";
        if (newList != null) {
            newList.add(indexStr);
        }
    }

    public static boolean writeNewListToFile(String filePath) {
        if (newList != null && newList.size() > 0) {
            boolean writeAllLines = FileUtils.writeAllLines(newList, filePath, false, "GBK");
            newList.clear();
            return writeAllLines;
        }
        return false;
    }
}

