/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.ui;

import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.model.BaseParam;
import com.hisilicon.hiregbin.model.GlobleInfo;
import com.hisilicon.hiregbin.model.reg.BaseRegisterInfo;
import com.hisilicon.hiregbin.model.reg.DemoBaseParam;
import com.hisilicon.hiregbin.model.reg.NetworkConfig;
import com.hisilicon.hiregbin.model.reg.ParsedMainData;
import com.hisilicon.hiregbin.model.reg.bin.RegBinAction;
import com.hisilicon.hiregbin.model.reg.excel.ExcelData;
import com.hisilicon.hiregbin.model.reg.excel.ExcelWorkbookInfo;
import com.hisilicon.hiregbin.model.reg.excel.MainDdrParam;
import com.hisilicon.hiregbin.model.reg.excel.MainNetconfig;
import com.hisilicon.hiregbin.model.reg.excel.MainRegInfo;
import com.hisilicon.hiregbin.utility.BitUtils;
import com.hisilicon.hiregbin.utility.ExcelDataHelper;
import com.hisilicon.hiregbin.utility.LayoutUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RegisterInfoDialog
extends Dialog {
    private static final String HEX_STR = "0x";
    private static final String EMPTY = " ";
    private static String[] registerColumnNames = new String[]{"Register", "Offset Address", "Value", "Delay", "Read or Write", "Bit", "Start Bit"};
    private ArrayList<Combo> comboDdrParamList;
    private BaseParam baseParam;
    private TabFolder tabFolder;
    private String[] tableNames;
    private ExcelData currentExcelData;
    private Label labCustomDemoName;

    protected RegisterInfoDialog(Shell parentShell, String[] tableNames, ExcelData currentExcelData, ArrayList<Combo> comboDdrParamList, Label labCustomDemoName, BaseParam baseParam) {
        super(parentShell);
        this.tableNames = tableNames;
        this.currentExcelData = currentExcelData;
        this.comboDdrParamList = comboDdrParamList;
        this.labCustomDemoName = labCustomDemoName;
        this.baseParam = baseParam;
    }

    protected final int getShellStyle() {
        return 192;
    }

    protected Control createContents(Composite parent) {
        parent.getShell().setText(Messages.RegisterInfoDialog_ShellName);
        parent.setSize(800, 450);
        parent.setLayout((Layout)new GridLayout(1, false));
        LayoutUtils.centerShell(parent.getDisplay(), parent.getShell());
        this.tabFolder = new TabFolder(parent, 0);
        this.tabFolder.setLayout((Layout)new GridLayout(1, false));
        this.tabFolder.setBackground(GlobleInfo.white);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        HashMap<String, String> selectDdrParamValueMap = new HashMap<String, String>();
        int comboIndex = 0;
        while (comboIndex < this.comboDdrParamList.size()) {
            Combo combo = this.comboDdrParamList.get(comboIndex);
            String paramName = (String)combo.getData();
            String selectParamValue = combo.getText();
            selectDdrParamValueMap.put(paramName, selectParamValue);
            ++comboIndex;
        }
        int tableIndex = 0;
        while (tableIndex < this.tableNames.length) {
            ExcelWorkbookInfo currentWorkBook;
            if (this.tableNames[tableIndex] != null && (currentWorkBook = this.currentExcelData.getExcelWorkbookInfoByModuleName(this.tableNames[tableIndex])) != null) {
                ArrayList<BaseRegisterInfo> baseRegisterInfoList = currentWorkBook.getBaseRegisterInfoList();
                this.updateCurrentDemoValue(tableIndex);
                ArrayList<BaseRegisterInfo> filterCurrentRegList = this.filterCurrentRegList(selectDdrParamValueMap, tableIndex, baseRegisterInfoList);
                int baseAddress = currentWorkBook.getBaseAddress();
                TabItem baseSettingItem = new TabItem(this.tabFolder, 0);
                baseSettingItem.setText(this.tableNames[tableIndex]);
                Composite baseComposite = new Composite((Composite)this.tabFolder, 0);
                baseComposite.setLayout((Layout)new GridLayout(3, false));
                baseComposite.setLayoutData((Object)new GridData(1808));
                baseComposite.setBackground(GlobleInfo.white);
                baseSettingItem.setControl((Control)baseComposite);
                Label labAddress = new Label(baseComposite, 0);
                labAddress.setText(Messages.RegisterInfoDialog_BaseAddress);
                GridData labAddressGD = new GridData(1, 1, false, false);
                labAddress.setLayoutData((Object)labAddressGD);
                labAddress.setBackground(GlobleInfo.white);
                Text textAddress = new Text(baseComposite, 2048);
                GridData textAddressGD = new GridData(1, 1, false, false);
                textAddressGD.horizontalIndent = 15;
                textAddressGD.widthHint = 150;
                textAddress.setLayoutData((Object)textAddressGD);
                textAddress.setBackground(GlobleInfo.white);
                textAddress.setEnabled(false);
                textAddress.setText(HEX_STR + Integer.toHexString(baseAddress));
                Label stateLabel = new Label(baseComposite, 0);
                GridData stateLabelGD = new GridData(4, 1, true, false);
                stateLabelGD.horizontalIndent = 20;
                stateLabel.setLayoutData((Object)stateLabelGD);
                stateLabel.setText("");
                stateLabel.setBackground(GlobleInfo.white);
                Composite tableComposite = new Composite(baseComposite, 0);
                TableColumnLayout tcl = new TableColumnLayout();
                tableComposite.setLayout((Layout)tcl);
                GridData tableCompositeGD = new GridData(4, 4, true, true, 10, 1);
                tableCompositeGD.minimumHeight = 220;
                tableComposite.setLayoutData((Object)tableCompositeGD);
                TableViewer registerTableViewer = new TableViewer(tableComposite, 67584);
                registerTableViewer.getTable().setLayoutData((Object)new GridData(1808));
                Table table = registerTableViewer.getTable();
                table.setHeaderVisible(true);
                table.setLinesVisible(true);
                table.addListener(42, new Listener(){

                    public void handleEvent(Event event) {
                        RegisterInfoDialog.this.handlePaintTableItem(event);
                    }
                });
                int minWeidth = 20;
                TableColumn tableColumn = new TableColumn(table, 0x1000000, 0);
                tableColumn.setMoveable(true);
                tableColumn.setResizable(true);
                tableColumn.setText(registerColumnNames[0]);
                tableColumn.setAlignment(0x1000000);
                tcl.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(4, 20, true));
                tableColumn = new TableColumn(table, 0x1000000, 1);
                tableColumn.setMoveable(true);
                tableColumn.setResizable(true);
                tableColumn.setText(registerColumnNames[1]);
                tableColumn.setAlignment(0x1000000);
                tcl.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(3, 20, true));
                tableColumn = new TableColumn(table, 0x1000000, 2);
                tableColumn.setMoveable(true);
                tableColumn.setResizable(true);
                tableColumn.setText(registerColumnNames[2]);
                tableColumn.setAlignment(0x1000000);
                tcl.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(3, 20, true));
                tableColumn = new TableColumn(table, 0x1000000, 3);
                tableColumn.setMoveable(true);
                tableColumn.setResizable(true);
                tableColumn.setText(registerColumnNames[3]);
                tableColumn.setAlignment(0x1000000);
                tcl.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(3, 20, true));
                tableColumn = new TableColumn(table, 0x1000000, 4);
                tableColumn.setMoveable(true);
                tableColumn.setResizable(true);
                tableColumn.setText(registerColumnNames[4]);
                tableColumn.setAlignment(0x1000000);
                tcl.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(3, 20, true));
                tableColumn = new TableColumn(table, 0x1000000, 5);
                tableColumn.setMoveable(true);
                tableColumn.setResizable(true);
                tableColumn.setText(registerColumnNames[5]);
                tableColumn.setAlignment(0x1000000);
                tcl.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(2, 20, true));
                tableColumn = new TableColumn(table, 0x1000000, 6);
                tableColumn.setMoveable(true);
                tableColumn.setResizable(true);
                tableColumn.setText(registerColumnNames[6]);
                tableColumn.setAlignment(0x1000000);
                tcl.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(2, 20, true));
                registerTableViewer.setColumnProperties(registerColumnNames);
                registerTableViewer.setCellModifier(new ICellModifier(){

                    public void modify(Object element, String property, Object value) {
                    }

                    public Object getValue(Object element, String property) {
                        BaseRegisterInfo baseRegisterInfo = null;
                        if (element instanceof BaseRegisterInfo) {
                            baseRegisterInfo = (BaseRegisterInfo)element;
                        }
                        if (property.equals(registerColumnNames[0])) {
                            String regName = baseRegisterInfo.getRegName();
                            return regName == null ? "" : regName;
                        }
                        if (property.equals(registerColumnNames[1])) {
                            String regOffsetAddress = String.valueOf(baseRegisterInfo.getRegOffsetAddress());
                            return regOffsetAddress;
                        }
                        if (property.equals(registerColumnNames[2])) {
                            String regValue = String.valueOf(baseRegisterInfo.getRegValue());
                            return regValue;
                        }
                        if (property.equals(registerColumnNames[3])) {
                            String regDelay = String.valueOf(baseRegisterInfo.getRegDelay());
                            return regDelay;
                        }
                        if (property.equals(registerColumnNames[4])) {
                            String regReadOrWrite = String.valueOf((Object)baseRegisterInfo.getRegReadOrWrite());
                            return regReadOrWrite;
                        }
                        if (property.equals(registerColumnNames[5])) {
                            String regBit = String.valueOf(baseRegisterInfo.getRegBit());
                            return regBit;
                        }
                        if (property.equals(registerColumnNames[6])) {
                            String regStartBit = String.valueOf(baseRegisterInfo.getRegStartBit());
                            return regStartBit;
                        }
                        return baseRegisterInfo;
                    }

                    public boolean canModify(Object element, String property) {
                        return false;
                    }
                });
                registerTableViewer.setContentProvider((IContentProvider)new ContentProvider());
                registerTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
                registerTableViewer.setInput(filterCurrentRegList);
                registerTableViewer.setCellEditors(new CellEditor[7]);
                registerTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        IStructuredSelection selection = (IStructuredSelection)registerTableViewer.getSelection();
                        Object firstElement = selection.getFirstElement();
                        if (firstElement instanceof BaseRegisterInfo) {
                            BaseRegisterInfo baseRegisterInfo = (BaseRegisterInfo)firstElement;
                            StringBuilder stateString = new StringBuilder();
                            String demoInfoString = "Demo Info: ";
                            stateString.append(demoInfoString);
                            if (baseRegisterInfo.getDemoRegValue() != -1 && baseRegisterInfo.getDemoRegValue() != baseRegisterInfo.getRegValue()) {
                                stateString.append(RegisterInfoDialog.EMPTY);
                                stateString.append("Value: 0x" + Integer.toHexString(baseRegisterInfo.getDemoRegValue()));
                            }
                            if (baseRegisterInfo.getDemoRegDelay() != -1 && baseRegisterInfo.getDemoRegDelay() != baseRegisterInfo.getRegDelay()) {
                                stateString.append(RegisterInfoDialog.EMPTY);
                                stateString.append(RegisterInfoDialog.EMPTY);
                                stateString.append("Delay: " + baseRegisterInfo.getDemoRegDelay());
                            }
                            if (baseRegisterInfo.getDemoRegReadOrWrite() != RegBinAction.INVALID && baseRegisterInfo.getDemoRegReadOrWrite() != baseRegisterInfo.getRegReadOrWrite()) {
                                stateString.append(RegisterInfoDialog.EMPTY);
                                stateString.append(RegisterInfoDialog.EMPTY);
                                stateString.append("Read Or Write: " + baseRegisterInfo.getDemoRegReadOrWrite().name().toLowerCase());
                            }
                            if (baseRegisterInfo.getDemoRegBit() != -1 && baseRegisterInfo.getDemoRegBit() != baseRegisterInfo.getRegBit()) {
                                stateString.append(RegisterInfoDialog.EMPTY);
                                stateString.append(RegisterInfoDialog.EMPTY);
                                stateString.append("Bit: " + baseRegisterInfo.getDemoRegBit());
                            }
                            if (baseRegisterInfo.getDemoRegStartBit() != -1 && baseRegisterInfo.getDemoRegStartBit() != baseRegisterInfo.getRegStartBit()) {
                                stateString.append(RegisterInfoDialog.EMPTY);
                                stateString.append(RegisterInfoDialog.EMPTY);
                                stateString.append("Start Bit: " + baseRegisterInfo.getDemoRegStartBit());
                            }
                            if (!stateString.toString().isEmpty() && !stateString.toString().equalsIgnoreCase(demoInfoString)) {
                                stateLabel.setText(stateString.toString());
                                stateLabel.setForeground(GlobleInfo.red);
                            } else {
                                stateLabel.setForeground(GlobleInfo.white);
                            }
                        }
                    }
                });
            }
            ++tableIndex;
        }
        return this.tabFolder;
    }

    private ArrayList<BaseRegisterInfo> filterCurrentRegList(Map<String, String> selectDdrParamValueMap, int tableIndex, ArrayList<BaseRegisterInfo> baseRegisterInfoList) {
        ArrayList<BaseRegisterInfo> newBaseRegisterList = new ArrayList<BaseRegisterInfo>();
        int regIndex = 0;
        while (regIndex < baseRegisterInfoList.size()) {
            BaseRegisterInfo baseRegsiterInfo = baseRegisterInfoList.get(regIndex);
            ArrayList<MainDdrParam> mainDdrParamList = this.currentExcelData.getExcelMainData().getMainDdrParamList();
            boolean filterSelectDdrParamResult = false;
            int paramIndex = 0;
            while (paramIndex < mainDdrParamList.size()) {
                MainDdrParam mainDdrParam = mainDdrParamList.get(paramIndex);
                filterSelectDdrParamResult = this.filterSelectDdrParam(this.tableNames[tableIndex], baseRegsiterInfo, mainDdrParamList, selectDdrParamValueMap, mainDdrParam);
                if (filterSelectDdrParamResult) break;
                ++paramIndex;
            }
            if (!filterSelectDdrParamResult) {
                newBaseRegisterList.add(baseRegsiterInfo);
            }
            ++regIndex;
        }
        return newBaseRegisterList;
    }

    protected void updateCurrentDemoValue(int tableIndex) {
        String customName = this.labCustomDemoName.getText();
        String customDemoName = customName.substring(0, customName.indexOf("_"));
        ParsedMainData parsedMainData = ExcelDataHelper.getDemoParsedMainData();
        LinkedHashMap<String, ArrayList<BaseRegisterInfo>> comboParamRegInfoMap = parsedMainData.getComboParamRegInfoMap();
        for (Map.Entry<String, ArrayList<BaseRegisterInfo>> comboParamRegNext : comboParamRegInfoMap.entrySet()) {
            String paramName = comboParamRegNext.getKey();
            ArrayList<BaseRegisterInfo> paramRegList = comboParamRegNext.getValue();
            ArrayList<DemoBaseParam> demoList = ExcelDataHelper.getExcelData().getExcelMainData().getDemoList();
            int demoIndex = 0;
            while (demoIndex < demoList.size()) {
                DemoBaseParam demoBaseParam = demoList.get(demoIndex);
                String demoName = demoBaseParam.getDemoName();
                if (demoName.equalsIgnoreCase(customDemoName)) {
                    Map<String, String> dynamicParamMap = demoBaseParam.getDynamicParamMap();
                    for (Map.Entry<String, String> dynamicParamNext : dynamicParamMap.entrySet()) {
                        String dynamicParamName = dynamicParamNext.getKey();
                        String dynamicParamFuction = dynamicParamNext.getValue();
                        if (!dynamicParamName.equalsIgnoreCase(paramName)) continue;
                        for (BaseRegisterInfo paramRegInfo : paramRegList) {
                            String regFunction = paramRegInfo.getRegFunction();
                            if (regFunction == null || !regFunction.equalsIgnoreCase(dynamicParamFuction)) continue;
                            if (ExcelDataHelper.getExcelData() == this.currentExcelData) {
                                ExcelData excelData = ExcelDataHelper.getExcelData();
                                this.refreshDemoRegValue(tableIndex, excelData, paramRegInfo);
                                continue;
                            }
                            this.refreshDemoRegValue(tableIndex, this.currentExcelData, paramRegInfo);
                        }
                    }
                }
                ++demoIndex;
            }
        }
        ArrayList<BaseRegisterInfo> baseRegisterInfoList = null;
        if (ExcelDataHelper.getExcelData() == this.currentExcelData) {
            ExcelWorkbookInfo demoExcelWorkbook = ExcelDataHelper.getExcelData().getExcelWorkbookInfoByModuleName(this.tableNames[tableIndex]);
            if (demoExcelWorkbook == null) {
                return;
            }
            baseRegisterInfoList = demoExcelWorkbook.getBaseRegisterInfoList();
        } else {
            ExcelWorkbookInfo currentDemoExcelWorkbook = this.currentExcelData.getExcelWorkbookInfoByModuleName(this.tableNames[tableIndex]);
            if (currentDemoExcelWorkbook == null) {
                return;
            }
            baseRegisterInfoList = currentDemoExcelWorkbook.getBaseRegisterInfoList();
        }
        ArrayList<NetworkConfig> netWorkConfigList = parsedMainData.getNetWorkConfigList();
        for (BaseRegisterInfo baseRegisterInfo : baseRegisterInfoList) {
            if (!this.tableNames[tableIndex].equalsIgnoreCase("eth_phy_cfg")) continue;
            baseRegisterInfo.setDemoRegBit(baseRegisterInfo.getRegBit());
            baseRegisterInfo.setDemoRegDelay(baseRegisterInfo.getRegDelay());
            baseRegisterInfo.setDemoRegReadOrWrite(baseRegisterInfo.getRegReadOrWrite());
            baseRegisterInfo.setDemoRegStartBit(baseRegisterInfo.getRegStartBit());
            baseRegisterInfo.setDemoRegValue(baseRegisterInfo.getRegValue());
        }
        Map<String, String> selectGpioGroupNumValueMap = this.baseParam.getSelectGpioGroupNumValueMap();
        Map<String, String> selectGpioBitsValueMap = this.baseParam.getSelectGpioBitsValueMap();
        Map<String, String> selectPhyAddrValueMap = this.baseParam.getSelectPhyAddrValueMap();
        ArrayList<MainNetconfig> mainNetconfigList = ExcelDataHelper.getExcelData().getExcelMainData().getMainNetconfigList();
        for (BaseRegisterInfo baseRegisterInfo : baseRegisterInfoList) {
            String regName = baseRegisterInfo.getRegName();
            int macIndex = 0;
            while (macIndex < mainNetconfigList.size()) {
                MainNetconfig mainNetconfig = mainNetconfigList.get(macIndex);
                NetworkConfig demoNetworkConfig = netWorkConfigList.get(macIndex);
                String netMacName = mainNetconfig.getNetconfigName();
                MainRegInfo netPhyAddr = mainNetconfig.getNetPhyAddr();
                MainRegInfo netResetPin = mainNetconfig.getNetResetPin();
                String netPhyAddressReg = netPhyAddr.getRegName();
                String netResetPinReg = netResetPin.getRegName();
                if (regName.equalsIgnoreCase(netPhyAddressReg) && selectPhyAddrValueMap.containsKey(netMacName)) {
                    String phyAddr = selectPhyAddrValueMap.get(netMacName);
                    int netPhyAddress = demoNetworkConfig.getNetPhyAddress();
                    baseRegisterInfo.setRegValue(BitUtils.parseLongToInt32(phyAddr, true));
                    baseRegisterInfo.setDemoRegValue(netPhyAddress);
                }
                if (netResetPinReg.contains(regName) && selectGpioGroupNumValueMap.containsKey(netMacName) && selectGpioBitsValueMap.containsKey(netMacName)) {
                    String gpioGroupNum = selectGpioGroupNumValueMap.get(netMacName);
                    String gpioBitsNum = selectGpioBitsValueMap.get(netMacName);
                    int netGpioGroupNumber = demoNetworkConfig.getNetGpioGroupNumber();
                    int netGpioBitNumber = demoNetworkConfig.getNetGpioBitNumber();
                    if (regName.endsWith("_BIT")) {
                        baseRegisterInfo.setRegValue(Integer.parseInt(gpioBitsNum));
                        baseRegisterInfo.setDemoRegValue(netGpioBitNumber);
                    } else {
                        baseRegisterInfo.setRegValue(Integer.parseInt(gpioGroupNum));
                        baseRegisterInfo.setDemoRegValue(netGpioGroupNumber);
                    }
                }
                ++macIndex;
            }
        }
    }

    private void refreshDemoRegValue(int tableIndex, ExcelData demoExcelData, BaseRegisterInfo paramRegInfo) {
        int regBit = paramRegInfo.getRegBit();
        int regDelay = paramRegInfo.getRegDelay();
        int regValue = paramRegInfo.getRegValue();
        int regStartBit = paramRegInfo.getRegStartBit();
        RegBinAction regReadOrWrite = paramRegInfo.getRegReadOrWrite();
        String paramRegName = paramRegInfo.getRegName();
        ExcelWorkbookInfo demoExcelWorkbook = demoExcelData.getExcelWorkbookInfoByModuleName(this.tableNames[tableIndex]);
        if (demoExcelWorkbook == null) {
            return;
        }
        ArrayList<BaseRegisterInfo> baseRegisterInfoList = demoExcelWorkbook.getBaseRegisterInfoList();
        for (BaseRegisterInfo baseRegisterInfo : baseRegisterInfoList) {
            String regName = baseRegisterInfo.getRegName();
            if (!regName.equalsIgnoreCase(paramRegName)) continue;
            baseRegisterInfo.setDemoRegBit(regBit);
            baseRegisterInfo.setDemoRegDelay(regDelay);
            baseRegisterInfo.setDemoRegReadOrWrite(regReadOrWrite);
            baseRegisterInfo.setDemoRegStartBit(regStartBit);
            baseRegisterInfo.setDemoRegValue(regValue);
        }
    }

    protected void handlePaintTableItem(Event event) {
        event.detail &= 0xFFFFFFDF;
        if ((event.detail & 2) == 0) {
            return;
        }
        Table table = (Table)event.widget;
        int clientWidth = table.getClientArea().width;
        GC gc = event.gc;
        Color oldForeground = gc.getForeground();
        Color oldBackground = gc.getBackground();
        Color forecolor = new Color(null, new RGB(255, 0, 0));
        gc.setForeground(forecolor);
        gc.drawRectangle(0, event.y, clientWidth, event.height - 2);
        forecolor.dispose();
        gc.setForeground(oldForeground);
        gc.setBackground(oldBackground);
        event.detail &= 0xFFFFFFFD;
    }

    private boolean filterSelectDdrParam(String currentWorkbookName, BaseRegisterInfo baseRegsiterInfo, ArrayList<MainDdrParam> mainDdrParamList, Map<String, String> selectDdrParamValueMap, MainDdrParam mainDdrParam) {
        String ddrParamName = mainDdrParam.getDdrParamName();
        ArrayList<MainRegInfo> ddrRegList = mainDdrParam.getDdrRegList();
        boolean isIgnoreRegsiterInfo = false;
        String regName = baseRegsiterInfo.getRegName();
        for (MainRegInfo mainRegInfo : ddrRegList) {
            String mainRegName = mainRegInfo.getRegName();
            String mainRegPage = mainRegInfo.getRegPage();
            if (mainRegName == null || mainRegPage == null || !currentWorkbookName.equalsIgnoreCase(mainRegPage) || !regName.equals(mainRegName)) continue;
            String currentRegFunction = baseRegsiterInfo.getRegFunction();
            for (Map.Entry<String, String> entry : selectDdrParamValueMap.entrySet()) {
                String selectValue;
                String paramName = entry.getKey();
                if (!paramName.equals(ddrParamName) || currentRegFunction.equalsIgnoreCase(selectValue = entry.getValue())) continue;
                isIgnoreRegsiterInfo = true;
                return isIgnoreRegsiterInfo;
            }
        }
        return isIgnoreRegsiterInfo;
    }

    static /* synthetic */ String[] access$0() {
        return registerColumnNames;
    }

    static class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ArrayList) {
                ArrayList baseRegisterInfoList = (ArrayList)inputElement;
                return baseRegisterInfoList.toArray();
            }
            return new Object[0];
        }
    }

    static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof BaseRegisterInfo) {
                BaseRegisterInfo baseRegisterInfo = (BaseRegisterInfo)element;
                if (columnIndex == 0) {
                    return baseRegisterInfo.getRegName();
                }
                if (columnIndex == 1) {
                    return String.valueOf(RegisterInfoDialog.HEX_STR + Integer.toHexString(baseRegisterInfo.getRegOffsetAddress()));
                }
                if (columnIndex == 2) {
                    return String.valueOf(RegisterInfoDialog.HEX_STR + Integer.toHexString(baseRegisterInfo.getRegValue()));
                }
                if (columnIndex == 3) {
                    return String.valueOf(baseRegisterInfo.getRegDelay());
                }
                if (columnIndex == 4) {
                    return baseRegisterInfo.getRegReadOrWrite().name().toLowerCase();
                }
                if (columnIndex == 5) {
                    return String.valueOf(baseRegisterInfo.getRegBit());
                }
                if (columnIndex == 6) {
                    return String.valueOf(baseRegisterInfo.getRegStartBit());
                }
            }
            return "";
        }

        public Color getForeground(Object element, int columnIndex) {
            if (element instanceof BaseRegisterInfo) {
                BaseRegisterInfo baseRegisterInfo = (BaseRegisterInfo)element;
                switch (columnIndex) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        int demoRegValue = baseRegisterInfo.getDemoRegValue();
                        int currentRegValue = baseRegisterInfo.getRegValue();
                        System.out.println("demoRegValue: " + demoRegValue);
                        System.out.println("currentRegValue: " + currentRegValue);
                        if (demoRegValue == -1 || demoRegValue == currentRegValue) break;
                        return Display.getDefault().getSystemColor(3);
                    }
                    case 3: {
                        if (baseRegisterInfo.getDemoRegDelay() == -1 || baseRegisterInfo.getDemoRegDelay() == baseRegisterInfo.getRegDelay()) break;
                        return Display.getDefault().getSystemColor(3);
                    }
                    case 4: {
                        if (baseRegisterInfo.getDemoRegReadOrWrite() == RegBinAction.INVALID || baseRegisterInfo.getDemoRegReadOrWrite() == baseRegisterInfo.getRegReadOrWrite()) break;
                        return Display.getDefault().getSystemColor(3);
                    }
                    case 5: {
                        if (baseRegisterInfo.getDemoRegBit() == -1 || baseRegisterInfo.getDemoRegBit() == baseRegisterInfo.getRegBit()) break;
                        return Display.getDefault().getSystemColor(3);
                    }
                    case 6: {
                        if (baseRegisterInfo.getDemoRegStartBit() == -1 || baseRegisterInfo.getDemoRegStartBit() == baseRegisterInfo.getRegStartBit()) break;
                        return Display.getDefault().getSystemColor(3);
                    }
                }
            }
            return Display.getDefault().getSystemColor(2);
        }

        public Color getBackground(Object element, int columnIndex) {
            BaseRegisterInfo baseRegisterInfo = (BaseRegisterInfo)element;
            switch (columnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (baseRegisterInfo.getDemoRegValue() == -1 || baseRegisterInfo.getDemoRegValue() == baseRegisterInfo.getRegValue()) break;
                    return Display.getDefault().getSystemColor(7);
                }
                case 3: {
                    if (baseRegisterInfo.getDemoRegDelay() == -1 || baseRegisterInfo.getDemoRegDelay() == baseRegisterInfo.getRegDelay()) break;
                    return Display.getDefault().getSystemColor(7);
                }
                case 4: {
                    if (baseRegisterInfo.getDemoRegReadOrWrite() == RegBinAction.INVALID || baseRegisterInfo.getDemoRegReadOrWrite() == baseRegisterInfo.getRegReadOrWrite()) break;
                    return Display.getDefault().getSystemColor(7);
                }
                case 5: {
                    if (baseRegisterInfo.getDemoRegBit() == -1 || baseRegisterInfo.getDemoRegBit() == baseRegisterInfo.getRegBit()) break;
                    return Display.getDefault().getSystemColor(7);
                }
                case 6: {
                    if (baseRegisterInfo.getDemoRegStartBit() == -1 || baseRegisterInfo.getDemoRegStartBit() == baseRegisterInfo.getRegStartBit()) break;
                    return Display.getDefault().getSystemColor(7);
                }
            }
            return Display.getDefault().getSystemColor(1);
        }
    }
}

