/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.ui;

import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.model.reg.DemoBaseParam;
import com.hisilicon.hiregbin.model.reg.ParsedMainData;
import com.hisilicon.hiregbin.ui.AbstractBaseComposite;
import com.hisilicon.hiregbin.utility.ExcelDataHelper;
import com.hisilicon.hiregbin.utility.LayoutUtils;
import com.hisilicon.hiregbin.views.RegbinView;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DemoTypeSelectDialog
extends Dialog {
    private ParsedMainData parsedMainData;
    private Combo comboDemoName;
    private Label labDemoName;
    private String selectDemoName;
    private String demoName;
    private String customAddStr;
    private String customDemoName;

    public DemoTypeSelectDialog(Shell parentShell, ParsedMainData parsedMainData, String customAddStr, String customDemoName, String selectDemoName) {
        super(parentShell);
        this.parsedMainData = parsedMainData;
        this.customAddStr = customAddStr;
        this.customDemoName = customDemoName;
        this.selectDemoName = selectDemoName;
    }

    protected Control createContents(Composite parent) {
        parent.getShell().setText(Messages.PanelComposite_Select_DemoType);
        parent.setSize(535, 205);
        parent.setLayout((Layout)new GridLayout(1, false));
        LayoutUtils.centerShell(parent.getDisplay(), parent.getShell());
        String[] demoNames = this.initDemoName(this.parsedMainData);
        if (this.selectDemoName == null) {
            this.selectDemoName = demoNames[0];
        }
        Composite compositeDemo = new Composite(parent, 0);
        compositeDemo.setLayout((Layout)new GridLayout(2, false));
        compositeDemo.setLayoutData((Object)new GridData(1808));
        Label labDemoType = new Label(compositeDemo, 0);
        labDemoType.setText(Messages.PanelComposite_DemoType);
        GridData labDemoTypeGD = new GridData();
        labDemoTypeGD.horizontalIndent = 0;
        labDemoType.setLayoutData((Object)labDemoTypeGD);
        this.comboDemoName = new Combo(compositeDemo, 8);
        this.comboDemoName.setItems(demoNames);
        int i = 0;
        while (i < demoNames.length) {
            String demoName = demoNames[i];
            if (this.selectDemoName.equalsIgnoreCase(demoName)) {
                this.comboDemoName.select(i);
                break;
            }
            ++i;
        }
        AbstractBaseComposite.changeControlListener((Control)this.comboDemoName);
        this.comboDemoName.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = DemoTypeSelectDialog.this.comboDemoName.getSelectionIndex();
                DemoTypeSelectDialog.this.selectDemoName = demoNames[selectionIndex];
                String tableName = DemoTypeSelectDialog.handleTableName(DemoTypeSelectDialog.this.parsedMainData, DemoTypeSelectDialog.this.selectDemoName, true, null, null);
                DemoTypeSelectDialog.this.labDemoName.setText(DemoTypeSelectDialog.handleTableName(DemoTypeSelectDialog.this.parsedMainData, DemoTypeSelectDialog.this.selectDemoName, false, null, null));
                if (DemoTypeSelectDialog.this.customAddStr != null && !DemoTypeSelectDialog.this.customAddStr.isEmpty()) {
                    DemoTypeSelectDialog.this.customDemoName = String.valueOf(tableName) + "_" + DemoTypeSelectDialog.this.customAddStr;
                } else {
                    DemoTypeSelectDialog.this.customDemoName = tableName;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label labDemoTable = new Label(compositeDemo, 0);
        labDemoTable.setText(Messages.PanelComposite_DemoRegTableName);
        GridData labDemoTableGD = new GridData();
        labDemoTableGD.horizontalIndent = 0;
        labDemoTable.setLayoutData((Object)labDemoTableGD);
        this.labDemoName = new Label(compositeDemo, 0);
        this.demoName = DemoTypeSelectDialog.handleTableName(this.parsedMainData, this.selectDemoName, false, null, null);
        this.labDemoName.setText(this.demoName);
        GridData labDemoNameGD = new GridData(4, 1, true, false);
        labDemoNameGD.horizontalIndent = 0;
        this.labDemoName.setLayoutData((Object)labDemoNameGD);
        return super.createContents(parent);
    }

    private String[] initDemoName(ParsedMainData parsedMainData) {
        if (parsedMainData == null) {
            return null;
        }
        ArrayList<DemoBaseParam> chipBaseParamList = parsedMainData.getDemoList();
        int demoSize = chipBaseParamList.size();
        String[] demoNames = new String[demoSize];
        int i = 0;
        while (i < demoSize) {
            demoNames[i] = chipBaseParamList.get(i).getDemoName();
            ++i;
        }
        return demoNames;
    }

    public static String handleTableName(ParsedMainData parsedMainData, String demoName, boolean isNeedDemoName, String selectddrCapacity, String selectDdrType) {
        StringBuilder result = new StringBuilder();
        if (parsedMainData == null) {
            return null;
        }
        ArrayList<DemoBaseParam> chipBaseParamList = parsedMainData.getDemoList();
        for (DemoBaseParam demoBaseParam : chipBaseParamList) {
            if (!demoName.equalsIgnoreCase(demoBaseParam.getDemoName())) continue;
            String ddrBuswidth = demoBaseParam.getDdrBuswidth();
            String ddrPCBLayers = demoBaseParam.getDdrPCBLayers();
            String demoType = null;
            if (selectDdrType == null) {
                demoType = demoBaseParam.getDemoType();
                if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData())) {
                    demoType = demoBaseParam.getDdrType();
                }
            } else {
                demoType = selectDdrType;
            }
            String ddrCapacity = selectddrCapacity == null ? demoBaseParam.getDdrCapacity() : selectddrCapacity;
            String startup = demoBaseParam.getStartup();
            String chipName = demoBaseParam.getChipName();
            if (chipName.isEmpty()) {
                chipName = demoName.substring(0, 7);
            }
            if (isNeedDemoName) {
                result.append(demoName).append("_");
            }
            result.append(demoName).append("_");
            result.append(chipName).append("_");
            if (selectDdrType == null) {
                result.append(demoType).append("_");
            }
            if (ExcelDataHelper.isV135XlsFomatVersion(ExcelDataHelper.getExcelData())) {
                String curDdrPhy = demoBaseParam.getDdrPhy();
                Map<String, String> map = demoBaseParam.getDynamicParamMap();
                for (Map.Entry<String, String> entity : map.entrySet()) {
                    String phyChannel;
                    String keyChannel;
                    String key = entity.getKey();
                    if (key.indexOf("_") == -1 || curDdrPhy.indexOf("_") == -1 || !(keyChannel = key.substring(key.indexOf("_") + "_".length())).equalsIgnoreCase(phyChannel = curDdrPhy.substring(curDdrPhy.indexOf("_") + "_".length()))) continue;
                    String curDdrCapacity = entity.getValue();
                    String curDdrCapacityInfo = String.valueOf(phyChannel) + curDdrCapacity;
                    result.append(curDdrCapacityInfo).append("_");
                    break;
                }
            } else {
                result.append(ddrCapacity).append("_");
            }
            if (selectDdrType != null) {
                result.append(demoType).append("_");
            }
            result.append(ddrBuswidth).append("_");
            result.append(ddrPCBLayers);
            if (RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV410") || RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV420")) {
                result.append("_");
                result.append(startup);
            }
            return result.toString();
        }
        return result.toString();
    }

    public String getCustomAddStr() {
        return this.customAddStr;
    }

    public void setCustomAddStr(String customAddStr) {
        this.customAddStr = customAddStr;
    }

    public String getCustomDemoName() {
        return this.customDemoName;
    }

    public void setCustomDemoName(String customDemoName) {
        this.customDemoName = customDemoName;
    }

    public String getSelectDemoName() {
        return this.selectDemoName;
    }

    static /* synthetic */ Combo access$0(DemoTypeSelectDialog demoTypeSelectDialog) {
        return demoTypeSelectDialog.comboDemoName;
    }

    static /* synthetic */ void access$1(DemoTypeSelectDialog demoTypeSelectDialog, String string) {
        demoTypeSelectDialog.selectDemoName = string;
    }

    static /* synthetic */ ParsedMainData access$2(DemoTypeSelectDialog demoTypeSelectDialog) {
        return demoTypeSelectDialog.parsedMainData;
    }

    static /* synthetic */ String access$3(DemoTypeSelectDialog demoTypeSelectDialog) {
        return demoTypeSelectDialog.selectDemoName;
    }

    static /* synthetic */ Label access$4(DemoTypeSelectDialog demoTypeSelectDialog) {
        return demoTypeSelectDialog.labDemoName;
    }

    static /* synthetic */ String access$5(DemoTypeSelectDialog demoTypeSelectDialog) {
        return demoTypeSelectDialog.customAddStr;
    }

    static /* synthetic */ void access$6(DemoTypeSelectDialog demoTypeSelectDialog, String string) {
        demoTypeSelectDialog.customDemoName = string;
    }
}

