/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.processor;

import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.model.BaseParam;
import com.hisilicon.hiregbin.model.GlobleInfo;
import com.hisilicon.hiregbin.model.PinDemuxHead;
import com.hisilicon.hiregbin.model.Setting;
import com.hisilicon.hiregbin.model.reg.BaseRegisterInfo;
import com.hisilicon.hiregbin.model.reg.CAConfig;
import com.hisilicon.hiregbin.model.reg.DriectionConfig;
import com.hisilicon.hiregbin.model.reg.GpioData;
import com.hisilicon.hiregbin.model.reg.LevelConfig;
import com.hisilicon.hiregbin.model.reg.ParsedMainData;
import com.hisilicon.hiregbin.model.reg.PinDemuxInfo;
import com.hisilicon.hiregbin.model.reg.PinDemuxRegisterInfo;
import com.hisilicon.hiregbin.model.reg.bin.RegBinAction;
import com.hisilicon.hiregbin.model.reg.bin.RegBinData;
import com.hisilicon.hiregbin.model.reg.bin.RegBinItem;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinCommand;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinData;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinItem;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinModule;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinType;
import com.hisilicon.hiregbin.model.reg.excel.ExcelData;
import com.hisilicon.hiregbin.model.reg.excel.ExcelDefinition;
import com.hisilicon.hiregbin.model.reg.excel.ExcelMainData;
import com.hisilicon.hiregbin.model.reg.excel.ExcelWorkbookInfo;
import com.hisilicon.hiregbin.model.reg.excel.MainDdrParam;
import com.hisilicon.hiregbin.model.reg.excel.MainDdrPhy;
import com.hisilicon.hiregbin.model.reg.excel.MainDdrType;
import com.hisilicon.hiregbin.model.reg.excel.MainModelParam;
import com.hisilicon.hiregbin.model.reg.excel.MainNetconfig;
import com.hisilicon.hiregbin.model.reg.excel.MainRegInfo;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinHeadData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinItem;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModule;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModuleHead;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModuleType;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinTable;
import com.hisilicon.hiregbin.ui.AbstractBaseComposite;
import com.hisilicon.hiregbin.utility.BitUtils;
import com.hisilicon.hiregbin.utility.ConvertUtils;
import com.hisilicon.hiregbin.utility.ExcelDataHelper;
import com.hisilicon.hiregbin.utility.ExcelStyleUtils;
import com.hisilicon.hiregbin.utility.FileUtils;
import com.hisilicon.hiregbin.utility.HiToolUtils;
import com.hisilicon.hiregbin.utility.TextReader;
import com.hisilicon.hiregbin.views.RegbinView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrepareSetting
implements Setting {
    private Object paramObj;
    private int lastBaseStartupAddr = 0;
    private int lastBaseCommonAddr = 0;
    private int lastBaseFpPinMuxAddr = 0;
    private int binStartupTableRegLen = 0;
    private int binCommonTableRegLen = 0;
    private int binFpPinMuxTableRegLen = 0;
    private static final int[] GPIOVALUES = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private BinModule binPinMuxStartupModule = null;
    private BinTable binStartupTable = null;
    private BinModule binPinMuxCommonModule = null;
    private BinTable binCommonTable = null;
    private BinModule binFpPinMuxModule = null;
    private BinTable binFpPinMuxTable = null;

    public PrepareSetting(Object paramObj) {
        this.paramObj = paramObj;
    }

    public Object getParamObj() {
        return this.paramObj;
    }

    public void setParamObj(Object paramObj) {
        this.paramObj = paramObj;
    }

    @Override
    public IStatus checkInfo() {
        return null;
    }

    @Override
    public IStatus create(File file) {
        return null;
    }

    public IStatus makeRegBin(String filePath, ExcelData excelData, String regName) throws IOException {
        if (excelData == null) {
            excelData = ExcelDataHelper.getExcelData();
        }
        if (this.paramObj instanceof BaseParam) {
            File logFile = this.createLogFile(filePath);
            BaseParam baseParam = (BaseParam)this.paramObj;
            CAConfig selectCA = baseParam.getSelectCA();
            String selectDemoName = baseParam.getSelectDemoName();
            Map<String, String> selectDdrParamValueMap = baseParam.getSelectDdrParamValueMap();
            Map<String, String> selectMacValueList = baseParam.getSelectMacValueMap();
            Map<String, String> selectPhyAddrValueMap = baseParam.getSelectPhyAddrValueMap();
            Map<String, String> selectGpioGroupNumValueMap = baseParam.getSelectGpioGroupNumValueMap();
            Map<String, String> selectGpioBitsValueMap = baseParam.getSelectGpioBitsValueMap();
            PinDemuxInfo pinDemuxInfo = baseParam.getPinDemuxInfo();
            String tableVersion = baseParam.getTableVersion();
            RegBinData regBinData = new RegBinData();
            String currentTime = ConvertUtils.getCurrentTime();
            regBinData.setmName(regName);
            regBinData.setmTime(currentTime);
            regBinData.setmSubVersion(tableVersion);
            ExcelMainData excelMainData = excelData.getExcelMainData();
            ArrayList<ExcelWorkbookInfo> excelWorkbookInfoList = excelData.getExcelWorkbookInfoList();
            ArrayList<MainDdrParam> mainDdrParamList = excelMainData.getMainDdrParamList();
            ArrayList<MainNetconfig> mainNetconfigList = excelMainData.getMainNetconfigList();
            ArrayList<MainModelParam> mainModelParamList = excelMainData.getMainModelParamList();
            boolean isStartWritePinMuxData = false;
            int workbookIndex = 0;
            while (workbookIndex < excelWorkbookInfoList.size()) {
                ExcelWorkbookInfo excelWorkbookInfo = excelWorkbookInfoList.get(workbookIndex);
                String workbookName = excelWorkbookInfo.getWorkbookName();
                if (this.filterCAorNoCAWookbook(workbookName, selectCA = CAConfig.noCA) && this.filterDemoNameWookbook(workbookName, selectDemoName, baseParam)) {
                    if (workbookName.contains("pin_mux_drv") || workbookName.contains("fp_pin_mux_drv")) {
                        isStartWritePinMuxData = true;
                    } else {
                        if (isStartWritePinMuxData) {
                            this.writePinMuxToRegBin(pinDemuxInfo, regBinData, logFile);
                            isStartWritePinMuxData = false;
                        }
                        System.out.println(workbookName);
                        boolean exeForStandyWakeup = excelWorkbookInfo.isExeForStandyWakeup();
                        boolean exeForNormalBoot = excelWorkbookInfo.isExeForNormalBoot();
                        int baseAddress = excelWorkbookInfo.getBaseAddress();
                        ArrayList<BaseRegisterInfo> baseResiterInfoList = excelWorkbookInfo.getBaseRegisterInfoList();
                        int regIndex = 0;
                        while (regIndex < baseResiterInfoList.size()) {
                            RegBinAction regReadOrWrite;
                            BaseRegisterInfo baseRegsiterInfo = baseResiterInfoList.get(regIndex);
                            boolean filterSelectDdrParamResult = false;
                            int paramIndex = 0;
                            while (paramIndex < mainDdrParamList.size()) {
                                MainDdrParam mainDdrParam = mainDdrParamList.get(paramIndex);
                                filterSelectDdrParamResult = this.filterSelectDdrParam(workbookName, baseRegsiterInfo, mainDdrParamList, selectDdrParamValueMap, mainDdrParam);
                                if (filterSelectDdrParamResult) break;
                                ++paramIndex;
                            }
                            if (!filterSelectDdrParamResult && !this.filterEthPhyCfgInfo(workbookName, baseRegsiterInfo, selectMacValueList, mainNetconfigList, mainModelParamList, selectPhyAddrValueMap, selectGpioGroupNumValueMap, selectGpioBitsValueMap) && (regReadOrWrite = baseRegsiterInfo.getRegReadOrWrite()) != RegBinAction.NONE) {
                                RegBinItem regBinItem = this.createRegBinItem(baseRegsiterInfo, baseAddress, exeForNormalBoot, exeForStandyWakeup);
                                this.outputDebugRegBinInfo(excelWorkbookInfo, baseRegsiterInfo, regBinItem, logFile, regIndex);
                                regBinData.addItem(regBinItem);
                            }
                            ++regIndex;
                        }
                    }
                }
                ++workbookIndex;
            }
            if (isStartWritePinMuxData) {
                this.writePinMuxToRegBin(pinDemuxInfo, regBinData, logFile);
                isStartWritePinMuxData = false;
            }
            if (regBinData.toFile(filePath)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private File createLogFile(String filePath) throws IOException {
        File HiRegBinDirectory;
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + File.separator.length());
        File logFile = null;
        String hiToolPath = HiToolUtils.getInstallPath();
        File logsDirectory = new File(String.valueOf(hiToolPath) + File.separator + "logs");
        if (!logsDirectory.exists()) {
            boolean bl = logsDirectory.mkdir();
        }
        if (!(HiRegBinDirectory = new File(String.valueOf(logsDirectory.getPath()) + File.separator + "HiRegBin")).exists()) {
            boolean bl = HiRegBinDirectory.mkdir();
        }
        if (!(logFile = new File(String.valueOf(HiRegBinDirectory.getPath()) + File.separator + fileName + ".log")).exists()) {
            FileUtils.createFile(logFile);
        } else {
            FileUtils.deleteFile(logFile);
        }
        return logFile;
    }

    private void writePinMuxToCfgBin(CfgBinData cfgBinData, PinDemuxInfo pinDemuxInfo, File logFile) {
        this.addPinMuxDataToCfgbin(cfgBinData, pinDemuxInfo, logFile);
        Map<String, GpioData> gpioMap = pinDemuxInfo.getGpioMap();
        Collection<GpioData> values = gpioMap.values();
        int regBit = 7;
        int regStartBit = 0;
        int regDelay = 0;
        RegBinAction regReadOrWrite = GpioData.GPIO_READ_OR_WRITE;
        CfgBinModule cfgBinGpioModule = new CfgBinModule();
        for (GpioData gpioData : values) {
            String gpioName = gpioData.getGpioName();
            DriectionConfig gpioDirection = gpioData.getGpioDirection();
            LevelConfig gpioLevel = gpioData.getGpioLevel();
            int gpioGroupAddress = gpioData.getGpioGroupAddress();
            if (gpioDirection == DriectionConfig.Input) continue;
            PinDemuxHead pinDemuxHead = gpioData.getPinDemuxHead();
            boolean exeForNormalBoot = pinDemuxHead.isExeForNormalBoot();
            boolean exeForStandyWakeup = pinDemuxHead.isExeForStandyWakeup();
            CfgBinType mType = this.handleCfgBinType(exeForStandyWakeup, exeForNormalBoot);
            cfgBinGpioModule.setType(mType);
            cfgBinGpioModule.setBaseAddr(0);
            CfgBinItem cfgBinDirectionItemData = new CfgBinItem(cfgBinGpioModule);
            cfgBinDirectionItemData.setDelay(regDelay);
            int gpioDirectionValue = gpioDirection.ordinal();
            cfgBinDirectionItemData.setValue(gpioDirectionValue);
            int gpioDirectionAbsoluteAddr = gpioGroupAddress + 1024;
            cfgBinDirectionItemData.setAddress(gpioDirectionAbsoluteAddr);
            int mValueMask = BitUtils.getMask(regStartBit, regStartBit + regBit);
            cfgBinDirectionItemData.setValueMask(mValueMask);
            if (regReadOrWrite == RegBinAction.NONE) continue;
            CfgBinCommand mCmd = this.handleCfgBinCmd(regBit, regReadOrWrite);
            cfgBinDirectionItemData.setCmd(mCmd);
            cfgBinGpioModule.addItem(cfgBinDirectionItemData);
            CfgBinItem cfgBinDataItemData = new CfgBinItem(cfgBinGpioModule);
            int gpioLevelValue = gpioLevel.ordinal();
            cfgBinDataItemData.setValue(gpioLevelValue);
            cfgBinDataItemData.setDelay(regDelay);
            String gpioDataNumStr = "GPIOX_" + gpioName.substring(gpioName.lastIndexOf("_") + "_".length());
            int gpioDataValue = GlobleInfo.getGpioXDataMap().get(gpioDataNumStr);
            int gpioDataAbsoluteAddr = gpioGroupAddress + gpioDataValue;
            cfgBinDataItemData.setAddress(gpioDataAbsoluteAddr);
            cfgBinDataItemData.setValueMask(mValueMask);
            cfgBinDataItemData.setCmd(mCmd);
            cfgBinGpioModule.addItem(cfgBinDataItemData);
        }
        if (cfgBinGpioModule.getItemCount() > 0) {
            cfgBinData.addModule(cfgBinGpioModule);
        }
    }

    private void writePinMuxTo98cv200Bin(BinData binData, PinDemuxInfo pinDemuxInfo, String startup) {
        this.addPinMuxDataTo98cv200bin(binData, pinDemuxInfo, startup);
        Map<String, GpioData> gpioMap = pinDemuxInfo.getGpioMap();
        RegBinAction regReadOrWrite = GpioData.GPIO_READ_OR_WRITE;
        ArrayList<GpioData> spiList = new ArrayList<GpioData>();
        ArrayList<GpioData> nandList = new ArrayList<GpioData>();
        ArrayList<GpioData> emmcList = new ArrayList<GpioData>();
        ArrayList<GpioData> sdList = new ArrayList<GpioData>();
        ArrayList<GpioData> nomalList = new ArrayList<GpioData>();
        ArrayList<GpioData> embednyList = new ArrayList<GpioData>();
        ArrayList<GpioData> embedwbList = new ArrayList<GpioData>();
        ArrayList<GpioData> aonList = new ArrayList<GpioData>();
        TextReader.addSecion("GPIO");
        ArrayList<Map.Entry<String, GpioData>> list = new ArrayList<Map.Entry<String, GpioData>>(gpioMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, GpioData>>(){

            @Override
            public int compare(Map.Entry<String, GpioData> o1, Map.Entry<String, GpioData> o2) {
                return o2.getKey().compareTo(o1.getKey());
            }
        });
        for (Map.Entry entry : list) {
            GpioData gpioData = (GpioData)entry.getValue();
            DriectionConfig gpioDirection = gpioData.getGpioDirection();
            if (gpioDirection == DriectionConfig.Input || regReadOrWrite == RegBinAction.NONE) continue;
            BinModuleType pinModuleType = gpioData.getPinDemuxHead().getPinModuleType();
            if (pinModuleType == BinModuleType.SPI) {
                spiList.add(gpioData);
                continue;
            }
            if (pinModuleType == BinModuleType.NAND) {
                nandList.add(gpioData);
                continue;
            }
            if (pinModuleType == BinModuleType.EMMC) {
                emmcList.add(gpioData);
                continue;
            }
            if (pinModuleType == BinModuleType.SD) {
                sdList.add(gpioData);
                continue;
            }
            if (pinModuleType == BinModuleType.NORMAL) {
                nomalList.add(gpioData);
                continue;
            }
            if (pinModuleType == BinModuleType.EMBEDNY) {
                embednyList.add(gpioData);
                continue;
            }
            if (pinModuleType == BinModuleType.EMBEDWB) {
                embedwbList.add(gpioData);
                continue;
            }
            if (pinModuleType != BinModuleType.EMMCPHY) continue;
            aonList.add(gpioData);
        }
        this.writeOutGpio(binData, spiList, regReadOrWrite);
        this.writeOutGpio(binData, nandList, regReadOrWrite);
        this.writeOutGpio(binData, emmcList, regReadOrWrite);
        this.writeOutGpio(binData, sdList, regReadOrWrite);
        this.writeOutGpio(binData, nomalList, regReadOrWrite);
        this.writeOutGpio(binData, embednyList, regReadOrWrite);
        this.writeOutGpio(binData, embedwbList, regReadOrWrite);
        this.writeOutGpio(binData, aonList, regReadOrWrite);
        this.printPinmuxInfo(binData.getmListModules());
    }

    private void printPinmuxInfo(ArrayList<BinModule> listModules) {
        for (BinModule binModule : listModules) {
            for (BinTable binTable : binModule.getBinTableList()) {
                for (BinItem binItem : binTable.getTableBinItemList()) {
                    this.printRegInfo("PINMUX", binItem.getWriteOrRead().ordinal(), binModule.getBaseAddr(), binItem.getOffsetAddress(), binItem.getBits(), binItem.getValue(), binItem.getDelay());
                }
            }
        }
    }

    private void writeOutGpio(BinData binData, List<GpioData> list, RegBinAction regReadOrWrite) {
        if (list != null && list.size() > 0) {
            BinModule binGpioModule = new BinModule();
            BinTable binDriectionTable = null;
            int lastDirectionTableAddress = 0;
            int tableDirectionRegLen = 0;
            BinTable binDataTable = null;
            int lastDataTableAddress = 0;
            int tableDataRegLen = 0;
            for (GpioData gpioData : list) {
                String gpioBitNumStr;
                int gpioDirectionAbsoluteAddr;
                int gpioDirectionTableAddress;
                String gpioID = gpioData.getGpioID();
                String gpioName = gpioData.getGpioName();
                DriectionConfig gpioDirection = gpioData.getGpioDirection();
                LevelConfig gpioLevel = gpioData.getGpioLevel();
                int gpioGroupAddress = gpioData.getGpioGroupAddress();
                if (gpioDirection == DriectionConfig.Input || regReadOrWrite == RegBinAction.NONE) continue;
                PinDemuxHead pinDemuxHead = gpioData.getPinDemuxHead();
                TextReader.addParam("GPIO", gpioID, gpioLevel.name());
                if (binGpioModule.getBinModuleHead() == null) {
                    BinModuleType pinModuleType = pinDemuxHead.getPinModuleType();
                    boolean exeForNormalBoot = pinDemuxHead.isExeForNormalBoot();
                    boolean exeForStandyWakeup = pinDemuxHead.isExeForStandyWakeup();
                    boolean pinNormalChip = pinDemuxHead.isPinNormalChip();
                    boolean pinCaChip = pinDemuxHead.isPinCaChip();
                    BinModuleHead binModuleHead = new BinModuleHead(pinModuleType, PrepareSetting.convertBoolToInt(exeForNormalBoot), PrepareSetting.convertBoolToInt(exeForStandyWakeup), PrepareSetting.convertBoolToInt(pinNormalChip), PrepareSetting.convertBoolToInt(pinCaChip));
                    binGpioModule.setBinModuleHead(binModuleHead);
                    binGpioModule.setBaseAddr(0);
                }
                if (binDriectionTable == null) {
                    binDriectionTable = new BinTable();
                }
                if (lastDirectionTableAddress != (gpioDirectionTableAddress = binDriectionTable.calculateTableAddress(gpioDirectionAbsoluteAddr = gpioGroupAddress + 1024))) {
                    if (!binGpioModule.isExistBinTableList(binDriectionTable) && binDriectionTable.getTableBinItemList().size() > 0) {
                        binGpioModule.addTableToModule(binDriectionTable);
                    }
                    binDriectionTable = new BinTable();
                    tableDirectionRegLen = 0;
                    binDriectionTable.setTableAddress(gpioDirectionTableAddress);
                }
                if ((gpioBitNumStr = gpioName.substring(gpioName.lastIndexOf("_") + "_".length())) != null && gpioBitNumStr.toUpperCase().contains("AON")) {
                    gpioBitNumStr = gpioBitNumStr.substring("AON".length());
                }
                int startBit = 0;
                try {
                    startBit = Integer.parseInt(gpioBitNumStr);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                int bits = 0;
                BinItem binDirectionItem = new BinItem();
                binDirectionItem.setDelay(0);
                int gpioDirectionValue = gpioDirection.ordinal();
                binDirectionItem.setValue(gpioDirectionValue);
                binDirectionItem.setOffsetAddress(binDirectionItem.calculateOffsetAddress(gpioDirectionAbsoluteAddr));
                binDirectionItem.setmModuleRef(binGpioModule);
                binDirectionItem.setmTableRef(binDriectionTable);
                binDirectionItem.setStartBit(startBit);
                binDirectionItem.setBits(bits);
                binDirectionItem.setWriteOrRead(regReadOrWrite);
                binDriectionTable.setTableRegTotalLength(tableDirectionRegLen += binDirectionItem.getBytesSize());
                binDriectionTable.addBinItemToList(binDirectionItem);
                lastDirectionTableAddress = gpioDirectionTableAddress;
                if (binDriectionTable != null && !binGpioModule.isExistBinTableList(binDriectionTable) && binDriectionTable.getTableBinItemList().size() > 0) {
                    binGpioModule.addTableToModule(binDriectionTable);
                }
                if (binDataTable == null) {
                    binDataTable = new BinTable();
                }
                String gpioDataNumStr = "GPIOX_" + gpioBitNumStr;
                int gpioDataValue = GlobleInfo.getGpioXDataMap().get(gpioDataNumStr);
                int gpioDataAbsoluteAddr = gpioGroupAddress + gpioDataValue;
                int gpioDataTableAddress = binDataTable.calculateTableAddress(gpioDataAbsoluteAddr);
                if (lastDataTableAddress != gpioDataTableAddress) {
                    if (!binGpioModule.isExistBinTableList(binDataTable) && binDataTable.getTableBinItemList().size() > 0) {
                        binGpioModule.addTableToModule(binDataTable);
                    }
                    binDataTable = new BinTable();
                    tableDataRegLen = 0;
                    binDataTable.setTableAddress(gpioDataTableAddress);
                }
                BinItem binDataItem = new BinItem();
                int gpioLevelValue = gpioLevel.ordinal();
                int itemOffersetAddress = binDataItem.calculateOffsetAddress(gpioDataAbsoluteAddr);
                binDataItem.setValue(gpioLevelValue);
                binDataItem.setDelay(0);
                binDataItem.setOffsetAddress(itemOffersetAddress);
                binDataItem.setmModuleRef(binGpioModule);
                binDataItem.setmTableRef(binDataTable);
                binDataItem.setStartBit(startBit);
                binDataItem.setBits(bits);
                binDataItem.setWriteOrRead(regReadOrWrite);
                binDataTable.setTableRegTotalLength(tableDataRegLen += binDataItem.getBytesSize());
                binDataTable.addBinItemToList(binDataItem);
                lastDataTableAddress = gpioDataTableAddress;
                if (binDataTable == null || binGpioModule.isExistBinTableList(binDataTable) || binDataTable.getTableBinItemList().size() <= 0) continue;
                binGpioModule.addTableToModule(binDataTable);
            }
            if (!binData.isExistModuleList(binGpioModule) && binGpioModule.getTableCount() > 0) {
                binData.addModule(binGpioModule);
            }
        }
    }

    private void writePinMuxToRegBin(PinDemuxInfo pinDemuxInfo, RegBinData regBinData, File logFile) {
        this.addPinMuxDataToRegbin(pinDemuxInfo, regBinData, logFile);
        Map<String, GpioData> gpioMap = pinDemuxInfo.getGpioMap();
        Collection<GpioData> values = gpioMap.values();
        for (GpioData gpioData : values) {
            String gpioName = gpioData.getGpioName();
            DriectionConfig gpioDirection = gpioData.getGpioDirection();
            LevelConfig gpioLevel = gpioData.getGpioLevel();
            int gpioGroupAddress = gpioData.getGpioGroupAddress();
            if (gpioDirection == DriectionConfig.Input) continue;
            int gpioDirectionAbsoluteAddr = gpioGroupAddress + 1024;
            RegBinItem regBinDirectionItem = new RegBinItem();
            regBinDirectionItem.setValue(DriectionConfig.Output.ordinal());
            regBinDirectionItem.setAddress(gpioDirectionAbsoluteAddr);
            regBinDirectionItem.setDelay(0);
            PinDemuxHead pinDemuxHead = gpioData.getPinDemuxHead();
            boolean exeForNormalBoot = pinDemuxHead.isExeForNormalBoot();
            boolean exeForStandyWakeup = pinDemuxHead.isExeForStandyWakeup();
            this.handleAttributeValue(exeForNormalBoot, exeForStandyWakeup, 7, 0, GpioData.GPIO_READ_OR_WRITE, regBinDirectionItem);
            regBinData.addItem(regBinDirectionItem);
            RegBinItem regBinDataItem = new RegBinItem();
            String gpio_number = gpioName.substring(gpioName.lastIndexOf("_") + "_".length());
            String gpioDataNumStr = "GPIOX_" + gpio_number;
            int gpioDataValue = GlobleInfo.getGpioXDataMap().get(gpioDataNumStr);
            int gpioDataAbsoluteAddr = gpioGroupAddress + gpioDataValue;
            regBinDataItem.setAddress(gpioDataAbsoluteAddr);
            int gpioLevelValue = gpioLevel.ordinal();
            regBinDataItem.setValue(this.getGpioValue(gpioLevelValue, gpio_number));
            regBinDataItem.setDelay(0);
            this.handleAttributeValue(exeForNormalBoot, exeForStandyWakeup, 7, 0, GpioData.GPIO_READ_OR_WRITE, regBinDirectionItem);
            regBinData.addItem(regBinDataItem);
        }
    }

    private int getGpioValue(int gpioLevelValue, String gpio_number) {
        if (gpioLevelValue == 0) {
            return gpioLevelValue;
        }
        try {
            int number = Integer.parseInt(gpio_number);
            int i = 0;
            while (i < GPIOVALUES.length) {
                if (i == number) {
                    return GPIOVALUES[i];
                }
                ++i;
            }
        }
        catch (NumberFormatException number) {
            number.printStackTrace();
        }
        return 1;
    }

    private void addPinMuxDataToCfgbin(CfgBinData cfgBinData, PinDemuxInfo pinDemuxInfo, File logFile) {
        CfgBinModule cfgBinPinMuxModule = new CfgBinModule();
        CfgBinModule cfgBinFpPinMuxModule = new CfgBinModule();
        ArrayList<PinDemuxRegisterInfo> pinDemuxRegsiterList = pinDemuxInfo.getPinDemuxRegisterList();
        int index = 0;
        while (index < pinDemuxRegsiterList.size()) {
            PinDemuxRegisterInfo pinDemuxRegsiterInfo = pinDemuxRegsiterList.get(index);
            RegBinAction regReadOrWrite = pinDemuxRegsiterInfo.getRegReadOrWrite();
            if (regReadOrWrite != RegBinAction.NONE) {
                String pinMuxModuleName = pinDemuxRegsiterInfo.getPinDemuxHead().getPinMuxModuleName();
                if (pinMuxModuleName.startsWith("pin_mux_drv")) {
                    this.createPinMuxCfgBin(cfgBinPinMuxModule, pinDemuxRegsiterInfo, logFile, index);
                }
                if (pinMuxModuleName.equalsIgnoreCase("fp_pin_mux_drv")) {
                    this.createPinMuxCfgBin(cfgBinFpPinMuxModule, pinDemuxRegsiterInfo, logFile, index);
                }
            }
            ++index;
        }
        if (cfgBinPinMuxModule.getItemCount() > 0) {
            cfgBinData.addModule(cfgBinPinMuxModule);
        }
        if (cfgBinFpPinMuxModule.getItemCount() > 0) {
            cfgBinData.addModule(cfgBinFpPinMuxModule);
        }
    }

    private void addPinMuxDataTo98cv200bin(BinData binData, PinDemuxInfo pinDemuxInfo, String startMode) {
        String pinMuxModuleName;
        RegBinAction regReadOrWrite;
        String pinMuxFunction;
        String pinMuxRegName;
        PinDemuxRegisterInfo pinDemuxRegsiterInfo;
        ArrayList<PinDemuxRegisterInfo> pinDemuxRegStartupList;
        Map<String, ArrayList<PinDemuxRegisterInfo>> pinDemuxForFlashMap = pinDemuxInfo.getPinDemuxForFlashMap();
        ParsedMainData parsedMainData = ExcelDataHelper.getParsedMainData();
        if (parsedMainData != null) {
            ArrayList<String> startupList = null;
            if (RegbinView.isHi3716V550Series()) {
                startupList = new ArrayList();
                startupList.add(startMode);
            } else {
                startupList = parsedMainData.getStartupList();
            }
            for (String startup : startupList) {
                if (!pinDemuxForFlashMap.containsKey(startup)) continue;
                this.createPinBinTable(pinDemuxForFlashMap, startup);
                if (binData.isExistModuleList(this.binPinMuxStartupModule) || this.binPinMuxStartupModule.getTableCount() <= 0) continue;
                binData.addModule(this.binPinMuxStartupModule);
            }
        }
        if (pinDemuxForFlashMap.containsKey("pin_mux_drv_aon")) {
            pinDemuxRegStartupList = pinDemuxForFlashMap.get("pin_mux_drv_aon");
            TextReader.addSecion("pin_mux_drv_aon");
            this.binPinMuxCommonModule = new BinModule();
            this.binCommonTable = new BinTable();
            this.lastBaseCommonAddr = 0;
            this.binCommonTableRegLen = 0;
            int index = 0;
            while (index < pinDemuxRegStartupList.size()) {
                pinDemuxRegsiterInfo = pinDemuxRegStartupList.get(index);
                pinMuxRegName = pinDemuxRegsiterInfo.getPinMuxRegName();
                pinMuxFunction = pinDemuxRegsiterInfo.getPinMuxFunction();
                if (pinMuxRegName.equalsIgnoreCase("ioshare_55") || pinMuxRegName.equalsIgnoreCase("ioshare_56")) {
                    System.out.println(pinMuxFunction);
                    System.out.println(pinDemuxRegsiterInfo.getPinMuxValue());
                }
                TextReader.addParam("pin_mux_drv_aon", pinMuxRegName, pinMuxFunction);
                regReadOrWrite = pinDemuxRegsiterInfo.getRegReadOrWrite();
                if (regReadOrWrite != RegBinAction.NONE && (pinMuxModuleName = pinDemuxRegsiterInfo.getPinDemuxHead().getPinMuxModuleName()).equalsIgnoreCase("pin_mux_drv_aon")) {
                    this.createPinMux98cv200BinForCommon(pinDemuxRegsiterInfo, index);
                    if (this.binCommonTable != null && !this.binPinMuxCommonModule.isExistBinTableList(this.binCommonTable) && this.binCommonTable.getTableBinItemList().size() > 0) {
                        this.binPinMuxCommonModule.addTableToModule(this.binCommonTable);
                    }
                }
                ++index;
            }
            if (!binData.isExistModuleList(this.binPinMuxCommonModule) && this.binPinMuxCommonModule.getTableCount() > 0) {
                binData.addModule(this.binPinMuxCommonModule);
            }
        }
        if (pinDemuxForFlashMap.containsKey("pin_mux_drv")) {
            pinDemuxRegStartupList = pinDemuxForFlashMap.get("pin_mux_drv");
            TextReader.addSecion("pin_mux_drv");
            this.binPinMuxCommonModule = new BinModule();
            this.binCommonTable = new BinTable();
            this.lastBaseCommonAddr = 0;
            this.binCommonTableRegLen = 0;
            int index = 0;
            while (index < pinDemuxRegStartupList.size()) {
                pinDemuxRegsiterInfo = pinDemuxRegStartupList.get(index);
                pinMuxRegName = pinDemuxRegsiterInfo.getPinMuxRegName();
                pinMuxFunction = pinDemuxRegsiterInfo.getPinMuxFunction();
                if (pinMuxRegName.equalsIgnoreCase("ioshare_55") || pinMuxRegName.equalsIgnoreCase("ioshare_56")) {
                    System.out.println(pinMuxFunction);
                    System.out.println(pinDemuxRegsiterInfo.getPinMuxValue());
                }
                TextReader.addParam("pin_mux_drv", pinMuxRegName, pinMuxFunction);
                regReadOrWrite = pinDemuxRegsiterInfo.getRegReadOrWrite();
                if (regReadOrWrite != RegBinAction.NONE && (pinMuxModuleName = pinDemuxRegsiterInfo.getPinDemuxHead().getPinMuxModuleName()).equalsIgnoreCase("pin_mux_drv")) {
                    this.createPinMux98cv200BinForCommon(pinDemuxRegsiterInfo, index);
                    if (this.binCommonTable != null && !this.binPinMuxCommonModule.isExistBinTableList(this.binCommonTable) && this.binCommonTable.getTableBinItemList().size() > 0) {
                        this.binPinMuxCommonModule.addTableToModule(this.binCommonTable);
                    }
                }
                ++index;
            }
            if (!binData.isExistModuleList(this.binPinMuxCommonModule) && this.binPinMuxCommonModule.getTableCount() > 0) {
                binData.addModule(this.binPinMuxCommonModule);
            }
        }
        if (pinDemuxForFlashMap.containsKey("fp_pin_mux_drv")) {
            TextReader.addSecion("fp_pin_mux_drv");
            this.binFpPinMuxModule = new BinModule();
            this.binFpPinMuxTable = new BinTable();
            this.lastBaseFpPinMuxAddr = 0;
            this.binFpPinMuxTableRegLen = 0;
            pinDemuxRegStartupList = pinDemuxForFlashMap.get("fp_pin_mux_drv");
            int index = 0;
            while (index < pinDemuxRegStartupList.size()) {
                pinDemuxRegsiterInfo = pinDemuxRegStartupList.get(index);
                pinMuxRegName = pinDemuxRegsiterInfo.getPinMuxRegName();
                pinMuxFunction = pinDemuxRegsiterInfo.getPinMuxFunction();
                TextReader.addParam("pin_mux_drv", pinMuxRegName, pinMuxFunction);
                regReadOrWrite = pinDemuxRegsiterInfo.getRegReadOrWrite();
                if (regReadOrWrite != RegBinAction.NONE && (pinMuxModuleName = pinDemuxRegsiterInfo.getPinDemuxHead().getPinMuxModuleName()).equalsIgnoreCase("fp_pin_mux_drv")) {
                    this.createPinMux98cv200BinForPinMux(pinDemuxRegsiterInfo, index);
                    if (this.binFpPinMuxTable != null && !this.binFpPinMuxModule.isExistBinTableList(this.binFpPinMuxTable) && this.binFpPinMuxTable.getTableBinItemList().size() > 0) {
                        this.binFpPinMuxModule.addTableToModule(this.binFpPinMuxTable);
                    }
                }
                ++index;
            }
            if (!binData.isExistModuleList(this.binFpPinMuxModule) && this.binFpPinMuxModule.getTableCount() > 0) {
                binData.addModule(this.binFpPinMuxModule);
            }
        }
    }

    private void addPinMuxDataToRegbin(PinDemuxInfo pinDemuxInfo, RegBinData regBinData, File logFile) {
        if (RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV410") || RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV420")) {
            ArrayList<PinDemuxRegisterInfo> pinDemuxRegsiterList = pinDemuxInfo.getPinDemuxRegisterList();
            this.writePinDemuxRegListToRegBin(regBinData, logFile, pinDemuxRegsiterList);
        } else {
            ArrayList<PinDemuxRegisterInfo> pinDemuxRegStartupList;
            Map<String, ArrayList<PinDemuxRegisterInfo>> pinDemuxForFlashMap = pinDemuxInfo.getPinDemuxForFlashMap();
            ParsedMainData parsedMainData = ExcelDataHelper.getParsedMainData();
            if (parsedMainData != null) {
                ArrayList<String> startupList = parsedMainData.getStartupList();
                for (String startup : startupList) {
                    if (!pinDemuxForFlashMap.containsKey(startup)) continue;
                    ArrayList<PinDemuxRegisterInfo> pinDemuxRegStartupList2 = pinDemuxForFlashMap.get(startup);
                    this.writePinDemuxRegListToRegBin(regBinData, logFile, pinDemuxRegStartupList2);
                }
            }
            if (pinDemuxForFlashMap.containsKey("pin_mux_drv")) {
                pinDemuxRegStartupList = pinDemuxForFlashMap.get("pin_mux_drv");
                this.writePinDemuxRegListToRegBin(regBinData, logFile, pinDemuxRegStartupList);
            }
            if (pinDemuxForFlashMap.containsKey("fp_pin_mux_drv")) {
                pinDemuxRegStartupList = pinDemuxForFlashMap.get("fp_pin_mux_drv");
                this.writePinDemuxRegListToRegBin(regBinData, logFile, pinDemuxRegStartupList);
            }
        }
    }

    private void writePinDemuxRegListToRegBin(RegBinData regBinData, File logFile, ArrayList<PinDemuxRegisterInfo> pinDemuxRegsiterList) {
        int index = 0;
        while (index < pinDemuxRegsiterList.size()) {
            PinDemuxRegisterInfo pinDemuxRegsiterInfo = pinDemuxRegsiterList.get(index);
            RegBinAction regReadOrWrite = pinDemuxRegsiterInfo.getRegReadOrWrite();
            if (regReadOrWrite != RegBinAction.NONE) {
                RegBinItem regBinItem = this.createPinMuxRegBin(pinDemuxRegsiterInfo, logFile, index);
                regBinData.addItem(regBinItem);
            }
            ++index;
        }
    }

    private void createPinMuxCfgBin(CfgBinModule cfgBinModule, PinDemuxRegisterInfo pinDemuxRegsiterInfo, File logFile, int regIndex) {
        int pinMuxOffsetAddress = pinDemuxRegsiterInfo.getPinMuxOffsetAddress();
        int pinMuxValue = pinDemuxRegsiterInfo.getPinMuxValue();
        int regDelay = pinDemuxRegsiterInfo.getRegDelay();
        int regStartBit = pinDemuxRegsiterInfo.getRegStartBit();
        int regBit = pinDemuxRegsiterInfo.getRegBit();
        RegBinAction regReadOrWrite = pinDemuxRegsiterInfo.getRegReadOrWrite();
        PinDemuxHead pinDemuxHead = pinDemuxRegsiterInfo.getPinDemuxHead();
        int pinMuxBaseAddress = pinDemuxHead.getPinMuxBaseAddress();
        boolean exeForNormalBoot = pinDemuxHead.isExeForNormalBoot();
        boolean exeForStandyWakeup = pinDemuxHead.isExeForStandyWakeup();
        CfgBinType mType = this.handleCfgBinType(exeForStandyWakeup, exeForNormalBoot);
        cfgBinModule.setType(mType);
        cfgBinModule.setBaseAddr(pinMuxBaseAddress);
        CfgBinItem cfgBinItemData = new CfgBinItem(cfgBinModule);
        cfgBinItemData.setValue(pinMuxValue);
        cfgBinItemData.setAddress(pinMuxOffsetAddress);
        cfgBinItemData.setDelay(regDelay);
        int mValueMask = BitUtils.getMask(regStartBit, regStartBit + regBit);
        cfgBinItemData.setValueMask(mValueMask);
        if (regReadOrWrite == RegBinAction.NONE) {
            return;
        }
        CfgBinCommand mCmd = this.handleCfgBinCmd(regBit, regReadOrWrite);
        cfgBinItemData.setCmd(mCmd);
        cfgBinModule.addItem(cfgBinItemData);
        this.outputCfgPinMuxBinInfoForData(pinDemuxRegsiterInfo, cfgBinItemData, logFile, regIndex);
    }

    private void createPinMux98cv200BinForStartup(PinDemuxRegisterInfo pinDemuxRegsiterInfo, int regIndex) {
        if (this.binPinMuxStartupModule.getBinModuleHead() == null) {
            BinModuleType pinModuleType = pinDemuxRegsiterInfo.getPinDemuxHead().getPinModuleType();
            boolean exeForNormalBoot = pinDemuxRegsiterInfo.getPinDemuxHead().isExeForNormalBoot();
            boolean exeForStandyWakeup = pinDemuxRegsiterInfo.getPinDemuxHead().isExeForStandyWakeup();
            boolean pinNormalChip = pinDemuxRegsiterInfo.getPinDemuxHead().isPinNormalChip();
            boolean pinCaChip = pinDemuxRegsiterInfo.getPinDemuxHead().isPinCaChip();
            BinModuleHead binModuleHead = new BinModuleHead(pinModuleType, PrepareSetting.convertBoolToInt(exeForNormalBoot), PrepareSetting.convertBoolToInt(exeForStandyWakeup), PrepareSetting.convertBoolToInt(pinNormalChip), PrepareSetting.convertBoolToInt(pinCaChip));
            this.binPinMuxStartupModule.setBinModuleHead(binModuleHead);
        }
        int pinMuxBaseAddress = pinDemuxRegsiterInfo.getPinDemuxHead().getPinMuxBaseAddress();
        this.binPinMuxStartupModule.setBaseAddr(pinMuxBaseAddress);
        int pinMuxOffsetAddress = pinDemuxRegsiterInfo.getPinMuxOffsetAddress();
        int regAbsoluteAddr = pinMuxBaseAddress + pinMuxOffsetAddress;
        int tableAddress = this.binStartupTable.calculateTableAddress(regAbsoluteAddr);
        if (this.lastBaseStartupAddr != tableAddress) {
            if (!this.binPinMuxStartupModule.isExistBinTableList(this.binStartupTable) && this.binStartupTable.getTableBinItemList().size() > 0) {
                this.binPinMuxStartupModule.addTableToModule(this.binStartupTable);
            }
            this.binStartupTable = new BinTable();
            this.binStartupTableRegLen = 0;
            this.binStartupTable.setTableAddress(tableAddress);
        }
        int pinMuxValue = pinDemuxRegsiterInfo.getPinMuxValue();
        int regDelay = pinDemuxRegsiterInfo.getRegDelay();
        int regStartBit = pinDemuxRegsiterInfo.getRegStartBit();
        int regBit = pinDemuxRegsiterInfo.getRegBit();
        RegBinAction regReadOrWrite = pinDemuxRegsiterInfo.getRegReadOrWrite();
        BinItem binItem = new BinItem(this.binPinMuxStartupModule, this.binStartupTable);
        int itemOffersetAddress = binItem.calculateOffsetAddress(regAbsoluteAddr);
        binItem.setOffsetAddress(itemOffersetAddress);
        binItem.setValue(pinMuxValue);
        binItem.setDelay(regDelay);
        binItem.setWriteOrRead(regReadOrWrite);
        binItem.setBits(regBit);
        binItem.setStartBit(regStartBit);
        this.binStartupTableRegLen += binItem.getBytesSize();
        this.binStartupTable.setTableRegTotalLength(this.binStartupTableRegLen);
        this.binStartupTable.addBinItemToList(binItem);
        this.lastBaseStartupAddr = tableAddress;
    }

    private void createPinMux98cv200BinForCommon(PinDemuxRegisterInfo pinDemuxRegsiterInfo, int regIndex) {
        if (this.binPinMuxCommonModule.getBinModuleHead() == null) {
            BinModuleType pinModuleType = pinDemuxRegsiterInfo.getPinDemuxHead().getPinModuleType();
            boolean exeForNormalBoot = pinDemuxRegsiterInfo.getPinDemuxHead().isExeForNormalBoot();
            boolean exeForStandyWakeup = pinDemuxRegsiterInfo.getPinDemuxHead().isExeForStandyWakeup();
            boolean pinNormalChip = pinDemuxRegsiterInfo.getPinDemuxHead().isPinNormalChip();
            boolean pinCaChip = pinDemuxRegsiterInfo.getPinDemuxHead().isPinCaChip();
            BinModuleHead binModuleHead = new BinModuleHead(pinModuleType, PrepareSetting.convertBoolToInt(exeForNormalBoot), PrepareSetting.convertBoolToInt(exeForStandyWakeup), PrepareSetting.convertBoolToInt(pinNormalChip), PrepareSetting.convertBoolToInt(pinCaChip));
            this.binPinMuxCommonModule.setBinModuleHead(binModuleHead);
        }
        int pinMuxBaseAddress = pinDemuxRegsiterInfo.getPinDemuxHead().getPinMuxBaseAddress();
        this.binPinMuxCommonModule.setBaseAddr(pinMuxBaseAddress);
        int pinMuxOffsetAddress = pinDemuxRegsiterInfo.getPinMuxOffsetAddress();
        int regAbsoluteAddr = pinMuxBaseAddress + pinMuxOffsetAddress;
        int tableAddress = this.binCommonTable.calculateTableAddress(regAbsoluteAddr);
        if (this.lastBaseCommonAddr != tableAddress) {
            if (!this.binPinMuxCommonModule.isExistBinTableList(this.binCommonTable) && this.binCommonTable.getTableBinItemList().size() > 0) {
                this.binPinMuxCommonModule.addTableToModule(this.binCommonTable);
            }
            this.binCommonTable = new BinTable();
            this.binCommonTableRegLen = 0;
            this.binCommonTable.setTableAddress(tableAddress);
        }
        int pinMuxValue = pinDemuxRegsiterInfo.getPinMuxValue();
        int regDelay = pinDemuxRegsiterInfo.getRegDelay();
        int regStartBit = pinDemuxRegsiterInfo.getRegStartBit();
        int regBit = pinDemuxRegsiterInfo.getRegBit();
        RegBinAction regReadOrWrite = pinDemuxRegsiterInfo.getRegReadOrWrite();
        BinItem binItem = new BinItem(this.binPinMuxCommonModule, this.binCommonTable);
        int itemOffersetAddress = binItem.calculateOffsetAddress(regAbsoluteAddr);
        binItem.setOffsetAddress(itemOffersetAddress);
        binItem.setValue(pinMuxValue);
        binItem.setDelay(regDelay);
        binItem.setWriteOrRead(regReadOrWrite);
        binItem.setBits(regBit);
        binItem.setStartBit(regStartBit);
        this.binCommonTableRegLen += binItem.getBytesSize();
        this.binCommonTable.setTableRegTotalLength(this.binCommonTableRegLen);
        this.binCommonTable.addBinItemToList(binItem);
        this.lastBaseCommonAddr = tableAddress;
    }

    private void createPinMux98cv200BinForPinMux(PinDemuxRegisterInfo pinDemuxRegsiterInfo, int regIndex) {
        if (this.binFpPinMuxModule.getBinModuleHead() == null) {
            BinModuleType pinModuleType = pinDemuxRegsiterInfo.getPinDemuxHead().getPinModuleType();
            boolean exeForNormalBoot = pinDemuxRegsiterInfo.getPinDemuxHead().isExeForNormalBoot();
            boolean exeForStandyWakeup = pinDemuxRegsiterInfo.getPinDemuxHead().isExeForStandyWakeup();
            boolean pinNormalChip = pinDemuxRegsiterInfo.getPinDemuxHead().isPinNormalChip();
            boolean pinCaChip = pinDemuxRegsiterInfo.getPinDemuxHead().isPinCaChip();
            BinModuleHead binModuleHead = new BinModuleHead(pinModuleType, PrepareSetting.convertBoolToInt(exeForNormalBoot), PrepareSetting.convertBoolToInt(exeForStandyWakeup), PrepareSetting.convertBoolToInt(pinNormalChip), PrepareSetting.convertBoolToInt(pinCaChip));
            this.binFpPinMuxModule.setBinModuleHead(binModuleHead);
        }
        int pinMuxBaseAddress = pinDemuxRegsiterInfo.getPinDemuxHead().getPinMuxBaseAddress();
        this.binFpPinMuxModule.setBaseAddr(pinMuxBaseAddress);
        int pinMuxOffsetAddress = pinDemuxRegsiterInfo.getPinMuxOffsetAddress();
        int regAbsoluteAddr = pinMuxBaseAddress + pinMuxOffsetAddress;
        int tableAddress = this.binFpPinMuxTable.calculateTableAddress(regAbsoluteAddr);
        if (this.lastBaseFpPinMuxAddr != tableAddress) {
            if (!this.binFpPinMuxModule.isExistBinTableList(this.binFpPinMuxTable) && this.binFpPinMuxTable.getTableBinItemList().size() > 0) {
                this.binFpPinMuxModule.addTableToModule(this.binFpPinMuxTable);
            }
            this.binFpPinMuxTable = new BinTable();
            this.binFpPinMuxTableRegLen = 0;
            this.binFpPinMuxTable.setTableAddress(tableAddress);
        }
        int pinMuxValue = pinDemuxRegsiterInfo.getPinMuxValue();
        int regDelay = pinDemuxRegsiterInfo.getRegDelay();
        int regStartBit = pinDemuxRegsiterInfo.getRegStartBit();
        int regBit = pinDemuxRegsiterInfo.getRegBit();
        RegBinAction regReadOrWrite = pinDemuxRegsiterInfo.getRegReadOrWrite();
        BinItem binItem = new BinItem(this.binFpPinMuxModule, this.binFpPinMuxTable);
        int itemOffersetAddress = binItem.calculateOffsetAddress(regAbsoluteAddr);
        binItem.setOffsetAddress(itemOffersetAddress);
        binItem.setValue(pinMuxValue);
        binItem.setDelay(regDelay);
        binItem.setWriteOrRead(regReadOrWrite);
        binItem.setBits(regBit);
        binItem.setStartBit(regStartBit);
        this.binFpPinMuxTableRegLen += binItem.getBytesSize();
        this.binFpPinMuxTable.setTableRegTotalLength(this.binFpPinMuxTableRegLen);
        this.binFpPinMuxTable.addBinItemToList(binItem);
        this.lastBaseFpPinMuxAddr = tableAddress;
    }

    private RegBinItem createPinMuxRegBin(PinDemuxRegisterInfo pinDemuxRegsiterInfo, File logFile, int regIndex) {
        int pinMuxOffsetAddress = pinDemuxRegsiterInfo.getPinMuxOffsetAddress();
        int pinMuxValue = pinDemuxRegsiterInfo.getPinMuxValue();
        int regDelay = pinDemuxRegsiterInfo.getRegDelay();
        int regStartBit = pinDemuxRegsiterInfo.getRegStartBit();
        int regBit = pinDemuxRegsiterInfo.getRegBit();
        RegBinAction regReadOrWrite = pinDemuxRegsiterInfo.getRegReadOrWrite();
        PinDemuxHead pinDemuxHead = pinDemuxRegsiterInfo.getPinDemuxHead();
        int pinMuxBaseAddress = pinDemuxHead.getPinMuxBaseAddress();
        boolean exeForStandyWakeup = pinDemuxHead.isExeForStandyWakeup();
        boolean exeForNormalBoot = pinDemuxHead.isExeForNormalBoot();
        int actualAddress = pinMuxBaseAddress + pinMuxOffsetAddress;
        RegBinItem regBinItem = new RegBinItem();
        regBinItem.setAddress(actualAddress);
        regBinItem.setDelay(regDelay);
        regBinItem.setValue(pinMuxValue);
        this.handleAttributeValue(exeForNormalBoot, exeForStandyWakeup, regBit, regStartBit, regReadOrWrite, regBinItem);
        this.outputPinMuxRegbinInfo(pinDemuxRegsiterInfo, regBinItem, logFile, regIndex);
        return regBinItem;
    }

    private void outputCfgBinInfoForData(ExcelWorkbookInfo excelWorkbookInfo, BaseRegisterInfo baseRegisterInfo, CfgBinItem cfgBinItemData, File logFile, int regIndex) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("--------------------------------------------WorkbookName: " + excelWorkbookInfo.getWorkbookName() + "\r\n");
        sBuilder.append("RegIndex: " + (8 + regIndex) + "\r\n");
        sBuilder.append("RegName: " + baseRegisterInfo.getRegName() + "\r\n");
        sBuilder.append("offset Address: " + Integer.toHexString(baseRegisterInfo.getRegOffsetAddress()) + "\r\n");
        sBuilder.append("RegFunction: " + baseRegisterInfo.getRegFunction() + "\r\n");
        sBuilder.append("RegValue: " + Integer.toHexString(baseRegisterInfo.getRegValue()) + "\r\n");
        sBuilder.append("RegDelay: " + baseRegisterInfo.getRegDelay() + "\r\n");
        sBuilder.append("cfgBinItemData Value(RegValue): " + Integer.toHexString(cfgBinItemData.getValue()) + "\r\n");
        sBuilder.append("cfgBinItemData Address: " + Integer.toHexString(cfgBinItemData.getAddress()) + "\r\n");
        sBuilder.append("cfgBinItemData CMD: " + (Object)((Object)cfgBinItemData.getCmd()) + "\r\n");
        sBuilder.append("--------------------------------------------\r\n");
        FileUtils.saveItemToFile(logFile, sBuilder.toString());
    }

    private void outputCfgPinMuxBinInfoForData(PinDemuxRegisterInfo pinDemuxRegsiterInfo, CfgBinItem cfgBinItemDelay, File logFile, int regIndex) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("--------------------------------------------WorkbookName: pin_mux_drv\r\n");
        sBuilder.append("RegIndex: " + (8 + regIndex) + "\r\n");
        sBuilder.append("RegName: " + pinDemuxRegsiterInfo.getPinMuxRegName() + "\r\n");
        sBuilder.append("offset Address: " + Integer.toHexString(pinDemuxRegsiterInfo.getPinMuxOffsetAddress()) + "\r\n");
        sBuilder.append("RegFunction: " + pinDemuxRegsiterInfo.getPinMuxFunction() + "\r\n");
        sBuilder.append("RegValue: " + Integer.toHexString(pinDemuxRegsiterInfo.getPinMuxValue()) + "\r\n");
        sBuilder.append("RegDelay: " + pinDemuxRegsiterInfo.getRegDelay() + "\r\n");
        sBuilder.append("cfgBinItemDelay Value(RegDelay): " + cfgBinItemDelay.getValue() + "\r\n");
        sBuilder.append("cfgBinItemDelay Addrsss(RegOffset): " + Integer.toHexString(cfgBinItemDelay.getAddress()) + "\r\n");
        sBuilder.append("cfgBinItemDelay CMD: " + (Object)((Object)cfgBinItemDelay.getCmd()) + "\r\n");
        sBuilder.append("--------------------------------------------\r\n");
        FileUtils.saveItemToFile(logFile, sBuilder.toString());
    }

    private void outputPinMuxRegbinInfo(PinDemuxRegisterInfo pinDemuxRegsiterInfo, RegBinItem regBinItem, File logFile, int regIndex) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("--------------------------------------------WorkbookName: pin_mux_drv\r\n");
        sBuilder.append("RegIndex: " + (8 + regIndex) + "\r\n");
        sBuilder.append("RegName: " + pinDemuxRegsiterInfo.getPinMuxRegName() + "\r\n");
        sBuilder.append("offset Address: 0x" + Integer.toHexString(pinDemuxRegsiterInfo.getPinMuxOffsetAddress()) + "\r\n");
        sBuilder.append("RegFunction: " + pinDemuxRegsiterInfo.getPinMuxFunction() + "\r\n");
        sBuilder.append("RegValue: 0x" + Integer.toHexString(regBinItem.getValue()) + "\r\n");
        sBuilder.append("RegDelay: " + regBinItem.getDelay() + "\r\n");
        sBuilder.append("Attributes: " + Integer.toHexString(regBinItem.getAttributes()) + "\r\n");
        sBuilder.append("--------------------------------------------\r\n");
        FileUtils.saveItemToFile(logFile, sBuilder.toString());
    }

    private void outputDebugRegBinInfo(ExcelWorkbookInfo excelWorkbookInfo, BaseRegisterInfo baseRegisterInfo, RegBinItem regBinItem, File logFile, int regIndex) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("--------------------------------------------WorkbookName: " + excelWorkbookInfo.getWorkbookName() + "\r\n");
        sBuilder.append("BaseAddress: " + Integer.toHexString(excelWorkbookInfo.getBaseAddress()) + "\r\n");
        sBuilder.append("RegIndex: " + (8 + regIndex) + "\r\n");
        sBuilder.append("RegName: " + baseRegisterInfo.getRegName() + "\r\n");
        sBuilder.append("offset Address: 0x" + Integer.toHexString(baseRegisterInfo.getRegOffsetAddress()) + "\r\n");
        sBuilder.append("RegFunction: " + baseRegisterInfo.getRegFunction() + "\r\n");
        sBuilder.append("RegValue: 0x" + Integer.toHexString(regBinItem.getValue()) + "\r\n");
        sBuilder.append("RegDelay: " + regBinItem.getDelay() + "\r\n");
        sBuilder.append("Attributes: " + Integer.toHexString(regBinItem.getAttributes()) + "\r\n");
        sBuilder.append("--------------------------------------------\r\n");
        FileUtils.saveItemToFile(logFile, sBuilder.toString());
    }

    private RegBinItem createRegBinItem(BaseRegisterInfo baseRegsiterInfo, int baseAddress, boolean exeForNormalBoot, boolean exeForStandyWakeup) {
        int regDelay = baseRegsiterInfo.getRegDelay();
        int regBit = baseRegsiterInfo.getRegBit();
        int regStartBit = baseRegsiterInfo.getRegStartBit();
        int regOffsetAddress = baseRegsiterInfo.getRegOffsetAddress();
        int regValue = baseRegsiterInfo.getRegValue();
        RegBinAction regReadOrWrite = baseRegsiterInfo.getRegReadOrWrite();
        int actualAddress = baseAddress + regOffsetAddress;
        RegBinItem regBinItem = new RegBinItem();
        regBinItem.setAddress(actualAddress);
        regBinItem.setDelay(regDelay);
        regBinItem.setValue(regValue);
        this.handleAttributeValue(exeForNormalBoot, exeForStandyWakeup, regBit, regStartBit, regReadOrWrite, regBinItem);
        return regBinItem;
    }

    private void handleAttributeValue(boolean exeForNormalBoot, boolean exeForStandyWakeup, int regBit, int regStartBit, RegBinAction regReadOrWrite, RegBinItem regBinItem) {
        regBinItem.setBits(regReadOrWrite, regBit);
        regBinItem.setStartBit(regReadOrWrite, regStartBit);
        regBinItem.setExecutionRequiredForNormalBoot(regReadOrWrite, exeForNormalBoot);
        regBinItem.setExecutionRequiredForStandbyWakeup(regReadOrWrite, exeForStandyWakeup);
        regBinItem.setActionEnabled(regReadOrWrite, true);
        regBinItem.setAttribute(regBinItem.getAttributes());
    }

    public IStatus makeCfgBin(String filePath, ExcelData excelData) throws IOException {
        if (excelData == null) {
            excelData = ExcelDataHelper.getExcelData();
        }
        if (this.paramObj instanceof BaseParam) {
            File logFile = this.createLogFile(filePath);
            BaseParam baseParam = (BaseParam)this.paramObj;
            CAConfig selectCA = baseParam.getSelectCA();
            String selectDemoName = baseParam.getSelectDemoName();
            File file = new File(filePath);
            String fileName = file.getName();
            baseParam.setCustomDemoName(fileName);
            String customDemoName = baseParam.getCustomDemoName();
            Map<String, String> selectDdrParamValueMap = baseParam.getSelectDdrParamValueMap();
            Map<String, String> selectMacValueMap = baseParam.getSelectMacValueMap();
            Map<String, String> selectPhyAddrValueMap = baseParam.getSelectPhyAddrValueMap();
            Map<String, String> selectGpioGroupNumValueMap = baseParam.getSelectGpioGroupNumValueMap();
            Map<String, String> selectGpioBitsValueMap = baseParam.getSelectGpioBitsValueMap();
            PinDemuxInfo pinDemuxInfo = baseParam.getPinDemuxInfo();
            CfgBinData cfgBinData = new CfgBinData();
            String currentTime = ConvertUtils.getCurrentTime();
            cfgBinData.setmName(customDemoName);
            cfgBinData.setmTime(currentTime);
            ExcelMainData excelMainData = excelData.getExcelMainData();
            ArrayList<ExcelWorkbookInfo> excelWorkbookInfoList = excelData.getExcelWorkbookInfoList();
            boolean isStartWritePinMuxData = false;
            int workbookIndex = 0;
            while (workbookIndex < excelWorkbookInfoList.size()) {
                ExcelWorkbookInfo excelWorkbookInfo = excelWorkbookInfoList.get(workbookIndex);
                String workbookName = excelWorkbookInfo.getWorkbookName();
                if (this.filterCAorNoCAWookbook(workbookName, selectCA = CAConfig.CA) && this.filterDemoNameWookbook(workbookName, selectDemoName, baseParam)) {
                    if (workbookName.contains("pin_mux_drv") || workbookName.contains("fp_pin_mux_drv")) {
                        isStartWritePinMuxData = true;
                    } else {
                        if (isStartWritePinMuxData) {
                            this.writePinMuxToCfgBin(cfgBinData, pinDemuxInfo, logFile);
                            isStartWritePinMuxData = false;
                        }
                        CfgBinModule cfgBinModule = new CfgBinModule();
                        boolean exeForStandyWakeup = excelWorkbookInfo.isExeForStandyWakeup();
                        boolean exeForNormalBoot = excelWorkbookInfo.isExeForNormalBoot();
                        CfgBinType mType = this.handleCfgBinType(exeForStandyWakeup, exeForNormalBoot);
                        cfgBinModule.setType(mType);
                        int baseAddress = excelWorkbookInfo.getBaseAddress();
                        cfgBinModule.setBaseAddr(baseAddress);
                        ArrayList<BaseRegisterInfo> baseResiterInfoList = excelWorkbookInfo.getBaseRegisterInfoList();
                        ArrayList<MainDdrParam> mainDdrParamList = excelMainData.getMainDdrParamList();
                        ArrayList<MainNetconfig> mainNetconfigList = excelMainData.getMainNetconfigList();
                        ArrayList<MainModelParam> mainModelParamList = excelMainData.getMainModelParamList();
                        int regIndex = 0;
                        while (regIndex < baseResiterInfoList.size()) {
                            BaseRegisterInfo baseRegsiterInfo = baseResiterInfoList.get(regIndex);
                            boolean filterSelectDdrParamResult = false;
                            int paramIndex = 0;
                            while (paramIndex < mainDdrParamList.size()) {
                                MainDdrParam mainDdrParam = mainDdrParamList.get(paramIndex);
                                filterSelectDdrParamResult = this.filterSelectDdrParam(workbookName, baseRegsiterInfo, mainDdrParamList, selectDdrParamValueMap, mainDdrParam);
                                if (filterSelectDdrParamResult) break;
                                ++paramIndex;
                            }
                            if (!filterSelectDdrParamResult && !this.filterEthPhyCfgInfo(workbookName, baseRegsiterInfo, selectMacValueMap, mainNetconfigList, mainModelParamList, selectPhyAddrValueMap, selectGpioGroupNumValueMap, selectGpioBitsValueMap)) {
                                int regDelay = baseRegsiterInfo.getRegDelay();
                                int regBit = baseRegsiterInfo.getRegBit();
                                int regStartBit = baseRegsiterInfo.getRegStartBit();
                                int regOffsetAddress = baseRegsiterInfo.getRegOffsetAddress();
                                int regValue = baseRegsiterInfo.getRegValue();
                                RegBinAction regReadOrWrite = baseRegsiterInfo.getRegReadOrWrite();
                                if (regReadOrWrite != RegBinAction.NONE) {
                                    CfgBinItem cfgBinItemData = new CfgBinItem(cfgBinModule);
                                    cfgBinItemData.setValue(regValue);
                                    cfgBinItemData.setAddress(regOffsetAddress);
                                    cfgBinItemData.setDelay(regDelay);
                                    int mValueMask = BitUtils.getMask(regStartBit, regStartBit + regBit);
                                    cfgBinItemData.setValueMask(mValueMask);
                                    CfgBinCommand mCmd = this.handleCfgBinCmd(regBit, regReadOrWrite);
                                    cfgBinItemData.setCmd(mCmd);
                                    cfgBinModule.addItem(cfgBinItemData);
                                    this.outputCfgBinInfoForData(excelWorkbookInfo, baseRegsiterInfo, cfgBinItemData, logFile, regIndex);
                                }
                            }
                            ++regIndex;
                        }
                        if (cfgBinModule.getItemCount() > 0) {
                            cfgBinData.addModule(cfgBinModule);
                        }
                    }
                }
                ++workbookIndex;
            }
            if (isStartWritePinMuxData) {
                this.writePinMuxToCfgBin(cfgBinData, pinDemuxInfo, logFile);
                isStartWritePinMuxData = false;
            }
            if (cfgBinData.toFile(filePath)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public IStatus make98cv200Bin(String filePath, ExcelData excelData, String fileName) throws IOException {
        if (this.paramObj instanceof BaseParam) {
            BinData binData = this.save98MV200BinDataByCurExcelData(filePath, excelData, fileName);
            byte[] binDataArray = binData.binDataArray();
            if ((RegbinView.isHi3796MV200Series() || RegbinView.isHi3716MV430Series()) && binDataArray.length > 10752) {
                return Status.CANCEL_STATUS;
            }
            if (RegbinView.isHi3796CV300Series() && binDataArray.length > 10480) {
                return Status.CANCEL_STATUS;
            }
            if (binData.toFile(filePath)) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    /*
     * Unable to fully structure code
     */
    public BinData save98MV200BinDataByCurExcelData(String filePath, ExcelData excelData, String fileName) {
        if (excelData == null) {
            excelData = ExcelDataHelper.getExcelData();
        }
        baseParam = (BaseParam)this.paramObj;
        selectDemoName = baseParam.getSelectDemoName();
        selectDdrType = baseParam.getSelectDdrType();
        selectStartup = baseParam.getSelectStartup();
        selectDdrPhy = baseParam.getSelectDdrPhy();
        selectDdrParamValueMap = baseParam.getSelectDdrParamValueMap();
        selectMacValueMap = baseParam.getSelectMacValueMap();
        selectPhyAddrValueMap = baseParam.getSelectPhyAddrValueMap();
        selectGpioGroupNumValueMap = baseParam.getSelectGpioGroupNumValueMap();
        selectGpioBitsValueMap = baseParam.getSelectGpioBitsValueMap();
        configFilePath = String.valueOf(filePath.substring(0, filePath.lastIndexOf("."))) + ".config";
        TextReader.initCreateFile();
        TextReader.addSecion("ConfigName");
        TextReader.addParam("ConfigName", "ConfigName", String.valueOf(fileName.substring(0, fileName.lastIndexOf("."))) + ".config");
        this.writeBaseSettingToConfigFile(selectDdrParamValueMap, selectMacValueMap, selectPhyAddrValueMap, selectGpioGroupNumValueMap, selectGpioBitsValueMap, configFilePath);
        TextReader.addSecion("Startup");
        TextReader.addParam("Startup", "Startup", selectStartup);
        if (ExcelDataHelper.isV135XlsFomatVersion(excelData)) {
            TextReader.addSecion("DdrPhy");
            TextReader.addParam("DdrPhy", "DdrPhy", selectDdrPhy);
        }
        pinDemuxInfo = baseParam.getPinDemuxInfo();
        binData = new BinData();
        binHeadData = new BinHeadData();
        binHeadData.setRegFormatVersion(excelData.getExcelMainData().getRegFormatVersion());
        binHeadData.setXlsVersion(excelData.getExcelMainData().getXlsVersion());
        currentTime = ConvertUtils.getCurrentTime();
        binHeadData.setBinMakeTime(currentTime);
        binHeadData.setBinName(fileName);
        binData.setHeadData(binHeadData);
        headBytesSize = binHeadData.getHeadBytesSize();
        binHeadData.setFirstBinModuleOffset(headBytesSize);
        excelMainData = excelData.getExcelMainData();
        excelWorkbookInfoList = excelData.getExcelWorkbookInfoList();
        isStartWritePinMuxData = false;
        workbookIndex = 0;
        while (workbookIndex < excelWorkbookInfoList.size()) {
            block9: {
                block10: {
                    block11: {
                        excelWorkbookInfo = excelWorkbookInfoList.get(workbookIndex);
                        workbookName = excelWorkbookInfo.getWorkbookName();
                        System.out.println(workbookName);
                        if (!this.filterDdrphyTmg(workbookName, selectDemoName, baseParam) || !this.filterDemoNameWookbook(workbookName, selectDemoName, baseParam) || RegbinView.isHi3796CV300Series() && !this.filterDdr4Wakeup(workbookName, selectDemoName) || (ExcelDataHelper.isV135XlsFomatVersion(ExcelDataHelper.getExcelData()) == false ? this.filterDdrTypeWorkbook(workbookName, selectDdrType, excelMainData) == false : this.filterDdrPhyWookbook(workbookName, excelMainData, selectDdrPhy) == false)) break block9;
                        if (!RegbinView.isHi3796CV300Series()) break block10;
                        if (workbookName.equalsIgnoreCase("pin_mux_drv_aon")) break block9;
                        if (!workbookName.equalsIgnoreCase("pin_mux_drv") && !workbookName.equalsIgnoreCase("fp_pin_mux_drv")) break block11;
                        isStartWritePinMuxData = true;
                        break block9;
                    }
                    if (!workbookName.contains("pin_mux_drv") && !workbookName.contains("fp_pin_mux_drv")) ** GOTO lbl-1000
                    break block9;
                }
                if (workbookName.contains("pin_mux_drv") || workbookName.contains("fp_pin_mux_drv")) {
                    isStartWritePinMuxData = true;
                } else lbl-1000:
                // 2 sources

                {
                    if (isStartWritePinMuxData) {
                        this.writePinMuxTo98cv200Bin(binData, pinDemuxInfo, selectStartup);
                        isStartWritePinMuxData = false;
                    }
                    binModule = new BinModule();
                    System.out.println("Module_WorkName: " + workbookName);
                    baseAddress = excelWorkbookInfo.getBaseAddress();
                    System.out.println("Base Address: 0x00" + Long.toHexString(baseAddress));
                    binModule.setBaseAddr(baseAddress);
                    exeForStandyWakeup = excelWorkbookInfo.isExeForStandyWakeup();
                    exeForNormalBoot = excelWorkbookInfo.isExeForNormalBoot();
                    moduleType = excelWorkbookInfo.getModuleType();
                    normalChip = excelWorkbookInfo.isNormalChip();
                    caChip = excelWorkbookInfo.isCaChip();
                    binModuleHead = new BinModuleHead(moduleType, PrepareSetting.convertBoolToInt(exeForNormalBoot), PrepareSetting.convertBoolToInt(exeForStandyWakeup), PrepareSetting.convertBoolToInt(normalChip), PrepareSetting.convertBoolToInt(caChip));
                    binModule.setBinModuleHead(binModuleHead);
                    binTable = this.create98MV200BinTable(excelWorkbookInfo, excelMainData, workbookName, workbookName, binModule, baseParam);
                    if (binTable != null && !binModule.isExistBinTableList(binTable) && binTable.getTableBinItemList().size() > 0) {
                        binModule.addTableToModule(binTable);
                    }
                    binData.addModule(binModule);
                }
            }
            ++workbookIndex;
        }
        if (isStartWritePinMuxData) {
            this.writePinMuxTo98cv200Bin(binData, pinDemuxInfo, selectStartup);
            isStartWritePinMuxData = false;
        }
        if (!(writeNewListToFile = TextReader.writeNewListToFile(configFilePath))) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"HiRegBin", (String)Messages.WriteConfigFileFailed);
                }
            });
        }
        return binData;
    }

    private boolean filterDdrphyTmg(String workbookName, String selectDemoName, BaseParam baseParam) {
        String customDemoName = baseParam.getCustomDemoName();
        String[] strList = customDemoName.split("_");
        String selectPageName = "";
        if (strList.length >= 3) {
            selectPageName = strList[2];
        }
        if (strList.length >= 4 && strList[3].equalsIgnoreCase("2Rank")) {
            selectPageName = String.valueOf(strList[2]) + "_" + strList[3];
        }
        if (RegbinView.isHi3716MV430Series()) {
            return true;
        }
        String demoName = "";
        String pageName = "";
        String[] nameList = workbookName.split("_");
        if (nameList.length >= 3) {
            demoName = nameList[0];
            pageName = nameList[2];
        } else {
            demoName = nameList[0];
        }
        if (workbookName.toLowerCase().contains("ddrphytmg")) {
            if (nameList.length >= 4 && workbookName.contains("2Rank")) {
                pageName = String.valueOf(nameList[2]) + "_" + nameList[3];
            }
            if (RegbinView.isHi3796CV300Series() && demoName.contains("dma")) {
                if (pageName.contains("lp4")) {
                    pageName = pageName.replace("lp4", "LPDDR4");
                }
                return selectDemoName.contains(demoName) && pageName.equalsIgnoreCase(selectPageName);
            }
            if (demoName.contains("tsa") && selectDemoName.contains(demoName)) {
                return true;
            }
            if (!workbookName.toLowerCase().contains(selectDemoName.toLowerCase())) {
                return false;
            }
        }
        return true;
    }

    private boolean filterDdr4Wakeup(String workbookName, String selectDemoName) {
        if (workbookName.toLowerCase().contains("ddr4_wakeup")) {
            if (selectDemoName.toLowerCase().contains("dma") && workbookName.equalsIgnoreCase("DDR4_wakeup")) {
                return false;
            }
            if (selectDemoName.toLowerCase().contains("tsa") && workbookName.equalsIgnoreCase("LPDDR4_wakeup")) {
                return false;
            }
        }
        return true;
    }

    public BinData saveBinDataByCurExcelData(String fileName) throws IOException {
        ExcelData excelData = AbstractBaseComposite.getCurrentExcelData();
        if (excelData == null) {
            excelData = ExcelDataHelper.getExcelData();
        }
        if (this.paramObj instanceof BaseParam) {
            BaseParam baseParam = (BaseParam)this.paramObj;
            String selectDemoName = baseParam.getSelectDemoName();
            String selectDdrType = baseParam.getSelectDdrType();
            String selectDdrPhy = baseParam.getSelectDdrPhy();
            String selectStartup = baseParam.getSelectStartup();
            PinDemuxInfo pinDemuxInfo = baseParam.getPinDemuxInfo();
            BinData binData = new BinData();
            BinHeadData binHeadData = new BinHeadData();
            binHeadData.setRegFormatVersion(excelData.getExcelMainData().getRegFormatVersion());
            binHeadData.setXlsVersion(excelData.getExcelMainData().getXlsVersion());
            String currentTime = ConvertUtils.getCurrentTime();
            binHeadData.setBinMakeTime(currentTime);
            binHeadData.setBinName(fileName);
            binData.setHeadData(binHeadData);
            int headBytesSize = binHeadData.getHeadBytesSize();
            binHeadData.setFirstBinModuleOffset(headBytesSize);
            ExcelMainData excelMainData = excelData.getExcelMainData();
            ArrayList<ExcelWorkbookInfo> excelWorkbookInfoList = excelData.getExcelWorkbookInfoList();
            boolean isStartWritePinMuxData = false;
            int workbookIndex = 0;
            while (workbookIndex < excelWorkbookInfoList.size()) {
                ExcelWorkbookInfo excelWorkbookInfo = excelWorkbookInfoList.get(workbookIndex);
                String workbookName = excelWorkbookInfo.getWorkbookName();
                System.out.println(workbookName);
                if (this.filterDemoNameWookbook(workbookName, selectDemoName, baseParam) && !(!ExcelDataHelper.isV135XlsFomatVersion(ExcelDataHelper.getExcelData()) ? !this.filterDdrTypeWorkbook(workbookName, selectDdrType, excelMainData) : selectDdrPhy != null && !this.filterDdrPhyWookbook(workbookName, excelMainData, selectDdrPhy))) {
                    if (workbookName.contains("pin_mux_drv") || workbookName.contains("fp_pin_mux_drv")) {
                        isStartWritePinMuxData = true;
                    } else {
                        if (isStartWritePinMuxData) {
                            this.writePinMuxTo98cv200Bin(binData, pinDemuxInfo, selectStartup);
                            isStartWritePinMuxData = false;
                        }
                        BinModule binModule = new BinModule();
                        System.out.println("Module_WorkName: " + workbookName);
                        int baseAddress = excelWorkbookInfo.getBaseAddress();
                        binModule.setBaseAddr(baseAddress);
                        boolean exeForStandyWakeup = excelWorkbookInfo.isExeForStandyWakeup();
                        boolean exeForNormalBoot = excelWorkbookInfo.isExeForNormalBoot();
                        BinModuleType moduleType = excelWorkbookInfo.getModuleType();
                        boolean normalChip = excelWorkbookInfo.isNormalChip();
                        boolean caChip = excelWorkbookInfo.isCaChip();
                        BinModuleHead binModuleHead = new BinModuleHead(moduleType, PrepareSetting.convertBoolToInt(exeForNormalBoot), PrepareSetting.convertBoolToInt(exeForStandyWakeup), PrepareSetting.convertBoolToInt(normalChip), PrepareSetting.convertBoolToInt(caChip));
                        binModule.setBinModuleHead(binModuleHead);
                        BinTable binTable = this.createBinTable(excelWorkbookInfo, excelMainData, workbookName, workbookName, binModule, baseParam);
                        if (binTable != null && !binModule.isExistBinTableList(binTable) && binTable.getTableBinItemList().size() > 0) {
                            binModule.addTableToModule(binTable);
                        }
                        binData.addModule(binModule);
                    }
                }
                ++workbookIndex;
            }
            if (isStartWritePinMuxData) {
                this.writePinMuxTo98cv200Bin(binData, pinDemuxInfo, selectStartup);
                isStartWritePinMuxData = false;
            }
            return binData;
        }
        return null;
    }

    private void writeBaseSettingToConfigFile(Map<String, String> selectDdrParamValueMap, Map<String, String> selectMacValueMap, Map<String, String> selectPhyAddrValueMap, Map<String, String> selectGpioGroupNumValueMap, Map<String, String> selectGpioBitsValueMap, String configFilePath) {
        Iterator<Map.Entry<String, String>> ddrParamIterator = selectDdrParamValueMap.entrySet().iterator();
        TextReader.addSecion("DdrParamters");
        while (ddrParamIterator.hasNext()) {
            Map.Entry<String, String> entry = ddrParamIterator.next();
            String paramName = entry.getKey();
            String selectValue = entry.getValue();
            TextReader.addParam("DdrParamters", paramName, selectValue);
        }
        Iterator<Map.Entry<String, String>> macValueIterator = selectMacValueMap.entrySet().iterator();
        TextReader.addSecion("MacName");
        while (macValueIterator.hasNext()) {
            Map.Entry<String, String> entry = macValueIterator.next();
            String paramName = entry.getKey();
            String selectValue = entry.getValue();
            TextReader.addParam(paramName, paramName, selectValue);
        }
        Iterator<Map.Entry<String, String>> phyAddrIterator = selectPhyAddrValueMap.entrySet().iterator();
        TextReader.addSecion("PhyAddress");
        while (phyAddrIterator.hasNext()) {
            Map.Entry<String, String> entry = phyAddrIterator.next();
            String paramName = entry.getKey();
            String selectValue = entry.getValue();
            TextReader.addParam("PhyAddress", paramName, selectValue);
        }
        Iterator<Map.Entry<String, String>> gpioGroupNumIterator = selectGpioGroupNumValueMap.entrySet().iterator();
        TextReader.addSecion("GpioGroupNum");
        while (gpioGroupNumIterator.hasNext()) {
            Map.Entry<String, String> entry = gpioGroupNumIterator.next();
            String paramName = entry.getKey();
            String selectValue = entry.getValue();
            TextReader.addParam("GpioGroupNum", paramName, selectValue);
        }
        Iterator<Map.Entry<String, String>> gpioBitsIterator = selectGpioBitsValueMap.entrySet().iterator();
        TextReader.addSecion("GpioBits");
        while (gpioBitsIterator.hasNext()) {
            Map.Entry<String, String> entry = gpioBitsIterator.next();
            String paramName = entry.getKey();
            String selectValue = entry.getValue();
            TextReader.addParam("GpioBits", paramName, selectValue);
        }
    }

    public IStatus exportExcel(String filePath, ExcelData currentExcelData) throws IOException {
        BaseParam baseParam;
        boolean saveDataToExcel;
        if (this.paramObj instanceof BaseParam && !(saveDataToExcel = this.saveDataToExcel(filePath, currentExcelData, baseParam = (BaseParam)this.paramObj))) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public boolean saveDataToExcel(String excelFile, ExcelData excelData, BaseParam baseParam) throws IOException {
        XSSFWorkbook workbook = null;
        FileOutputStream fileOut = null;
        workbook = new XSSFWorkbook();
        ArrayList<ExcelWorkbookInfo> excelWorkbookInfoList = excelData.getExcelWorkbookInfoList();
        CAConfig selectCA = baseParam.getSelectCA();
        String selectDemoName = baseParam.getSelectDemoName();
        PinDemuxInfo pinDemuxInfo = baseParam.getPinDemuxInfo();
        boolean isStartWritePinMuxData = false;
        for (ExcelWorkbookInfo excelWorkbookInfo : excelWorkbookInfoList) {
            boolean createSheet;
            String workbookName = excelWorkbookInfo.getWorkbookName();
            if (!this.filterCAorNoCAWookbook(workbookName, selectCA) || !this.filterDemoNameWookbook(workbookName, selectDemoName, baseParam)) continue;
            if (workbookName.contains("pin_mux_drv") || workbookName.contains("fp_pin_mux_drv")) {
                isStartWritePinMuxData = true;
                continue;
            }
            if (isStartWritePinMuxData) {
                isStartWritePinMuxData = false;
                boolean writePinMuxToExcel = this.writePinMuxToExcel(pinDemuxInfo, (Workbook)workbook);
                if (!writePinMuxToExcel) {
                    return false;
                }
            }
            if (createSheet = this.createSheet((Workbook)workbook, excelWorkbookInfo, excelData, baseParam)) continue;
            return false;
        }
        if (isStartWritePinMuxData) {
            isStartWritePinMuxData = false;
            boolean writePinMuxToExcel = this.writePinMuxToExcel(pinDemuxInfo, (Workbook)workbook);
            if (!writePinMuxToExcel) {
                return false;
            }
        }
        try {
            try {
                fileOut = new FileOutputStream(excelFile);
                workbook.write((OutputStream)fileOut);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (fileOut != null) {
                    fileOut.close();
                }
            }
        }
        finally {
            if (fileOut != null) {
                fileOut.close();
            }
        }
        return true;
    }

    private boolean createSheet(Workbook workbook, ExcelWorkbookInfo excelWorkbookInfo, ExcelData excelData, BaseParam baseParam) throws IOException {
        String workbookName = excelWorkbookInfo.getWorkbookName();
        XSSFSheet sheet = (XSSFSheet)workbook.createSheet(workbookName);
        System.out.println("SheetName: " + sheet.getSheetName());
        String[] header = ExcelDefinition.ExcelCommonDefinition.getHeader();
        XSSFCell paramNameCell = null;
        XSSFCell paramValueCell = null;
        int i = 0;
        while (i < header.length) {
            XSSFRow row = sheet.createRow(0 + i);
            paramNameCell = row.createCell(0);
            paramNameCell.setCellValue(header[i]);
            paramNameCell.setCellStyle(ExcelStyleUtils.getLightBuleStyle(workbook));
            sheet.autoSizeColumn(paramNameCell.getColumnIndex(), true);
            paramValueCell = row.createCell(1);
            String cellValue = ExcelDataHelper.getHeaderCellValue(excelWorkbookInfo, i);
            paramValueCell.setCellValue(cellValue);
            paramValueCell.setCellStyle(ExcelStyleUtils.getLightYellowStyle(workbook));
            sheet.autoSizeColumn(paramValueCell.getColumnIndex(), true);
            ++i;
        }
        this.createRegHeaderRow(workbook, (Sheet)sheet, header);
        Map<String, String> selectDdrParamValueMap = baseParam.getSelectDdrParamValueMap();
        Map<String, String> selectMacValueList = baseParam.getSelectMacValueMap();
        Map<String, String> selectPhyAddrValueMap = baseParam.getSelectPhyAddrValueMap();
        Map<String, String> selectGpioGroupNumValueMap = baseParam.getSelectGpioGroupNumValueMap();
        Map<String, String> selectGpioBitsValueMap = baseParam.getSelectGpioBitsValueMap();
        ExcelMainData excelMainData = excelData.getExcelMainData();
        ArrayList<MainDdrParam> mainDdrParamList = excelMainData.getMainDdrParamList();
        ArrayList<MainNetconfig> mainNetconfigList = excelMainData.getMainNetconfigList();
        ArrayList<MainModelParam> mainModelParamList = excelMainData.getMainModelParamList();
        ArrayList<BaseRegisterInfo> baseRegisterInfoList = excelWorkbookInfo.getBaseRegisterInfoList();
        int rowOffset = -1;
        int j = 0;
        while (j < baseRegisterInfoList.size()) {
            ++rowOffset;
            BaseRegisterInfo baseRegisterInfo = baseRegisterInfoList.get(j);
            boolean filterSelectDdrParamResult = false;
            int paramIndex = 0;
            while (paramIndex < mainDdrParamList.size()) {
                MainDdrParam mainDdrParam = mainDdrParamList.get(paramIndex);
                filterSelectDdrParamResult = this.filterSelectDdrParam(workbookName, baseRegisterInfo, mainDdrParamList, selectDdrParamValueMap, mainDdrParam);
                if (filterSelectDdrParamResult) break;
                ++paramIndex;
            }
            if (filterSelectDdrParamResult) {
                --rowOffset;
            } else if (this.filterEthPhyCfgInfo(workbookName, baseRegisterInfo, selectMacValueList, mainNetconfigList, mainModelParamList, selectPhyAddrValueMap, selectGpioGroupNumValueMap, selectGpioBitsValueMap)) {
                --rowOffset;
            } else {
                String regName = baseRegisterInfo.getRegName();
                int regOffsetAddress = baseRegisterInfo.getRegOffsetAddress();
                int regValue = baseRegisterInfo.getRegValue();
                int regDelay = baseRegisterInfo.getRegDelay();
                RegBinAction regReadOrWrite = baseRegisterInfo.getRegReadOrWrite();
                int regBit = baseRegisterInfo.getRegBit();
                int regStartBit = baseRegisterInfo.getRegStartBit();
                XSSFRow regRow = sheet.createRow(0 + header.length + rowOffset + 1);
                XSSFCell regCell = regRow.createCell(0);
                regCell.setCellValue(regName);
                regCell.setCellStyle(ExcelStyleUtils.getLightYellowStyle(workbook));
                XSSFCell offsetCell = regRow.createCell(1);
                offsetCell.setCellValue("0x" + Integer.toHexString(regOffsetAddress));
                offsetCell.setCellStyle(ExcelStyleUtils.getLightYellowStyle(workbook));
                XSSFCell valueCell = regRow.createCell(2);
                valueCell.setCellValue("0x" + Integer.toHexString(regValue));
                valueCell.setCellStyle(ExcelStyleUtils.getLightYellowStyle(workbook));
                XSSFCell delayCell = regRow.createCell(3);
                delayCell.setCellValue(String.valueOf(regDelay));
                delayCell.setCellStyle(ExcelStyleUtils.getLightYellowStyle(workbook));
                XSSFCell readOrWriteCell = regRow.createCell(4);
                readOrWriteCell.setCellValue(regReadOrWrite.name().toLowerCase());
                readOrWriteCell.setCellStyle(ExcelStyleUtils.getLightYellowStyle(workbook));
                XSSFCell bitCell = regRow.createCell(5);
                bitCell.setCellValue(String.valueOf(regBit));
                bitCell.setCellStyle(ExcelStyleUtils.getLightYellowStyle(workbook));
                XSSFCell startBitCell = regRow.createCell(6);
                startBitCell.setCellValue(String.valueOf(regStartBit));
                startBitCell.setCellStyle(ExcelStyleUtils.getLightYellowStyle(workbook));
            }
            ++j;
        }
        return true;
    }

    private boolean writePinMuxToExcel(PinDemuxInfo pinDemuxInfo, Workbook workbook) throws IOException {
        ArrayList<PinDemuxRegisterInfo> pinDemuxRegisterList = pinDemuxInfo.getPinDemuxRegisterList();
        LinkedHashMap<String, PinDemuxHead> map = new LinkedHashMap<String, PinDemuxHead>();
        for (PinDemuxRegisterInfo pinDemuxRegisterInfo : pinDemuxRegisterList) {
            String pinMuxModuleName = pinDemuxRegisterInfo.getPinDemuxHead().getPinMuxModuleName();
            if (map.containsKey(pinMuxModuleName)) continue;
            map.put(pinMuxModuleName, pinDemuxRegisterInfo.getPinDemuxHead());
        }
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                String moduleName = (String)entry.getKey();
                PinDemuxHead pinDemuxHead = (PinDemuxHead)entry.getValue();
                XSSFSheet sheet = (XSSFSheet)workbook.createSheet(moduleName);
                System.out.println("SheetName: " + sheet.getSheetName());
                String[] header = ExcelDefinition.ExcelCommonDefinition.getHeader();
                XSSFCell paramNameCell = null;
                XSSFCell paramValueCell = null;
                int i = 0;
                while (i < header.length) {
                    XSSFRow row = sheet.createRow(0 + i);
                    paramNameCell = row.createCell(0);
                    paramNameCell.setCellValue(header[i]);
                    paramNameCell.setCellStyle(ExcelStyleUtils.getLightBuleStyle(workbook));
                    paramValueCell = row.createCell(1);
                    String cellValue = ExcelDataHelper.getHeaderCellValueByPinDemux(pinDemuxHead, i);
                    paramValueCell.setCellValue(cellValue);
                    paramValueCell.setCellStyle(ExcelStyleUtils.getLightYellowStyle(workbook));
                    ++i;
                }
                this.createRegHeaderRow(workbook, (Sheet)sheet, header);
                this.createDemuxSheet(sheet, pinDemuxInfo, workbook, header, moduleName);
            }
        }
        return true;
    }

    private void createDemuxSheet(XSSFSheet sheet, PinDemuxInfo pinDemuxInfo, Workbook workbook, String[] header, String moduleName) {
        ArrayList<PinDemuxRegisterInfo> pinDemuxRegsiterList = pinDemuxInfo.getPinDemuxRegisterList();
        int fpPinMuxDrvBegin = -1;
        boolean isBeginFpPinMuxDrv = false;
        int rowIndex = 0;
        int index = 0;
        while (index < pinDemuxRegsiterList.size()) {
            PinDemuxRegisterInfo pinDemuxRegsiterInfo = pinDemuxRegsiterList.get(index);
            String pinMuxRegName = pinDemuxRegsiterInfo.getPinMuxRegName();
            int pinMuxOffsetAddress = pinDemuxRegsiterInfo.getPinMuxOffsetAddress();
            int pinMuxValue = pinDemuxRegsiterInfo.getPinMuxValue();
            int regDelay = pinDemuxRegsiterInfo.getRegDelay();
            int regStartBit = pinDemuxRegsiterInfo.getRegStartBit();
            int regBit = pinDemuxRegsiterInfo.getRegBit();
            RegBinAction regReadOrWrite = pinDemuxRegsiterInfo.getRegReadOrWrite();
            String pinMuxModuleName = pinDemuxRegsiterInfo.getPinDemuxHead().getPinMuxModuleName();
            if (moduleName.equalsIgnoreCase(pinMuxModuleName)) {
                if (!isBeginFpPinMuxDrv && pinMuxModuleName.equalsIgnoreCase("fp_pin_mux_drv")) {
                    fpPinMuxDrvBegin = index;
                    isBeginFpPinMuxDrv = true;
                }
                rowIndex = fpPinMuxDrvBegin != -1 ? index - fpPinMuxDrvBegin : index;
                XSSFRow regRow = sheet.createRow(0 + header.length + rowIndex + 1);
                XSSFCell regCell = regRow.createCell(0);
                regCell.setCellValue(pinMuxRegName);
                regCell.setCellStyle(ExcelStyleUtils.getGreenStyle(workbook));
                XSSFCell offsetCell = regRow.createCell(1);
                offsetCell.setCellValue("0x" + Integer.toHexString(pinMuxOffsetAddress));
                offsetCell.setCellStyle(ExcelStyleUtils.getGreenStyle(workbook));
                XSSFCell valueCell = regRow.createCell(2);
                valueCell.setCellValue("0x" + Integer.toHexString(pinMuxValue));
                valueCell.setCellStyle(ExcelStyleUtils.getGreenStyle(workbook));
                XSSFCell delayCell = regRow.createCell(3);
                delayCell.setCellValue(String.valueOf(regDelay));
                delayCell.setCellStyle(ExcelStyleUtils.getGreenStyle(workbook));
                XSSFCell readOrWriteCell = regRow.createCell(4);
                readOrWriteCell.setCellValue(regReadOrWrite.name().toLowerCase());
                readOrWriteCell.setCellStyle(ExcelStyleUtils.getGreenStyle(workbook));
                XSSFCell bitCell = regRow.createCell(5);
                bitCell.setCellValue(String.valueOf(regBit));
                bitCell.setCellStyle(ExcelStyleUtils.getGreenStyle(workbook));
                XSSFCell startBitCell = regRow.createCell(6);
                startBitCell.setCellValue(String.valueOf(regStartBit));
                startBitCell.setCellStyle(ExcelStyleUtils.getGreenStyle(workbook));
            }
            ++index;
        }
    }

    private void createRegHeaderRow(Workbook workbook, Sheet sheet, String[] header) {
        XSSFRow regHeaderRow = (XSSFRow)sheet.createRow(0 + header.length);
        XSSFCell regHeaderCell = regHeaderRow.createCell(0);
        regHeaderCell.setCellValue("Register");
        regHeaderCell.setCellStyle(ExcelStyleUtils.getLightOrangeStyle(workbook));
        sheet.autoSizeColumn(regHeaderCell.getColumnIndex(), true);
        XSSFCell offsetHeaderCell = regHeaderRow.createCell(1);
        offsetHeaderCell.setCellValue("Offset Address");
        offsetHeaderCell.setCellStyle(ExcelStyleUtils.getLightOrangeStyle(workbook));
        sheet.autoSizeColumn(offsetHeaderCell.getColumnIndex(), true);
        XSSFCell valueHeaderCell = regHeaderRow.createCell(2);
        valueHeaderCell.setCellValue("Value Written to or Read from Register");
        valueHeaderCell.setCellStyle(ExcelStyleUtils.getLightOrangeStyle(workbook));
        sheet.autoSizeColumn(valueHeaderCell.getColumnIndex(), true);
        XSSFCell delayHeaderCell = regHeaderRow.createCell(3);
        delayHeaderCell.setCellValue("delay");
        delayHeaderCell.setCellStyle(ExcelStyleUtils.getLightOrangeStyle(workbook));
        sheet.autoSizeColumn(delayHeaderCell.getColumnIndex(), true);
        XSSFCell readOrWriteHeaderCell = regHeaderRow.createCell(4);
        readOrWriteHeaderCell.setCellValue("Read or Write");
        readOrWriteHeaderCell.setCellStyle(ExcelStyleUtils.getLightOrangeStyle(workbook));
        sheet.autoSizeColumn(readOrWriteHeaderCell.getColumnIndex(), true);
        XSSFCell bitHeaderCell = regHeaderRow.createCell(5);
        bitHeaderCell.setCellValue("Bits to Be Read or Written");
        bitHeaderCell.setCellStyle(ExcelStyleUtils.getLightOrangeStyle(workbook));
        sheet.autoSizeColumn(bitHeaderCell.getColumnIndex(), true);
        XSSFCell startBitHeaderCell = regHeaderRow.createCell(6);
        startBitHeaderCell.setCellValue("Start Bit to Be Read or Written");
        startBitHeaderCell.setCellStyle(ExcelStyleUtils.getLightOrangeStyle(workbook));
        sheet.autoSizeColumn(startBitHeaderCell.getColumnIndex(), true);
    }

    private CfgBinType handleCfgBinType(boolean exeForStandyWakeup, boolean exeForNormalBoot) {
        CfgBinType mType = null;
        if (exeForStandyWakeup) {
            mType = CfgBinType.WAKEUP;
        }
        if (exeForNormalBoot) {
            mType = CfgBinType.INIT;
        }
        if (exeForStandyWakeup && exeForNormalBoot) {
            mType = CfgBinType.BOTH;
        }
        return mType;
    }

    private CfgBinCommand handleCfgBinCmd(int regBit, RegBinAction regReadOrWrite) {
        CfgBinCommand mCmd = null;
        if (regReadOrWrite == RegBinAction.READ) {
            mCmd = regBit == 31 ? CfgBinCommand.WAIT : CfgBinCommand.WAIT_MSK;
        } else if (regReadOrWrite == RegBinAction.WRITE) {
            mCmd = regBit == 31 ? CfgBinCommand.REG : CfgBinCommand.REG_MSK;
        } else {
            System.out.println("ERROR: regReadOrWrite: " + (Object)((Object)regReadOrWrite));
        }
        return mCmd;
    }

    private boolean filterDemoNameWookbook(String workbookName, String selectDemoName, BaseParam baseParam) {
        String customDemoName = baseParam.getCustomDemoName();
        String[] strList = customDemoName.split("_");
        String selectPageName = "";
        if (strList.length >= 3) {
            selectPageName = strList[2];
        }
        if (RegbinView.isHi3716MV430Series()) {
            return true;
        }
        if (workbookName.toLowerCase().contains("ddrphy") && !workbookName.toLowerCase().contains("ddrphytmg")) {
            String[] nameList = workbookName.split("_");
            if (nameList.length >= 3) {
                String demoName = nameList[0];
                String pageName = nameList[2];
                if (RegbinView.isHi3796CV300Series() && demoName.contains("dma") && !workbookName.contains("tmg")) {
                    if (pageName.contains("lp4")) {
                        pageName = pageName.replace("lp4", "LPDDR4");
                    }
                    return demoName.equalsIgnoreCase(selectDemoName) && pageName.equalsIgnoreCase(selectPageName);
                }
                if (!demoName.equalsIgnoreCase(selectDemoName)) {
                    return false;
                }
            }
            if (!workbookName.toLowerCase().contains(selectDemoName.toLowerCase())) {
                return false;
            }
        }
        return true;
    }

    private boolean filterDdrPhyWookbook(String workbookName, ExcelMainData excelMainData, String selectDdrPhy) {
        boolean result = false;
        if (selectDdrPhy == null) {
            return result;
        }
        boolean isDdrWakeup = this.isDdrWakeup(excelMainData);
        boolean isDDRTypeWorkbook = false;
        String lowerWorkbookName = workbookName.toLowerCase();
        if (isDdrWakeup) {
            isDDRTypeWorkbook = lowerWorkbookName.contains("sysctrl") || lowerWorkbookName.contains("mddrc") || lowerWorkbookName.contains("mddrc_poweron") || lowerWorkbookName.contains("ddr_wakeup");
        } else {
            boolean bl = isDDRTypeWorkbook = lowerWorkbookName.contains("sysctrl") || lowerWorkbookName.contains("mddrc") || lowerWorkbookName.contains("mddrc_poweron");
        }
        if (isDDRTypeWorkbook) {
            ArrayList<MainDdrPhy> mainDdrPhyList = excelMainData.getMainDdrPhyList();
            int i = 0;
            while (i < mainDdrPhyList.size()) {
                MainDdrPhy mainDdrPhy = mainDdrPhyList.get(i);
                String ddrPhyName = mainDdrPhy.getDdrPhyName();
                ArrayList<String> pageNames = mainDdrPhy.getPageName();
                if (selectDdrPhy.equalsIgnoreCase(ddrPhyName)) {
                    result = pageNames.contains(workbookName);
                }
                ++i;
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean filterDdrTypeWorkbook(String workbookName, String selectDdrType, ExcelMainData excelMainData) {
        boolean isDdrWakeup = this.isDdrWakeup(excelMainData);
        boolean isDDRTypeWorkbook = false;
        String lowerWorkbookName = workbookName.toLowerCase();
        if (isDdrWakeup) {
            isDDRTypeWorkbook = lowerWorkbookName.contains("sysctrl") || lowerWorkbookName.contains("mddrc") || lowerWorkbookName.contains("mddrc_poweron") || lowerWorkbookName.contains("ddr_wakeup");
        } else {
            boolean bl = isDDRTypeWorkbook = lowerWorkbookName.contains("sysctrl") || lowerWorkbookName.contains("mddrc") || lowerWorkbookName.contains("mddrc_poweron");
        }
        if (RegbinView.isHi3716MV430Series()) {
            boolean bl = isDDRTypeWorkbook = lowerWorkbookName.contains("sysctrl") || lowerWorkbookName.contains("mddrc") || lowerWorkbookName.contains("mddrc_poweron") || lowerWorkbookName.contains("ddrphy");
        }
        if (!isDDRTypeWorkbook) {
            return true;
        }
        ArrayList<MainDdrType> mainddrTypeList = excelMainData.getMainddrTypeList();
        if (mainddrTypeList == null) {
            return false;
        }
        for (MainDdrType mainDdrType : mainddrTypeList) {
            boolean isMatch;
            String ddrTypeName = mainDdrType.getDdrTypeName();
            if (!selectDdrType.equalsIgnoreCase(ddrTypeName) || !(isMatch = this.checkWBNameEqPageName(workbookName, mainDdrType))) continue;
            return isMatch;
        }
        return false;
    }

    private boolean isDdrWakeup(ExcelMainData excelMainData) {
        ArrayList<MainDdrType> mainddrTypeList = excelMainData.getMainddrTypeList();
        for (MainDdrType mainDdrType : mainddrTypeList) {
            ArrayList<String> pageNameList = mainDdrType.getPageName();
            for (String pageName : pageNameList) {
                if (!pageName.toLowerCase().contains("ddr_wakeup")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkWBNameEqPageName(String workbookName, MainDdrType mainDdrType) {
        ArrayList<String> pageNames = mainDdrType.getPageName();
        if (pageNames == null) {
            return false;
        }
        for (String pageName : pageNames) {
            if (!workbookName.equalsIgnoreCase(pageName)) continue;
            return true;
        }
        return false;
    }

    private boolean filterCAorNoCAWookbook(String workbookName, CAConfig selectCA) {
        if (workbookName.equalsIgnoreCase("sysctrl_CA")) {
            return selectCA != CAConfig.noCA;
        }
        if (workbookName.equalsIgnoreCase("sysctrl_noCA")) {
            return selectCA != CAConfig.CA;
        }
        return true;
    }

    private boolean filterEthPhyCfgInfo(String workbookName, BaseRegisterInfo baseRegisterInfo, Map<String, String> selectMacValueMap, ArrayList<MainNetconfig> mainNetconfigList, ArrayList<MainModelParam> mainModelParamList, Map<String, String> selectPhyAddrValueMap, Map<String, String> selectGpioGroupNumValueMap, Map<String, String> selectGpioBitsValueMap) {
        String netMacName;
        boolean isIgnoreRegsiterInfo = false;
        if (workbookName.equalsIgnoreCase("eth_phy_cfg")) {
            String regName = baseRegisterInfo.getRegName();
            int macIndex = 0;
            while (macIndex < mainNetconfigList.size()) {
                MainNetconfig mainNetconfig = mainNetconfigList.get(macIndex);
                netMacName = mainNetconfig.getNetconfigName();
                MainRegInfo netPhyAddr = mainNetconfig.getNetPhyAddr();
                MainRegInfo netResetPin = mainNetconfig.getNetResetPin();
                String netPhyAddressReg = netPhyAddr.getRegName();
                String netResetPinReg = netResetPin.getRegName();
                if (regName.equalsIgnoreCase(netPhyAddressReg) && selectPhyAddrValueMap.containsKey(netMacName)) {
                    String phyAddr = selectPhyAddrValueMap.get(netMacName);
                    baseRegisterInfo.setRegValue(BitUtils.parseLongToInt32(phyAddr, true));
                }
                if (netResetPinReg.contains(regName) && selectGpioGroupNumValueMap.containsKey(netMacName) && selectGpioBitsValueMap.containsKey(netMacName)) {
                    String gpioGroupNum = selectGpioGroupNumValueMap.get(netMacName);
                    String gpioBitsNum = selectGpioBitsValueMap.get(netMacName);
                    if (regName.endsWith("_BIT")) {
                        baseRegisterInfo.setRegValue(Integer.parseInt(gpioBitsNum));
                    } else {
                        baseRegisterInfo.setRegValue(Integer.parseInt(gpioGroupNum));
                    }
                }
                ++macIndex;
            }
        }
        int macIndex = 0;
        while (macIndex < mainModelParamList.size()) {
            MainModelParam mainModelParam = mainModelParamList.get(macIndex);
            ArrayList<MainRegInfo> macModelRegNameList = mainModelParam.getModelRegList();
            if (macModelRegNameList.size() <= 0) {
                return isIgnoreRegsiterInfo;
            }
            netMacName = mainModelParam.getModelConfigName();
            for (MainRegInfo mainRegInfo : macModelRegNameList) {
                String regPage = mainRegInfo.getRegPage();
                if (!workbookName.equalsIgnoreCase(regPage)) continue;
                String regName = baseRegisterInfo.getRegName();
                String macModelRegName = mainRegInfo.getRegName();
                if (!macModelRegName.equalsIgnoreCase(regName)) continue;
                String regFunction = baseRegisterInfo.getRegFunction();
                if (!selectMacValueMap.containsKey(netMacName)) continue;
                String macSelectValue = selectMacValueMap.get(netMacName);
                if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData()) && regFunction.equalsIgnoreCase("GE") && (macSelectValue == null || macSelectValue.isEmpty())) {
                    isIgnoreRegsiterInfo = false;
                    break;
                }
                if (regFunction.equalsIgnoreCase(macSelectValue)) {
                    isIgnoreRegsiterInfo = false;
                    break;
                }
                isIgnoreRegsiterInfo = true;
                break;
            }
            ++macIndex;
        }
        return isIgnoreRegsiterInfo;
    }

    private boolean filterSelectDdrParam(String currentWorkbookName, BaseRegisterInfo baseRegsiterInfo, ArrayList<MainDdrParam> mainDdrParamList, Map<String, String> selectDdrParamValueMap, MainDdrParam mainDdrParam) {
        String ddrParamName = mainDdrParam.getDdrParamName();
        ArrayList<MainRegInfo> ddrRegList = mainDdrParam.getDdrRegList();
        boolean isIgnoreRegsiterInfo = false;
        String regName = baseRegsiterInfo.getRegName();
        for (MainRegInfo mainRegInfo : ddrRegList) {
            String mainRegName = mainRegInfo.getRegName();
            String mainRegPage = mainRegInfo.getRegPage();
            if (mainRegName == null || mainRegPage == null || !currentWorkbookName.equalsIgnoreCase(mainRegPage) || !regName.equals(mainRegName)) continue;
            String currentRegFunction = baseRegsiterInfo.getRegFunction();
            for (Map.Entry<String, String> entry : selectDdrParamValueMap.entrySet()) {
                String selectValue;
                String paramName = entry.getKey();
                if (!paramName.equals(ddrParamName) || currentRegFunction.equalsIgnoreCase(selectValue = entry.getValue())) continue;
                isIgnoreRegsiterInfo = true;
                return isIgnoreRegsiterInfo;
            }
        }
        return isIgnoreRegsiterInfo;
    }

    public static int convertBoolToInt(Boolean bool) {
        if (bool.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public static boolean convertIntToBoot(int value) {
        return value != 0;
    }

    public IStatus repleaceFastbootRegBin(String fileName) {
        return Status.OK_STATUS;
    }

    public IStatus importFromRegBin(File file) {
        return Status.OK_STATUS;
    }

    public IStatus importFromFastboot(File file) {
        return Status.OK_STATUS;
    }

    public IStatus createCfgBin(File file) {
        return Status.OK_STATUS;
    }

    private BinTable createBinTable(ExcelWorkbookInfo excelWorkbookInfo, ExcelMainData excelMainData, String workbookName, String selectDdrPhy, BinModule binModule, BaseParam baseParam) {
        ArrayList<BaseRegisterInfo> baseResiterInfoList = excelWorkbookInfo.getBaseRegisterInfoList();
        ArrayList<MainDdrParam> mainDdrParamList = excelMainData.getMainDdrParamList();
        ArrayList<MainNetconfig> mainNetconfigList = excelMainData.getMainNetconfigList();
        ArrayList<MainModelParam> mainModelParamList = excelMainData.getMainModelParamList();
        Map<String, String> selectDdrParamValueMap = baseParam.getSelectDdrParamValueMap();
        Map<String, String> selectPhyAddrValueMap = baseParam.getSelectPhyAddrValueMap();
        Map<String, String> selectGpioGroupNumValueMap = baseParam.getSelectGpioGroupNumValueMap();
        Map<String, String> selectGpioBitsValueMap = baseParam.getSelectGpioBitsValueMap();
        Map<String, String> selectMacValueMap = baseParam.getSelectMacValueMap();
        int lastBaseAddr = 0;
        int binTableRegLen = 0;
        BinTable binTable = null;
        int regIndex = 0;
        while (regIndex < baseResiterInfoList.size()) {
            block9: {
                RegBinAction regReadOrWrite;
                BaseRegisterInfo baseRegsiterInfo;
                block10: {
                    String curDdrPhyFlag;
                    baseRegsiterInfo = baseResiterInfoList.get(regIndex);
                    boolean filterSelectDdrParamResult = false;
                    int paramIndex = 0;
                    while (paramIndex < mainDdrParamList.size()) {
                        MainDdrParam mainDdrParam = mainDdrParamList.get(paramIndex);
                        filterSelectDdrParamResult = this.filterSelectDdrParam(workbookName, baseRegsiterInfo, mainDdrParamList, selectDdrParamValueMap, mainDdrParam);
                        if (filterSelectDdrParamResult) break;
                        ++paramIndex;
                    }
                    if (filterSelectDdrParamResult) break block9;
                    if (!ExcelDataHelper.isV135XlsFomatVersion(ExcelDataHelper.getExcelData()) || !workbookName.equalsIgnoreCase("peri_cfg")) break block10;
                    String regName = baseRegsiterInfo.getRegName();
                    if (selectDdrPhy != null && selectDdrPhy.indexOf("Channel") != -1 && ((curDdrPhyFlag = selectDdrPhy.substring(selectDdrPhy.indexOf("Channel") + "Channel".length() + "_".length())).equalsIgnoreCase("dch") || curDdrPhyFlag.equalsIgnoreCase("sch")) && regName.startsWith("PERI_QOS_CFG3") && !regName.contains(curDdrPhyFlag)) break block9;
                }
                if (!this.filterEthPhyCfgInfo(workbookName, baseRegsiterInfo, selectMacValueMap, mainNetconfigList, mainModelParamList, selectPhyAddrValueMap, selectGpioGroupNumValueMap, selectGpioBitsValueMap) && (regReadOrWrite = baseRegsiterInfo.getRegReadOrWrite()) != RegBinAction.NONE) {
                    int moduleBaseAddr = binModule.getBaseAddr();
                    int regOffsetAddress = baseRegsiterInfo.getRegOffsetAddress();
                    int regAbsoluteAddr = moduleBaseAddr + regOffsetAddress;
                    if (binTable == null) {
                        binTable = new BinTable();
                    }
                    int tableAddress = binTable.calculateTableAddress(regAbsoluteAddr);
                    System.out.println(baseRegsiterInfo.getRegName());
                    if (lastBaseAddr != tableAddress) {
                        if (!binModule.isExistBinTableList(binTable) && binTable.getTableBinItemList().size() > 0) {
                            binModule.addTableToModule(binTable);
                        }
                        binTable = new BinTable();
                        binTableRegLen = 0;
                        binTable.setTableAddress(tableAddress);
                    }
                    int regDelay = baseRegsiterInfo.getRegDelay();
                    int regBit = baseRegsiterInfo.getRegBit();
                    int regStartBit = baseRegsiterInfo.getRegStartBit();
                    int regValue = baseRegsiterInfo.getRegValue();
                    BinItem binItem = new BinItem(binModule, binTable);
                    int itemOffersetAddress = binItem.calculateOffsetAddress(regAbsoluteAddr);
                    binItem.setOffsetAddress(itemOffersetAddress);
                    binItem.setValue(regValue);
                    binItem.setDelay(regDelay);
                    binItem.setWriteOrRead(regReadOrWrite);
                    binItem.setBits(regBit);
                    binItem.setStartBit(regStartBit);
                    binTable.setTableRegTotalLength(binTableRegLen += binItem.getBytesSize());
                    binTable.addBinItemToList(binItem);
                    lastBaseAddr = tableAddress;
                }
            }
            ++regIndex;
        }
        return binTable;
    }

    private BinTable create98MV200BinTable(ExcelWorkbookInfo excelWorkbookInfo, ExcelMainData excelMainData, String workbookName, String selectDdrPhy, BinModule binModule, BaseParam baseParam) {
        ArrayList<BaseRegisterInfo> baseResiterInfoList = excelWorkbookInfo.getBaseRegisterInfoList();
        ArrayList<MainDdrParam> mainDdrParamList = excelMainData.getMainDdrParamList();
        ArrayList<MainNetconfig> mainNetconfigList = excelMainData.getMainNetconfigList();
        ArrayList<MainModelParam> mainModelParamList = excelMainData.getMainModelParamList();
        Map<String, String> selectDdrParamValueMap = baseParam.getSelectDdrParamValueMap();
        Map<String, String> selectPhyAddrValueMap = baseParam.getSelectPhyAddrValueMap();
        Map<String, String> selectGpioGroupNumValueMap = baseParam.getSelectGpioGroupNumValueMap();
        Map<String, String> selectGpioBitsValueMap = baseParam.getSelectGpioBitsValueMap();
        Map<String, String> selectMacValueMap = baseParam.getSelectMacValueMap();
        int lastBaseAddr = 0;
        int binTableRegLen = 0;
        BinTable binTable = null;
        int regIndex = 0;
        while (regIndex < baseResiterInfoList.size()) {
            block9: {
                RegBinAction regReadOrWrite;
                BaseRegisterInfo baseRegsiterInfo;
                block10: {
                    String curDdrPhyFlag;
                    baseRegsiterInfo = baseResiterInfoList.get(regIndex);
                    boolean filterSelectDdrParamResult = false;
                    int paramIndex = 0;
                    while (paramIndex < mainDdrParamList.size()) {
                        MainDdrParam mainDdrParam = mainDdrParamList.get(paramIndex);
                        filterSelectDdrParamResult = this.filterSelectDdrParam(workbookName, baseRegsiterInfo, mainDdrParamList, selectDdrParamValueMap, mainDdrParam);
                        if (filterSelectDdrParamResult) break;
                        ++paramIndex;
                    }
                    if (filterSelectDdrParamResult) break block9;
                    if (!ExcelDataHelper.isV135XlsFomatVersion(ExcelDataHelper.getExcelData()) || !workbookName.equalsIgnoreCase("peri_cfg")) break block10;
                    String regName = baseRegsiterInfo.getRegName();
                    if (selectDdrPhy != null && selectDdrPhy.indexOf("Channel") != -1 && ((curDdrPhyFlag = selectDdrPhy.substring(selectDdrPhy.indexOf("Channel") + "Channel".length() + "_".length())).equalsIgnoreCase("dch") || curDdrPhyFlag.equalsIgnoreCase("sch")) && regName.startsWith("PERI_QOS_CFG3") && !regName.contains(curDdrPhyFlag)) break block9;
                }
                if (!this.filterEthPhyCfgInfo(workbookName, baseRegsiterInfo, selectMacValueMap, mainNetconfigList, mainModelParamList, selectPhyAddrValueMap, selectGpioGroupNumValueMap, selectGpioBitsValueMap) && (regReadOrWrite = baseRegsiterInfo.getRegReadOrWrite()) != RegBinAction.NONE) {
                    int tableAddress;
                    int moduleBaseAddr = binModule.getBaseAddr();
                    int regOffsetAddress = baseRegsiterInfo.getRegOffsetAddress();
                    int regAbsoluteAddr = moduleBaseAddr + regOffsetAddress;
                    if (binTable == null) {
                        binTable = new BinTable();
                    }
                    if (lastBaseAddr != (tableAddress = binTable.calculateTableAddress(regAbsoluteAddr))) {
                        if (!binModule.isExistBinTableList(binTable) && binTable.getTableBinItemList().size() > 0) {
                            binModule.addTableToModule(binTable);
                        }
                        binTable = new BinTable();
                        binTableRegLen = 0;
                        binTable.setTableAddress(tableAddress);
                    }
                    int regDelay = baseRegsiterInfo.getRegDelay();
                    int regBit = baseRegsiterInfo.getRegBit();
                    int regStartBit = baseRegsiterInfo.getRegStartBit();
                    int regValue = baseRegsiterInfo.getRegValue();
                    BinItem binItem = new BinItem(binModule, binTable);
                    int itemOffersetAddress = binItem.calculateOffsetAddress(regAbsoluteAddr);
                    binItem.setOffsetAddress(itemOffersetAddress);
                    binItem.setValue(regValue);
                    binItem.setDelay(regDelay);
                    binItem.setWriteOrRead(regReadOrWrite);
                    binItem.setBits(regBit);
                    binItem.setStartBit(regStartBit);
                    binTable.setTableRegTotalLength(binTableRegLen += binItem.getBytesSize());
                    binTable.addBinItemToList(binItem);
                    this.printRegInfo(baseRegsiterInfo.getRegName(), regReadOrWrite.ordinal(), regAbsoluteAddr, regBit, itemOffersetAddress, regValue, regDelay);
                    lastBaseAddr = tableAddress;
                }
            }
            ++regIndex;
        }
        return binTable;
    }

    private void printRegInfo(String regName, int regReadOrWrite, int regAbsoluteAddr, int regBit, int itemOffersetAddress, int regValue, int regDelay) {
        System.out.print(String.valueOf(this.fixedStringLength(regName, 30)) + "  ");
        System.out.print("r/w: 0x" + regReadOrWrite + "  ");
        System.out.print("address: 0x" + this.fixedStringLength(Long.toHexString(regAbsoluteAddr), 15) + "  ");
        System.out.print("bit number: 0x" + this.fixedStringLength(Long.toHexString(regBit), 15) + "  ");
        System.out.print("bit Offset: 0x" + this.fixedStringLength(Long.toHexString(itemOffersetAddress), 15) + "  ");
        System.out.print("bit value: 0x" + this.fixedStringLength(Long.toHexString(regValue), 15) + "  ");
        System.out.println("bit delay: 0x" + this.fixedStringLength(Long.toHexString(regDelay), 15));
    }

    private String fixedStringLength(String value, int length) {
        int disparities = 0;
        if (value.length() < length) {
            disparities = length - value.length();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(value);
        int i = 0;
        while (i < disparities) {
            buffer.append(" ");
            ++i;
        }
        return buffer.toString();
    }

    private void createPinBinTable(Map<String, ArrayList<PinDemuxRegisterInfo>> pinDemuxForFlashMap, String startup) {
        this.binPinMuxStartupModule = new BinModule();
        this.binStartupTable = new BinTable();
        this.lastBaseStartupAddr = 0;
        this.binStartupTableRegLen = 0;
        TextReader.addSecion(startup);
        ArrayList<PinDemuxRegisterInfo> pinDemuxRegStartupList = pinDemuxForFlashMap.get(startup);
        int index = 0;
        while (index < pinDemuxRegStartupList.size()) {
            String pinMuxModuleName;
            PinDemuxRegisterInfo pinDemuxRegsiterInfo = pinDemuxRegStartupList.get(index);
            String pinMuxRegName = pinDemuxRegsiterInfo.getPinMuxRegName();
            String pinMuxFunction = pinDemuxRegsiterInfo.getPinMuxFunction();
            TextReader.addParam(startup, pinMuxRegName, pinMuxFunction);
            RegBinAction regReadOrWrite = pinDemuxRegsiterInfo.getRegReadOrWrite();
            if (regReadOrWrite != RegBinAction.NONE && (pinMuxModuleName = pinDemuxRegsiterInfo.getPinDemuxHead().getPinMuxModuleName()).startsWith("pin_mux_drv") && !pinMuxModuleName.equalsIgnoreCase("pin_mux_drv")) {
                this.createPinMux98cv200BinForStartup(pinDemuxRegsiterInfo, index);
                if (this.binStartupTable != null && !this.binPinMuxStartupModule.isExistBinTableList(this.binStartupTable) && this.binStartupTable.getTableBinItemList().size() > 0) {
                    this.binPinMuxStartupModule.addTableToModule(this.binStartupTable);
                }
            }
            ++index;
        }
    }
}

