/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg.hi98cv200bin;

import com.hisilicon.hiregbin.model.PinDemuxHead;
import com.hisilicon.hiregbin.model.reg.bin.RegBinAction;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinHeadData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinItem;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModule;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModuleHead;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinModuleType;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinTable;
import com.hisilicon.hiregbin.processor.PrepareSetting;
import com.hisilicon.hiregbin.utility.BytesUtils;
import com.hisilicon.hiregbin.utility.FileUtils;
import java.util.ArrayList;

public class BinData {
    protected static final String TIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    protected static final String VERSITON = "v1.1.1";
    protected static final String VERSITON_MV310 = "v1.5.0";
    protected static final int SHORT_SIZE = 2;
    protected static final int INT_SIZE = 4;
    protected static final int DATAEND_98CV200_SIZE = 4;
    protected static final int NAME_OFFSET_SIZE = 4;
    protected static final int REGBIN_VERSION_SIZE = 16;
    protected BinHeadData headData;
    protected ArrayList<BinModule> mListModules = new ArrayList();

    public void addModule(BinModule module) {
        this.mListModules.add(module);
    }

    public boolean isExistModuleList(BinModule binModule) {
        return this.mListModules != null && this.mListModules.contains(binModule);
    }

    public ArrayList<BinModule> seekForModule(int baseAddr) {
        ArrayList<BinModule> list = new ArrayList<BinModule>();
        int i = 0;
        while (i < this.mListModules.size()) {
            BinModule module = this.mListModules.get(i);
            if (module.getBaseAddr() == baseAddr) {
                list.add(module);
            }
            ++i;
        }
        return list;
    }

    public BinItem seekForItem(int baseAddr, int offsetAddr, int startBit, int bits, int value, int readOrWrite, BinModuleType moduleType) {
        int absoluteAddr = baseAddr + offsetAddr;
        for (BinModule module : this.mListModules) {
            int tableIndex = 0;
            while (tableIndex < module.getTableCount()) {
                BinTable binTable = module.getBinTableList().get(tableIndex);
                int tableAddress = binTable.getTableAddress();
                int itemIndex = 0;
                while (itemIndex < binTable.getTableBinItemList().size()) {
                    BinItem binItem = binTable.getTableBinItemList().get(itemIndex);
                    if (!binItem.isHasExport()) {
                        int binOffsetAddress = binItem.getOffsetAddress();
                        int binStartBit = binItem.getStartBit();
                        int binValue = binItem.getValue();
                        BinModuleType binModuleType = binItem.getmModuleRef().getBinModuleHead().getModuleType();
                        RegBinAction writeOrRead = binItem.getWriteOrRead();
                        int binbits = binItem.getBits();
                        int binAbsoluteAddr = tableAddress & 0xFFFFFF00 | binOffsetAddress & 0xFF;
                        if (absoluteAddr == binAbsoluteAddr && startBit == binStartBit && bits == binbits && value == binValue && readOrWrite == writeOrRead.ordinal() && moduleType == binModuleType) {
                            module.setBaseAddr(baseAddr);
                            binItem.setHasExport(true);
                            return binItem;
                        }
                    }
                    ++itemIndex;
                }
                ++tableIndex;
            }
        }
        return null;
    }

    public BinItem seekForItemForBase(int absoluteAddr, int offsetAddr, int startBit, int bits, int value, int readOrWrite, BinModuleType moduleType) {
        int baseAddr = absoluteAddr - offsetAddr;
        for (BinModule module : this.mListModules) {
            int tableIndex = 0;
            while (tableIndex < module.getTableCount()) {
                BinTable binTable = module.getBinTableList().get(tableIndex);
                int tableAddress = binTable.getTableAddress();
                int itemIndex = 0;
                while (itemIndex < binTable.getTableBinItemList().size()) {
                    BinItem binItem = binTable.getTableBinItemList().get(itemIndex);
                    if (!binItem.isHasExport()) {
                        int binOffsetAddress = binItem.getOffsetAddress();
                        int binStartBit = binItem.getStartBit();
                        int binbits = binItem.getBits();
                        int binValue = binItem.getValue();
                        BinModuleType binModuleType = binItem.getmModuleRef().getBinModuleHead().getModuleType();
                        RegBinAction writeOrRead = binItem.getWriteOrRead();
                        int binAbsoluteAddr = tableAddress & 0xFFFFFF00 | binOffsetAddress & 0xFF;
                        if (absoluteAddr == binAbsoluteAddr && startBit == binStartBit && bits == binbits && value == binValue && readOrWrite == writeOrRead.ordinal() && moduleType == binModuleType) {
                            module.setBaseAddr(baseAddr);
                            binItem.setHasExport(true);
                            return binItem;
                        }
                    }
                    ++itemIndex;
                }
                ++tableIndex;
            }
        }
        return null;
    }

    public BinItem seekForItemWithoutValue(int absoluteAddr, int offsetAddr, int startBit, int bits, int readOrWrite, BinModuleType moduleType) {
        int baseAddr = absoluteAddr - offsetAddr;
        for (BinModule module : this.mListModules) {
            int tableIndex = 0;
            while (tableIndex < module.getTableCount()) {
                BinTable binTable = module.getBinTableList().get(tableIndex);
                int tableAddress = binTable.getTableAddress();
                int itemIndex = 0;
                while (itemIndex < binTable.getTableBinItemList().size()) {
                    BinItem binItem = binTable.getTableBinItemList().get(itemIndex);
                    if (!binItem.isHasExport()) {
                        int binOffsetAddress = binItem.getOffsetAddress();
                        int binStartBit = binItem.getStartBit();
                        int binbits = binItem.getBits();
                        BinModuleType binModuleType = binItem.getmModuleRef().getBinModuleHead().getModuleType();
                        RegBinAction writeOrRead = binItem.getWriteOrRead();
                        int binAbsoluteAddr = tableAddress & 0xFFFFFF00 | binOffsetAddress & 0xFF;
                        if (absoluteAddr == binAbsoluteAddr && startBit == binStartBit && bits == binbits && readOrWrite == writeOrRead.ordinal() && moduleType == binModuleType) {
                            module.setBaseAddr(baseAddr);
                            binItem.setHasExport(true);
                            return binItem;
                        }
                    }
                    ++itemIndex;
                }
                ++tableIndex;
            }
        }
        return null;
    }

    public BinItem seekForItemForGPIO(int absoluteAddr, int offsetAddr, int startBit, PinDemuxHead pinDemuxHead) {
        BinModuleType pinModuleType = pinDemuxHead.getPinModuleType();
        boolean exeForNormalBoot = pinDemuxHead.isExeForNormalBoot();
        boolean exeForStandyWakeup = pinDemuxHead.isExeForStandyWakeup();
        boolean pinNormalChip = pinDemuxHead.isPinNormalChip();
        boolean pinCaChip = pinDemuxHead.isPinCaChip();
        for (BinModule module : this.mListModules) {
            int tableIndex = 0;
            while (tableIndex < module.getTableCount()) {
                BinTable binTable = module.getBinTableList().get(tableIndex);
                int tableAddress = binTable.getTableAddress();
                int itemIndex = 0;
                while (itemIndex < binTable.getTableBinItemList().size()) {
                    BinItem binItem = binTable.getTableBinItemList().get(itemIndex);
                    if (!binItem.isHasExport()) {
                        BinModuleHead binModuleHead;
                        BinModule getmModuleRef;
                        int binOffsetAddress = binItem.getOffsetAddress();
                        int binStartBit = binItem.getStartBit();
                        int binAbsoluteAddr = tableAddress & 0xFFFFFF00 | binOffsetAddress & 0xFF;
                        if (absoluteAddr == binAbsoluteAddr && startBit == binStartBit && (getmModuleRef = binItem.getmModuleRef()) != null && (binModuleHead = getmModuleRef.getBinModuleHead()) != null) {
                            BinModuleType binModuleType = binModuleHead.getModuleType();
                            boolean binNormalBoot = PrepareSetting.convertIntToBoot(binModuleHead.getNormalBoot());
                            boolean binCaChip = PrepareSetting.convertIntToBoot(binModuleHead.getCaChip());
                            boolean binNormalChip = PrepareSetting.convertIntToBoot(binModuleHead.getNormalChip());
                            boolean binStandbyWakeup = PrepareSetting.convertIntToBoot(binModuleHead.getStandbyWakeup());
                            if (binModuleType == pinModuleType && binNormalBoot == exeForNormalBoot && binCaChip == pinCaChip && binNormalChip == pinNormalChip && binStandbyWakeup == exeForStandyWakeup) {
                                binItem.setHasExport(true);
                                return binItem;
                            }
                        }
                    }
                    ++itemIndex;
                }
                ++tableIndex;
            }
        }
        return null;
    }

    public boolean fromFile(byte[] binDataBytes, int pointer) throws IndexOutOfBoundsException {
        block6: {
            if (binDataBytes != null) break block6;
            return false;
        }
        try {
            this.headData = new BinHeadData();
            pointer = this.headData.getHeadDataFromFile(binDataBytes, pointer);
            int regFileSize = binDataBytes.length;
            int allMuduleSize = 0;
            allMuduleSize = regFileSize - pointer - 4;
            int startPointer = 0;
            byte[] curModuleData = BytesUtils.genSubBytes(binDataBytes, pointer, allMuduleSize);
            int curAllMuduleSize = allMuduleSize;
            while (curAllMuduleSize > 0 && !this.checkIsOver(startPointer, curModuleData)) {
                BinModule binModule = new BinModule();
                int curModuleLen = binModule.fromBytes(curModuleData, startPointer);
                if (curModuleLen % 4 != 0) {
                    curModuleLen += 4 - curModuleLen % 4;
                }
                startPointer += curModuleLen;
                curAllMuduleSize -= curModuleLen;
                this.mListModules.add(binModule);
            }
            pointer += allMuduleSize;
            if ((pointer += 4) != regFileSize) {
                System.out.println("boot format is error.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean checkIsOver(int pointer, byte[] curModuleData) {
        int i = 0;
        while (i < 4) {
            if (curModuleData[pointer + i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean toFile(String filePath) {
        if (this.headData == null) {
            return false;
        }
        if (this.headData.getBinName() == null) {
            return false;
        }
        byte[] binData = this.binDataArray();
        int pointer = 0;
        pointer = this.headData.setHeadDataToFile(binData, pointer);
        int i = 0;
        while (i < this.mListModules.size()) {
            BinModule module = this.mListModules.get(i);
            module.toBytes(binData, pointer);
            pointer += module.getBytesSize();
            System.out.println("module = " + module.getBytesSize());
            ++i;
        }
        i = 0;
        while (i < 4) {
            binData[pointer] = 0;
            ++pointer;
            ++i;
        }
        System.out.println("binData = " + binData.length);
        return FileUtils.writeAllBytes(binData, filePath);
    }

    public byte[] binDataArray() {
        int size = 0;
        size += this.headData.getHeadBytesSize();
        int i = 0;
        while (i < this.mListModules.size()) {
            BinModule module = this.mListModules.get(i);
            size += module.getBytesSize();
            ++i;
        }
        byte[] binDataArray = new byte[size += 4];
        return binDataArray;
    }

    public BinHeadData getHeadData() {
        return this.headData;
    }

    public void setHeadData(BinHeadData headData) {
        this.headData = headData;
    }

    public ArrayList<BinModule> getmListModules() {
        return this.mListModules;
    }

    public void setmListModules(ArrayList<BinModule> mListModules) {
        this.mListModules = mListModules;
    }

    public void initBinDataExport(BinData binData) {
        int index = 0;
        while (index < binData.getmListModules().size()) {
            BinModule module = binData.getmListModules().get(index);
            ArrayList<BinTable> binTableList = module.getBinTableList();
            int i = 0;
            while (i < binTableList.size()) {
                BinTable binTable = binTableList.get(i);
                ArrayList<BinItem> tableBinItemList = binTable.getTableBinItemList();
                int j = 0;
                while (j < tableBinItemList.size()) {
                    BinItem binItem = tableBinItemList.get(j);
                    binItem.setHasExport(false);
                    ++j;
                }
                ++i;
            }
            ++index;
        }
    }
}

