/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg.cfg;

import com.hisilicon.hiregbin.model.reg.cfg.CfgBinCommand;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinItem;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinType;
import com.hisilicon.hiregbin.utility.BitUtils;
import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class CfgBinModule {
    protected static final int TYPE_INIT = 1;
    protected static final int TYPE_WAKEUP = 2;
    protected static final int TYPE_BOTH = 3;
    protected static final int HEADER_SIZE = 8;
    protected static final int HEADER_98CV200_SIZE = 6;
    protected static final int LENGTH_OFFSET = 2;
    protected static final int BASEADDR_OFFSET = 4;
    protected CfgBinType mType;
    protected int mBaseAddr;
    protected ArrayList<CfgBinItem> mListItems = new ArrayList();

    public CfgBinType getType() {
        return this.mType;
    }

    public void setType(CfgBinType mType) {
        this.mType = mType;
    }

    public int getBaseAddr() {
        return this.mBaseAddr;
    }

    public void setBaseAddr(int mBaseAddr) {
        this.mBaseAddr = mBaseAddr;
    }

    public void addItem(CfgBinItem item) {
        this.mListItems.add(item);
    }

    public int getItemCount() {
        return this.mListItems.size();
    }

    public CfgBinItem getItem(int index) {
        return this.mListItems.get(index);
    }

    public ArrayList<CfgBinItem> getmListItems() {
        return this.mListItems;
    }

    public void setmListItems(ArrayList<CfgBinItem> mListItems) {
        this.mListItems = mListItems;
    }

    public ArrayList<CfgBinItem> seekForItems(int address, int startBit) {
        ArrayList<CfgBinItem> items = new ArrayList<CfgBinItem>();
        int i = 0;
        while (i < this.mListItems.size()) {
            CfgBinItem item = this.mListItems.get(i);
            int itemStartBit = BitUtils.getStartBit(item.getValueMask());
            if (item.getCmd() == CfgBinCommand.REG_MSK || item.getCmd() == CfgBinCommand.WAIT_MSK) {
                if (item.getAddress() == address && itemStartBit == startBit) {
                    items.add(item);
                }
            } else if (item.getAddress() == address) {
                items.add(item);
            }
            ++i;
        }
        return items;
    }

    public void recalcByteUse() {
        int i = 0;
        while (i < this.mListItems.size()) {
            CfgBinItem item = this.mListItems.get(i);
            item.recalcBytesUse();
            ++i;
        }
    }

    public int getBytesSize() {
        int size = 8;
        int i = 0;
        while (i < this.mListItems.size()) {
            CfgBinItem item = this.mListItems.get(i);
            size += item.getBytesSize();
            ++i;
        }
        return size;
    }

    public int fromBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        int pointer = offset;
        byte type = buffer[pointer];
        int length = BytesArrayUtils.getShort(buffer, pointer + 2, ByteOrder.BIG_ENDIAN);
        this.mBaseAddr = BytesArrayUtils.getInt(buffer, pointer + 4, ByteOrder.BIG_ENDIAN);
        pointer += 8;
        if (type == 1) {
            this.mType = CfgBinType.INIT;
        } else if (type == 2) {
            this.mType = CfgBinType.WAKEUP;
        } else if (type == 3) {
            this.mType = CfgBinType.BOTH;
        } else {
            return -1;
        }
        int useLen = 0;
        while (useLen < length) {
            CfgBinItem item = new CfgBinItem(this);
            int readSize = item.fromBytes(buffer, pointer);
            if (readSize < 0) {
                return -1;
            }
            pointer += readSize;
            if ((useLen += readSize) < length) {
                readSize = item.delayFromBytes(buffer, pointer);
                if (readSize < 0) {
                    return -1;
                }
                pointer += readSize;
                useLen += readSize;
            }
            this.mListItems.add(item);
        }
        return pointer - offset;
    }

    public int toBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        int pointer = offset;
        buffer[pointer] = (byte)this.mType.getValue();
        BytesArrayUtils.setInt(buffer, pointer + 4, this.mBaseAddr, ByteOrder.BIG_ENDIAN);
        int startPointer = pointer += 8;
        int i = 0;
        while (i < this.mListItems.size()) {
            CfgBinItem item = this.mListItems.get(i);
            int writeSize = item.toBytes(buffer, pointer);
            pointer += writeSize;
            ++i;
        }
        short length = (short)(pointer - startPointer);
        BytesArrayUtils.setShort(buffer, offset + 2, length, ByteOrder.BIG_ENDIAN);
        return pointer - offset;
    }
}

