/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg.bin;

import com.hisilicon.hiregbin.model.reg.bin.RegBinAction;
import com.hisilicon.hiregbin.model.reg.bin.RegBinItem;
import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import com.hisilicon.hiregbin.utility.FileUtils;
import com.hisilicon.hiregbin.views.RegbinView;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class RegBinData {
    protected static final String TIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    protected static final String VERSITON = "v1.1.1";
    protected static final String VERSITON_MV310 = "v1.5.0";
    protected static final int SHORT_SIZE = 2;
    protected static final int INT_SIZE = 4;
    protected static final int REGBIN_VERSION_SIZE = 16;
    protected static final int REGBIN_OFFSET_SIZE = 4;
    protected static final int REGBIN_RESERVED_SIZE_1 = 8;
    protected static final int REGBIN_SUBVERSION_SIZE = 8;
    protected static final int REGBIN_INFO_SIZE = 32;
    protected static final int REGBIN_RESERVED_SIZE_2 = 32;
    protected static final int REGBIN_ITEM_SIZE = 16;
    protected static final int REGBIN_SEPARATOR_SIZE = 48;
    protected static final int REGBIN_NUM = 2;
    protected static final int REGBIN_END_SIZE = 16;
    protected String mVersion = RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV410") || RegbinView.getCurrentChip().equalsIgnoreCase("Hi3716MV420") ? "v1.1.1" : "v1.5.0";
    protected String mSubVersion;
    protected String mName;
    protected String mTime;
    protected ArrayList<RegBinItem> mListItems = new ArrayList();

    public RegBinItem getItem(int index) {
        if (index < 0 || index > this.mListItems.size() - 1) {
            return null;
        }
        return this.mListItems.get(index);
    }

    public RegBinItem seekForItem(int address, RegBinAction action, int attributes) {
        if (action == null || action == RegBinAction.NONE) {
            return null;
        }
        int i = 0;
        while (i < this.mListItems.size()) {
            RegBinItem item = this.mListItems.get(i);
            if (item.getAddress() == address && item.getAttributes() == attributes && !item.isHasExport()) {
                item.setHasExport(true);
                return item;
            }
            ++i;
        }
        return null;
    }

    public RegBinItem seekForItemForBase(int address, RegBinAction action, int startBit) {
        if (action == null || action == RegBinAction.NONE) {
            return null;
        }
        int i = 0;
        while (i < this.mListItems.size()) {
            RegBinItem item = this.mListItems.get(i);
            if (item.getAddress() == address && item.getStartBit(action) == startBit) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public RegBinItem seekForItem(int address) {
        int i = 0;
        while (i < this.mListItems.size()) {
            RegBinItem item = this.mListItems.get(i);
            if (item.getAddress() == address) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public RegBinItem seekForSecondSameItem(int address) {
        int i = 0;
        while (i < this.mListItems.size()) {
            RegBinItem item = this.mListItems.get(i);
            if (item.getAddress() == address) {
                int j = i + 1;
                while (j < this.mListItems.size()) {
                    RegBinItem nextItem = this.mListItems.get(j);
                    if (nextItem.getAddress() == address) {
                        return nextItem;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public RegBinItem seekForItem(int address, int startBit, int value) {
        int i = 0;
        while (i < this.mListItems.size()) {
            RegBinItem item = this.mListItems.get(i);
            RegBinAction action = null;
            if (item.isActionEnabled(RegBinAction.READ)) {
                action = RegBinAction.READ;
            } else if (item.isActionEnabled(RegBinAction.WRITE)) {
                action = RegBinAction.WRITE;
            }
            int bit = item.getStartBit(action);
            if (item.getAddress() == address && bit == startBit && item.getValue() == value) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public boolean addItem(RegBinItem item) {
        this.mListItems.add(item);
        return true;
    }

    public int getItemCount(int groupIndex) {
        if (groupIndex == 0) {
            return this.mListItems.size();
        }
        int count = 0;
        int i = 0;
        while (i < this.mListItems.size()) {
            if (this.mListItems.get(i).getGroupIndex() == groupIndex) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public boolean fromFile(String filePath) throws IndexOutOfBoundsException {
        byte[] binData;
        block9: {
            binData = FileUtils.readAllBytes(filePath);
            if (binData != null) break block9;
            return false;
        }
        try {
            int pointer = 0;
            this.mVersion = BytesArrayUtils.getString(binData, pointer, 16);
            pointer += 16;
            int[] offset = new int[4];
            int i = 0;
            while (i < 2) {
                offset[i] = BytesArrayUtils.getInt(binData, pointer, ByteOrder.LITTLE_ENDIAN);
                pointer += 4;
                ++i;
            }
            pointer += 8;
            this.mSubVersion = BytesArrayUtils.getString(binData, pointer += 32, 8);
            StringBuilder sbTime = new StringBuilder();
            byte ch = binData[pointer += 8];
            ++pointer;
            while (ch != 0) {
                sbTime.append((char)ch);
                ch = binData[pointer];
                ++pointer;
            }
            this.mTime = sbTime.toString();
            StringBuilder sbName = new StringBuilder();
            ch = binData[pointer];
            ++pointer;
            while (ch != 0) {
                sbName.append((char)ch);
                ch = binData[pointer];
                ++pointer;
            }
            this.mName = sbName.toString();
            int i2 = 0;
            while (i2 < 2) {
                if (offset[i2] != 0) {
                    pointer = offset[i2];
                    boolean isContinue = BytesArrayUtils.isAllSame((byte)0, binData, pointer, 16);
                    while (!isContinue) {
                        RegBinItem item = new RegBinItem();
                        item.setContentCatrgory(i2 + 1);
                        item.fromBytes(binData, pointer);
                        this.addItem(item);
                        isContinue = BytesArrayUtils.isAllSame((byte)0, binData, pointer += 16, 16);
                    }
                }
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean toFile(String filePath) {
        if (this.mVersion == null || this.mName == null) {
            return false;
        }
        Date timeNow = new Date();
        SimpleDateFormat df = new SimpleDateFormat(TIME_FORMAT);
        this.mTime = df.format(timeNow);
        int size = 0;
        int[] offset = new int[4];
        size += 16;
        size += 8;
        size += 8;
        size += 32;
        int infoSize = 8 + this.mName.length() + 1 + this.mTime.length() + 1;
        size = infoSize % 32 == 0 ? (size += infoSize) : (size += infoSize + (32 - infoSize % 32));
        int i = 0;
        while (i < 2) {
            int itemCount = this.getItemCount(i + 1);
            offset[i] = size;
            size += 16 * itemCount + 48;
            ++i;
        }
        byte[] binData = new byte[size += 16];
        int i2 = 0;
        while (i2 < size) {
            binData[i2] = 0;
            ++i2;
        }
        int pointer = 0;
        BytesArrayUtils.setString(binData, pointer, 16, this.mVersion);
        pointer += 16;
        int i3 = 0;
        while (i3 < 2) {
            BytesArrayUtils.setInt(binData, pointer, offset[i3], ByteOrder.LITTLE_ENDIAN);
            pointer += 4;
            ++i3;
        }
        pointer += 8;
        BytesArrayUtils.setString(binData, pointer += 32, 8, this.mSubVersion);
        BytesArrayUtils.setString(binData, pointer += 8, this.mTime.length(), this.mTime);
        BytesArrayUtils.setString(binData, pointer += this.mTime.length() + 1, this.mName.length(), this.mName);
        pointer += this.mName.length() + 1;
        i3 = 0;
        while (i3 < this.mListItems.size()) {
            RegBinItem item = this.mListItems.get(i3);
            if (item == null) {
                return false;
            }
            int group = item.getGroupIndex() - 1;
            BytesArrayUtils.setInt(binData, offset[group], item.getAddress(), ByteOrder.LITTLE_ENDIAN);
            int n = group;
            offset[n] = offset[n] + 4;
            BytesArrayUtils.setInt(binData, offset[group], item.getValue(), ByteOrder.LITTLE_ENDIAN);
            int n2 = group;
            offset[n2] = offset[n2] + 4;
            BytesArrayUtils.setInt(binData, offset[group], item.getDelay(), ByteOrder.LITTLE_ENDIAN);
            int n3 = group;
            offset[n3] = offset[n3] + 4;
            BytesArrayUtils.setInt(binData, offset[group], item.getAttributes(), ByteOrder.LITTLE_ENDIAN);
            int n4 = group;
            offset[n4] = offset[n4] + 4;
            ++i3;
        }
        return FileUtils.writeAllBytes(binData, filePath);
    }

    public ArrayList<RegBinItem> getmListItems() {
        return this.mListItems;
    }

    public void setmListItems(ArrayList<RegBinItem> mListItems) {
        this.mListItems = mListItems;
    }

    public String getmVersion() {
        return this.mVersion;
    }

    public void setmVersion(String mVersion) {
        this.mVersion = mVersion;
    }

    public String getmSubVersion() {
        return this.mSubVersion;
    }

    public void setmSubVersion(String mSubVersion) {
        this.mSubVersion = mSubVersion;
    }

    public String getmName() {
        return this.mName;
    }

    public void setmName(String mName) {
        this.mName = mName;
    }

    public String getmTime() {
        return this.mTime;
    }

    public void setmTime(String mTime) {
        this.mTime = mTime;
    }
}

